package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ImageRegistryConfigStorageFluentImpl<A extends ImageRegistryConfigStorageFluent<A>> extends BaseFluent<A> implements ImageRegistryConfigStorageFluent<A>{
  public ImageRegistryConfigStorageFluentImpl() {
  }
  public ImageRegistryConfigStorageFluentImpl(ImageRegistryConfigStorage instance) {
    this.withAzure(instance.getAzure()); 
    this.withEmptyDir(instance.getEmptyDir()); 
    this.withGcs(instance.getGcs()); 
    this.withIbmcos(instance.getIbmcos()); 
    this.withManagementState(instance.getManagementState()); 
    this.withPvc(instance.getPvc()); 
    this.withS3(instance.getS3()); 
    this.withSwift(instance.getSwift()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ImageRegistryConfigStorageAzureBuilder azure;
  private ImageRegistryConfigStorageEmptyDirBuilder emptyDir;
  private ImageRegistryConfigStorageGCSBuilder gcs;
  private ImageRegistryConfigStorageIBMCOSBuilder ibmcos;
  private String managementState;
  private ImageRegistryConfigStoragePVCBuilder pvc;
  private ImageRegistryConfigStorageS3Builder s3;
  private ImageRegistryConfigStorageSwiftBuilder swift;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildAzure instead.
   * @return The buildable object.
   */
  @Deprecated
  public ImageRegistryConfigStorageAzure getAzure() {
    return this.azure!=null ?this.azure.build():null;
  }
  public ImageRegistryConfigStorageAzure buildAzure() {
    return this.azure!=null ?this.azure.build():null;
  }
  public A withAzure(ImageRegistryConfigStorageAzure azure) {
    _visitables.get("azure").remove(this.azure);
    if (azure!=null){ this.azure= new ImageRegistryConfigStorageAzureBuilder(azure); _visitables.get("azure").add(this.azure);} else { this.azure = null; _visitables.get("azure").remove(this.azure); } return (A) this;
  }
  public Boolean hasAzure() {
    return this.azure != null;
  }
  public A withNewAzure(String accountName,String cloudName,String container) {
    return (A)withAzure(new ImageRegistryConfigStorageAzure(accountName, cloudName, container));
  }
  public ImageRegistryConfigStorageFluent.AzureNested<A> withNewAzure() {
    return new ImageRegistryConfigStorageFluentImpl.AzureNestedImpl();
  }
  public ImageRegistryConfigStorageFluent.AzureNested<A> withNewAzureLike(ImageRegistryConfigStorageAzure item) {
    return new ImageRegistryConfigStorageFluentImpl.AzureNestedImpl(item);
  }
  public ImageRegistryConfigStorageFluent.AzureNested<A> editAzure() {
    return withNewAzureLike(getAzure());
  }
  public ImageRegistryConfigStorageFluent.AzureNested<A> editOrNewAzure() {
    return withNewAzureLike(getAzure() != null ? getAzure(): new ImageRegistryConfigStorageAzureBuilder().build());
  }
  public ImageRegistryConfigStorageFluent.AzureNested<A> editOrNewAzureLike(ImageRegistryConfigStorageAzure item) {
    return withNewAzureLike(getAzure() != null ? getAzure(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildEmptyDir instead.
   * @return The buildable object.
   */
  @Deprecated
  public ImageRegistryConfigStorageEmptyDir getEmptyDir() {
    return this.emptyDir!=null ?this.emptyDir.build():null;
  }
  public ImageRegistryConfigStorageEmptyDir buildEmptyDir() {
    return this.emptyDir!=null ?this.emptyDir.build():null;
  }
  public A withEmptyDir(ImageRegistryConfigStorageEmptyDir emptyDir) {
    _visitables.get("emptyDir").remove(this.emptyDir);
    if (emptyDir!=null){ this.emptyDir= new ImageRegistryConfigStorageEmptyDirBuilder(emptyDir); _visitables.get("emptyDir").add(this.emptyDir);} else { this.emptyDir = null; _visitables.get("emptyDir").remove(this.emptyDir); } return (A) this;
  }
  public Boolean hasEmptyDir() {
    return this.emptyDir != null;
  }
  public ImageRegistryConfigStorageFluent.EmptyDirNested<A> withNewEmptyDir() {
    return new ImageRegistryConfigStorageFluentImpl.EmptyDirNestedImpl();
  }
  public ImageRegistryConfigStorageFluent.EmptyDirNested<A> withNewEmptyDirLike(ImageRegistryConfigStorageEmptyDir item) {
    return new ImageRegistryConfigStorageFluentImpl.EmptyDirNestedImpl(item);
  }
  public ImageRegistryConfigStorageFluent.EmptyDirNested<A> editEmptyDir() {
    return withNewEmptyDirLike(getEmptyDir());
  }
  public ImageRegistryConfigStorageFluent.EmptyDirNested<A> editOrNewEmptyDir() {
    return withNewEmptyDirLike(getEmptyDir() != null ? getEmptyDir(): new ImageRegistryConfigStorageEmptyDirBuilder().build());
  }
  public ImageRegistryConfigStorageFluent.EmptyDirNested<A> editOrNewEmptyDirLike(ImageRegistryConfigStorageEmptyDir item) {
    return withNewEmptyDirLike(getEmptyDir() != null ? getEmptyDir(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGcs instead.
   * @return The buildable object.
   */
  @Deprecated
  public ImageRegistryConfigStorageGCS getGcs() {
    return this.gcs!=null ?this.gcs.build():null;
  }
  public ImageRegistryConfigStorageGCS buildGcs() {
    return this.gcs!=null ?this.gcs.build():null;
  }
  public A withGcs(ImageRegistryConfigStorageGCS gcs) {
    _visitables.get("gcs").remove(this.gcs);
    if (gcs!=null){ this.gcs= new ImageRegistryConfigStorageGCSBuilder(gcs); _visitables.get("gcs").add(this.gcs);} else { this.gcs = null; _visitables.get("gcs").remove(this.gcs); } return (A) this;
  }
  public Boolean hasGcs() {
    return this.gcs != null;
  }
  public A withNewGcs(String bucket,String keyID,String projectID,String region) {
    return (A)withGcs(new ImageRegistryConfigStorageGCS(bucket, keyID, projectID, region));
  }
  public ImageRegistryConfigStorageFluent.GcsNested<A> withNewGcs() {
    return new ImageRegistryConfigStorageFluentImpl.GcsNestedImpl();
  }
  public ImageRegistryConfigStorageFluent.GcsNested<A> withNewGcsLike(ImageRegistryConfigStorageGCS item) {
    return new ImageRegistryConfigStorageFluentImpl.GcsNestedImpl(item);
  }
  public ImageRegistryConfigStorageFluent.GcsNested<A> editGcs() {
    return withNewGcsLike(getGcs());
  }
  public ImageRegistryConfigStorageFluent.GcsNested<A> editOrNewGcs() {
    return withNewGcsLike(getGcs() != null ? getGcs(): new ImageRegistryConfigStorageGCSBuilder().build());
  }
  public ImageRegistryConfigStorageFluent.GcsNested<A> editOrNewGcsLike(ImageRegistryConfigStorageGCS item) {
    return withNewGcsLike(getGcs() != null ? getGcs(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildIbmcos instead.
   * @return The buildable object.
   */
  @Deprecated
  public ImageRegistryConfigStorageIBMCOS getIbmcos() {
    return this.ibmcos!=null ?this.ibmcos.build():null;
  }
  public ImageRegistryConfigStorageIBMCOS buildIbmcos() {
    return this.ibmcos!=null ?this.ibmcos.build():null;
  }
  public A withIbmcos(ImageRegistryConfigStorageIBMCOS ibmcos) {
    _visitables.get("ibmcos").remove(this.ibmcos);
    if (ibmcos!=null){ this.ibmcos= new ImageRegistryConfigStorageIBMCOSBuilder(ibmcos); _visitables.get("ibmcos").add(this.ibmcos);} else { this.ibmcos = null; _visitables.get("ibmcos").remove(this.ibmcos); } return (A) this;
  }
  public Boolean hasIbmcos() {
    return this.ibmcos != null;
  }
  public A withNewIbmcos(String bucket,String location,String resourceGroupName,String resourceKeyCRN,String serviceInstanceCRN) {
    return (A)withIbmcos(new ImageRegistryConfigStorageIBMCOS(bucket, location, resourceGroupName, resourceKeyCRN, serviceInstanceCRN));
  }
  public ImageRegistryConfigStorageFluent.IbmcosNested<A> withNewIbmcos() {
    return new ImageRegistryConfigStorageFluentImpl.IbmcosNestedImpl();
  }
  public ImageRegistryConfigStorageFluent.IbmcosNested<A> withNewIbmcosLike(ImageRegistryConfigStorageIBMCOS item) {
    return new ImageRegistryConfigStorageFluentImpl.IbmcosNestedImpl(item);
  }
  public ImageRegistryConfigStorageFluent.IbmcosNested<A> editIbmcos() {
    return withNewIbmcosLike(getIbmcos());
  }
  public ImageRegistryConfigStorageFluent.IbmcosNested<A> editOrNewIbmcos() {
    return withNewIbmcosLike(getIbmcos() != null ? getIbmcos(): new ImageRegistryConfigStorageIBMCOSBuilder().build());
  }
  public ImageRegistryConfigStorageFluent.IbmcosNested<A> editOrNewIbmcosLike(ImageRegistryConfigStorageIBMCOS item) {
    return withNewIbmcosLike(getIbmcos() != null ? getIbmcos(): item);
  }
  public String getManagementState() {
    return this.managementState;
  }
  public A withManagementState(String managementState) {
    this.managementState=managementState; return (A) this;
  }
  public Boolean hasManagementState() {
    return this.managementState != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPvc instead.
   * @return The buildable object.
   */
  @Deprecated
  public ImageRegistryConfigStoragePVC getPvc() {
    return this.pvc!=null ?this.pvc.build():null;
  }
  public ImageRegistryConfigStoragePVC buildPvc() {
    return this.pvc!=null ?this.pvc.build():null;
  }
  public A withPvc(ImageRegistryConfigStoragePVC pvc) {
    _visitables.get("pvc").remove(this.pvc);
    if (pvc!=null){ this.pvc= new ImageRegistryConfigStoragePVCBuilder(pvc); _visitables.get("pvc").add(this.pvc);} else { this.pvc = null; _visitables.get("pvc").remove(this.pvc); } return (A) this;
  }
  public Boolean hasPvc() {
    return this.pvc != null;
  }
  public A withNewPvc(String claim) {
    return (A)withPvc(new ImageRegistryConfigStoragePVC(claim));
  }
  public ImageRegistryConfigStorageFluent.PvcNested<A> withNewPvc() {
    return new ImageRegistryConfigStorageFluentImpl.PvcNestedImpl();
  }
  public ImageRegistryConfigStorageFluent.PvcNested<A> withNewPvcLike(ImageRegistryConfigStoragePVC item) {
    return new ImageRegistryConfigStorageFluentImpl.PvcNestedImpl(item);
  }
  public ImageRegistryConfigStorageFluent.PvcNested<A> editPvc() {
    return withNewPvcLike(getPvc());
  }
  public ImageRegistryConfigStorageFluent.PvcNested<A> editOrNewPvc() {
    return withNewPvcLike(getPvc() != null ? getPvc(): new ImageRegistryConfigStoragePVCBuilder().build());
  }
  public ImageRegistryConfigStorageFluent.PvcNested<A> editOrNewPvcLike(ImageRegistryConfigStoragePVC item) {
    return withNewPvcLike(getPvc() != null ? getPvc(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildS3 instead.
   * @return The buildable object.
   */
  @Deprecated
  public ImageRegistryConfigStorageS3 getS3() {
    return this.s3!=null ?this.s3.build():null;
  }
  public ImageRegistryConfigStorageS3 buildS3() {
    return this.s3!=null ?this.s3.build():null;
  }
  public A withS3(ImageRegistryConfigStorageS3 s3) {
    _visitables.get("s3").remove(this.s3);
    if (s3!=null){ this.s3= new ImageRegistryConfigStorageS3Builder(s3); _visitables.get("s3").add(this.s3);} else { this.s3 = null; _visitables.get("s3").remove(this.s3); } return (A) this;
  }
  public Boolean hasS3() {
    return this.s3 != null;
  }
  public ImageRegistryConfigStorageFluent.S3Nested<A> withNewS3() {
    return new ImageRegistryConfigStorageFluentImpl.S3NestedImpl();
  }
  public ImageRegistryConfigStorageFluent.S3Nested<A> withNewS3Like(ImageRegistryConfigStorageS3 item) {
    return new ImageRegistryConfigStorageFluentImpl.S3NestedImpl(item);
  }
  public ImageRegistryConfigStorageFluent.S3Nested<A> editS3() {
    return withNewS3Like(getS3());
  }
  public ImageRegistryConfigStorageFluent.S3Nested<A> editOrNewS3() {
    return withNewS3Like(getS3() != null ? getS3(): new ImageRegistryConfigStorageS3Builder().build());
  }
  public ImageRegistryConfigStorageFluent.S3Nested<A> editOrNewS3Like(ImageRegistryConfigStorageS3 item) {
    return withNewS3Like(getS3() != null ? getS3(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSwift instead.
   * @return The buildable object.
   */
  @Deprecated
  public ImageRegistryConfigStorageSwift getSwift() {
    return this.swift!=null ?this.swift.build():null;
  }
  public ImageRegistryConfigStorageSwift buildSwift() {
    return this.swift!=null ?this.swift.build():null;
  }
  public A withSwift(ImageRegistryConfigStorageSwift swift) {
    _visitables.get("swift").remove(this.swift);
    if (swift!=null){ this.swift= new ImageRegistryConfigStorageSwiftBuilder(swift); _visitables.get("swift").add(this.swift);} else { this.swift = null; _visitables.get("swift").remove(this.swift); } return (A) this;
  }
  public Boolean hasSwift() {
    return this.swift != null;
  }
  public ImageRegistryConfigStorageFluent.SwiftNested<A> withNewSwift() {
    return new ImageRegistryConfigStorageFluentImpl.SwiftNestedImpl();
  }
  public ImageRegistryConfigStorageFluent.SwiftNested<A> withNewSwiftLike(ImageRegistryConfigStorageSwift item) {
    return new ImageRegistryConfigStorageFluentImpl.SwiftNestedImpl(item);
  }
  public ImageRegistryConfigStorageFluent.SwiftNested<A> editSwift() {
    return withNewSwiftLike(getSwift());
  }
  public ImageRegistryConfigStorageFluent.SwiftNested<A> editOrNewSwift() {
    return withNewSwiftLike(getSwift() != null ? getSwift(): new ImageRegistryConfigStorageSwiftBuilder().build());
  }
  public ImageRegistryConfigStorageFluent.SwiftNested<A> editOrNewSwiftLike(ImageRegistryConfigStorageSwift item) {
    return withNewSwiftLike(getSwift() != null ? getSwift(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ImageRegistryConfigStorageFluentImpl that = (ImageRegistryConfigStorageFluentImpl) o;
    if (azure != null ? !azure.equals(that.azure) :that.azure != null) return false;
    if (emptyDir != null ? !emptyDir.equals(that.emptyDir) :that.emptyDir != null) return false;
    if (gcs != null ? !gcs.equals(that.gcs) :that.gcs != null) return false;
    if (ibmcos != null ? !ibmcos.equals(that.ibmcos) :that.ibmcos != null) return false;
    if (managementState != null ? !managementState.equals(that.managementState) :that.managementState != null) return false;
    if (pvc != null ? !pvc.equals(that.pvc) :that.pvc != null) return false;
    if (s3 != null ? !s3.equals(that.s3) :that.s3 != null) return false;
    if (swift != null ? !swift.equals(that.swift) :that.swift != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(azure,  emptyDir,  gcs,  ibmcos,  managementState,  pvc,  s3,  swift,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (azure != null) { sb.append("azure:"); sb.append(azure + ","); }
    if (emptyDir != null) { sb.append("emptyDir:"); sb.append(emptyDir + ","); }
    if (gcs != null) { sb.append("gcs:"); sb.append(gcs + ","); }
    if (ibmcos != null) { sb.append("ibmcos:"); sb.append(ibmcos + ","); }
    if (managementState != null) { sb.append("managementState:"); sb.append(managementState + ","); }
    if (pvc != null) { sb.append("pvc:"); sb.append(pvc + ","); }
    if (s3 != null) { sb.append("s3:"); sb.append(s3 + ","); }
    if (swift != null) { sb.append("swift:"); sb.append(swift + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AzureNestedImpl<N> extends ImageRegistryConfigStorageAzureFluentImpl<ImageRegistryConfigStorageFluent.AzureNested<N>> implements ImageRegistryConfigStorageFluent.AzureNested<N>,Nested<N>{
    AzureNestedImpl(ImageRegistryConfigStorageAzure item) {
      this.builder = new ImageRegistryConfigStorageAzureBuilder(this, item);
    }
    AzureNestedImpl() {
      this.builder = new ImageRegistryConfigStorageAzureBuilder(this);
    }
    ImageRegistryConfigStorageAzureBuilder builder;
    public N and() {
      return (N) ImageRegistryConfigStorageFluentImpl.this.withAzure(builder.build());
    }
    public N endAzure() {
      return and();
    }
    
  }
  class EmptyDirNestedImpl<N> extends ImageRegistryConfigStorageEmptyDirFluentImpl<ImageRegistryConfigStorageFluent.EmptyDirNested<N>> implements ImageRegistryConfigStorageFluent.EmptyDirNested<N>,Nested<N>{
    EmptyDirNestedImpl(ImageRegistryConfigStorageEmptyDir item) {
      this.builder = new ImageRegistryConfigStorageEmptyDirBuilder(this, item);
    }
    EmptyDirNestedImpl() {
      this.builder = new ImageRegistryConfigStorageEmptyDirBuilder(this);
    }
    ImageRegistryConfigStorageEmptyDirBuilder builder;
    public N and() {
      return (N) ImageRegistryConfigStorageFluentImpl.this.withEmptyDir(builder.build());
    }
    public N endEmptyDir() {
      return and();
    }
    
  }
  class GcsNestedImpl<N> extends ImageRegistryConfigStorageGCSFluentImpl<ImageRegistryConfigStorageFluent.GcsNested<N>> implements ImageRegistryConfigStorageFluent.GcsNested<N>,Nested<N>{
    GcsNestedImpl(ImageRegistryConfigStorageGCS item) {
      this.builder = new ImageRegistryConfigStorageGCSBuilder(this, item);
    }
    GcsNestedImpl() {
      this.builder = new ImageRegistryConfigStorageGCSBuilder(this);
    }
    ImageRegistryConfigStorageGCSBuilder builder;
    public N and() {
      return (N) ImageRegistryConfigStorageFluentImpl.this.withGcs(builder.build());
    }
    public N endGcs() {
      return and();
    }
    
  }
  class IbmcosNestedImpl<N> extends ImageRegistryConfigStorageIBMCOSFluentImpl<ImageRegistryConfigStorageFluent.IbmcosNested<N>> implements ImageRegistryConfigStorageFluent.IbmcosNested<N>,Nested<N>{
    IbmcosNestedImpl(ImageRegistryConfigStorageIBMCOS item) {
      this.builder = new ImageRegistryConfigStorageIBMCOSBuilder(this, item);
    }
    IbmcosNestedImpl() {
      this.builder = new ImageRegistryConfigStorageIBMCOSBuilder(this);
    }
    ImageRegistryConfigStorageIBMCOSBuilder builder;
    public N and() {
      return (N) ImageRegistryConfigStorageFluentImpl.this.withIbmcos(builder.build());
    }
    public N endIbmcos() {
      return and();
    }
    
  }
  class PvcNestedImpl<N> extends ImageRegistryConfigStoragePVCFluentImpl<ImageRegistryConfigStorageFluent.PvcNested<N>> implements ImageRegistryConfigStorageFluent.PvcNested<N>,Nested<N>{
    PvcNestedImpl(ImageRegistryConfigStoragePVC item) {
      this.builder = new ImageRegistryConfigStoragePVCBuilder(this, item);
    }
    PvcNestedImpl() {
      this.builder = new ImageRegistryConfigStoragePVCBuilder(this);
    }
    ImageRegistryConfigStoragePVCBuilder builder;
    public N and() {
      return (N) ImageRegistryConfigStorageFluentImpl.this.withPvc(builder.build());
    }
    public N endPvc() {
      return and();
    }
    
  }
  class S3NestedImpl<N> extends ImageRegistryConfigStorageS3FluentImpl<ImageRegistryConfigStorageFluent.S3Nested<N>> implements ImageRegistryConfigStorageFluent.S3Nested<N>,Nested<N>{
    S3NestedImpl(ImageRegistryConfigStorageS3 item) {
      this.builder = new ImageRegistryConfigStorageS3Builder(this, item);
    }
    S3NestedImpl() {
      this.builder = new ImageRegistryConfigStorageS3Builder(this);
    }
    ImageRegistryConfigStorageS3Builder builder;
    public N and() {
      return (N) ImageRegistryConfigStorageFluentImpl.this.withS3(builder.build());
    }
    public N endS3() {
      return and();
    }
    
  }
  class SwiftNestedImpl<N> extends ImageRegistryConfigStorageSwiftFluentImpl<ImageRegistryConfigStorageFluent.SwiftNested<N>> implements ImageRegistryConfigStorageFluent.SwiftNested<N>,Nested<N>{
    SwiftNestedImpl(ImageRegistryConfigStorageSwift item) {
      this.builder = new ImageRegistryConfigStorageSwiftBuilder(this, item);
    }
    SwiftNestedImpl() {
      this.builder = new ImageRegistryConfigStorageSwiftBuilder(this);
    }
    ImageRegistryConfigStorageSwiftBuilder builder;
    public N and() {
      return (N) ImageRegistryConfigStorageFluentImpl.this.withSwift(builder.build());
    }
    public N endSwift() {
      return and();
    }
    
  }
  
}