package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageRegistryConfigStorageS3Builder extends ImageRegistryConfigStorageS3FluentImpl<ImageRegistryConfigStorageS3Builder> implements VisitableBuilder<ImageRegistryConfigStorageS3,ImageRegistryConfigStorageS3Builder>{
  public ImageRegistryConfigStorageS3Builder() {
    this(false);
  }
  public ImageRegistryConfigStorageS3Builder(Boolean validationEnabled) {
    this(new ImageRegistryConfigStorageS3(), validationEnabled);
  }
  public ImageRegistryConfigStorageS3Builder(ImageRegistryConfigStorageS3Fluent<?> fluent) {
    this(fluent, false);
  }
  public ImageRegistryConfigStorageS3Builder(ImageRegistryConfigStorageS3Fluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageRegistryConfigStorageS3(), validationEnabled);
  }
  public ImageRegistryConfigStorageS3Builder(ImageRegistryConfigStorageS3Fluent<?> fluent,ImageRegistryConfigStorageS3 instance) {
    this(fluent, instance, false);
  }
  public ImageRegistryConfigStorageS3Builder(ImageRegistryConfigStorageS3Fluent<?> fluent,ImageRegistryConfigStorageS3 instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBucket(instance.getBucket()); 
    fluent.withCloudFront(instance.getCloudFront()); 
    fluent.withEncrypt(instance.getEncrypt()); 
    fluent.withKeyID(instance.getKeyID()); 
    fluent.withRegion(instance.getRegion()); 
    fluent.withRegionEndpoint(instance.getRegionEndpoint()); 
    fluent.withVirtualHostedStyle(instance.getVirtualHostedStyle()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageRegistryConfigStorageS3Builder(ImageRegistryConfigStorageS3 instance) {
    this(instance,false);
  }
  public ImageRegistryConfigStorageS3Builder(ImageRegistryConfigStorageS3 instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withBucket(instance.getBucket()); 
    this.withCloudFront(instance.getCloudFront()); 
    this.withEncrypt(instance.getEncrypt()); 
    this.withKeyID(instance.getKeyID()); 
    this.withRegion(instance.getRegion()); 
    this.withRegionEndpoint(instance.getRegionEndpoint()); 
    this.withVirtualHostedStyle(instance.getVirtualHostedStyle()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ImageRegistryConfigStorageS3Fluent<?> fluent;
  Boolean validationEnabled;
  public ImageRegistryConfigStorageS3 build() {
    ImageRegistryConfigStorageS3 buildable = new ImageRegistryConfigStorageS3(fluent.getBucket(),fluent.getCloudFront(),fluent.getEncrypt(),fluent.getKeyID(),fluent.getRegion(),fluent.getRegionEndpoint(),fluent.getVirtualHostedStyle());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}