package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CPUBuilder extends CPUFluentImpl<CPUBuilder> implements VisitableBuilder<CPU,CPUBuilder>{
  public CPUBuilder() {
    this(false);
  }
  public CPUBuilder(Boolean validationEnabled) {
    this(new CPU(), validationEnabled);
  }
  public CPUBuilder(CPUFluent<?> fluent) {
    this(fluent, false);
  }
  public CPUBuilder(CPUFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CPU(), validationEnabled);
  }
  public CPUBuilder(CPUFluent<?> fluent,CPU instance) {
    this(fluent, instance, false);
  }
  public CPUBuilder(CPUFluent<?> fluent,CPU instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withArch(instance.getArch()); 
    fluent.withClockMegahertz(instance.getClockMegahertz()); 
    fluent.withCount(instance.getCount()); 
    fluent.withFlags(instance.getFlags()); 
    fluent.withModel(instance.getModel()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CPUBuilder(CPU instance) {
    this(instance,false);
  }
  public CPUBuilder(CPU instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withArch(instance.getArch()); 
    this.withClockMegahertz(instance.getClockMegahertz()); 
    this.withCount(instance.getCount()); 
    this.withFlags(instance.getFlags()); 
    this.withModel(instance.getModel()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  CPUFluent<?> fluent;
  Boolean validationEnabled;
  public CPU build() {
    CPU buildable = new CPU(fluent.getArch(),fluent.getClockMegahertz(),fluent.getCount(),fluent.getFlags(),fluent.getModel());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}