package io.fabric8.openshift.api.model.miscellaneous.network.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertSpecBuilder extends CertSpecFluentImpl<CertSpecBuilder> implements VisitableBuilder<CertSpec,CertSpecBuilder>{
  public CertSpecBuilder() {
    this(false);
  }
  public CertSpecBuilder(Boolean validationEnabled) {
    this(new CertSpec(), validationEnabled);
  }
  public CertSpecBuilder(CertSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public CertSpecBuilder(CertSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CertSpec(), validationEnabled);
  }
  public CertSpecBuilder(CertSpecFluent<?> fluent,CertSpec instance) {
    this(fluent, instance, false);
  }
  public CertSpecBuilder(CertSpecFluent<?> fluent,CertSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCommonName(instance.getCommonName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CertSpecBuilder(CertSpec instance) {
    this(instance,false);
  }
  public CertSpecBuilder(CertSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCommonName(instance.getCommonName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  CertSpecFluent<?> fluent;
  Boolean validationEnabled;
  public CertSpec build() {
    CertSpec buildable = new CertSpec(fluent.getCommonName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}