package io.fabric8.openshift.api.model.miscellaneous.network.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class EgressRouterSpecFluentImpl<A extends EgressRouterSpecFluent<A>> extends BaseFluent<A> implements EgressRouterSpecFluent<A>{
  public EgressRouterSpecFluentImpl() {
  }
  public EgressRouterSpecFluentImpl(EgressRouterSpec instance) {
    this.withAddresses(instance.getAddresses()); 
    this.withMode(instance.getMode()); 
    this.withNetworkInterface(instance.getNetworkInterface()); 
    this.withRedirect(instance.getRedirect()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<EgressRouterAddressBuilder> addresses = new ArrayList<EgressRouterAddressBuilder>();
  private String mode;
  private EgressRouterInterfaceBuilder networkInterface;
  private RedirectConfigBuilder redirect;
  private Map<String,Object> additionalProperties;
  public A addToAddresses(Integer index,EgressRouterAddress item) {
    if (this.addresses == null) {this.addresses = new ArrayList<EgressRouterAddressBuilder>();}
    EgressRouterAddressBuilder builder = new EgressRouterAddressBuilder(item);_visitables.get("addresses").add(index >= 0 ? index : _visitables.get("addresses").size(), builder);this.addresses.add(index >= 0 ? index : addresses.size(), builder); return (A)this;
  }
  public A setToAddresses(Integer index,EgressRouterAddress item) {
    if (this.addresses == null) {this.addresses = new ArrayList<EgressRouterAddressBuilder>();}
    EgressRouterAddressBuilder builder = new EgressRouterAddressBuilder(item);
    if (index < 0 || index >= _visitables.get("addresses").size()) { _visitables.get("addresses").add(builder); } else { _visitables.get("addresses").set(index, builder);}
    if (index < 0 || index >= addresses.size()) { addresses.add(builder); } else { addresses.set(index, builder);}
     return (A)this;
  }
  public A addToAddresses(io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.EgressRouterAddress... items) {
    if (this.addresses == null) {this.addresses = new ArrayList<EgressRouterAddressBuilder>();}
    for (EgressRouterAddress item : items) {EgressRouterAddressBuilder builder = new EgressRouterAddressBuilder(item);_visitables.get("addresses").add(builder);this.addresses.add(builder);} return (A)this;
  }
  public A addAllToAddresses(Collection<EgressRouterAddress> items) {
    if (this.addresses == null) {this.addresses = new ArrayList<EgressRouterAddressBuilder>();}
    for (EgressRouterAddress item : items) {EgressRouterAddressBuilder builder = new EgressRouterAddressBuilder(item);_visitables.get("addresses").add(builder);this.addresses.add(builder);} return (A)this;
  }
  public A removeFromAddresses(io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.EgressRouterAddress... items) {
    for (EgressRouterAddress item : items) {EgressRouterAddressBuilder builder = new EgressRouterAddressBuilder(item);_visitables.get("addresses").remove(builder);if (this.addresses != null) {this.addresses.remove(builder);}} return (A)this;
  }
  public A removeAllFromAddresses(Collection<EgressRouterAddress> items) {
    for (EgressRouterAddress item : items) {EgressRouterAddressBuilder builder = new EgressRouterAddressBuilder(item);_visitables.get("addresses").remove(builder);if (this.addresses != null) {this.addresses.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAddresses(Predicate<EgressRouterAddressBuilder> predicate) {
    if (addresses == null) return (A) this;
    final Iterator<EgressRouterAddressBuilder> each = addresses.iterator();
    final List visitables = _visitables.get("addresses");
    while (each.hasNext()) {
      EgressRouterAddressBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAddresses instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<EgressRouterAddress> getAddresses() {
    return addresses != null ? build(addresses) : null;
  }
  public List<EgressRouterAddress> buildAddresses() {
    return addresses != null ? build(addresses) : null;
  }
  public EgressRouterAddress buildAddress(Integer index) {
    return this.addresses.get(index).build();
  }
  public EgressRouterAddress buildFirstAddress() {
    return this.addresses.get(0).build();
  }
  public EgressRouterAddress buildLastAddress() {
    return this.addresses.get(addresses.size() - 1).build();
  }
  public EgressRouterAddress buildMatchingAddress(Predicate<EgressRouterAddressBuilder> predicate) {
    for (EgressRouterAddressBuilder item: addresses) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingAddress(Predicate<EgressRouterAddressBuilder> predicate) {
    for (EgressRouterAddressBuilder item: addresses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAddresses(List<EgressRouterAddress> addresses) {
    if (this.addresses != null) { _visitables.get("addresses").removeAll(this.addresses);}
    if (addresses != null) {this.addresses = new ArrayList(); for (EgressRouterAddress item : addresses){this.addToAddresses(item);}} else { this.addresses = null;} return (A) this;
  }
  public A withAddresses(io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.EgressRouterAddress... addresses) {
    if (this.addresses != null) {this.addresses.clear();}
    if (addresses != null) {for (EgressRouterAddress item :addresses){ this.addToAddresses(item);}} return (A) this;
  }
  public Boolean hasAddresses() {
    return addresses != null && !addresses.isEmpty();
  }
  public A addNewAddress(String gateway,String ip) {
    return (A)addToAddresses(new EgressRouterAddress(gateway, ip));
  }
  public EgressRouterSpecFluent.AddressesNested<A> addNewAddress() {
    return new EgressRouterSpecFluentImpl.AddressesNestedImpl();
  }
  public EgressRouterSpecFluent.AddressesNested<A> addNewAddressLike(EgressRouterAddress item) {
    return new EgressRouterSpecFluentImpl.AddressesNestedImpl(-1, item);
  }
  public EgressRouterSpecFluent.AddressesNested<A> setNewAddressLike(Integer index,EgressRouterAddress item) {
    return new EgressRouterSpecFluentImpl.AddressesNestedImpl(index, item);
  }
  public EgressRouterSpecFluent.AddressesNested<A> editAddress(Integer index) {
    if (addresses.size() <= index) throw new RuntimeException("Can't edit addresses. Index exceeds size.");
    return setNewAddressLike(index, buildAddress(index));
  }
  public EgressRouterSpecFluent.AddressesNested<A> editFirstAddress() {
    if (addresses.size() == 0) throw new RuntimeException("Can't edit first addresses. The list is empty.");
    return setNewAddressLike(0, buildAddress(0));
  }
  public EgressRouterSpecFluent.AddressesNested<A> editLastAddress() {
    int index = addresses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last addresses. The list is empty.");
    return setNewAddressLike(index, buildAddress(index));
  }
  public EgressRouterSpecFluent.AddressesNested<A> editMatchingAddress(Predicate<EgressRouterAddressBuilder> predicate) {
    int index = -1;
    for (int i=0;i<addresses.size();i++) { 
    if (predicate.test(addresses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching addresses. No match found.");
    return setNewAddressLike(index, buildAddress(index));
  }
  public String getMode() {
    return this.mode;
  }
  public A withMode(String mode) {
    this.mode=mode; return (A) this;
  }
  public Boolean hasMode() {
    return this.mode != null;
  }
  
  /**
   * This method has been deprecated, please use method buildNetworkInterface instead.
   * @return The buildable object.
   */
  @Deprecated
  public EgressRouterInterface getNetworkInterface() {
    return this.networkInterface!=null ?this.networkInterface.build():null;
  }
  public EgressRouterInterface buildNetworkInterface() {
    return this.networkInterface!=null ?this.networkInterface.build():null;
  }
  public A withNetworkInterface(EgressRouterInterface networkInterface) {
    _visitables.get("networkInterface").remove(this.networkInterface);
    if (networkInterface!=null){ this.networkInterface= new EgressRouterInterfaceBuilder(networkInterface); _visitables.get("networkInterface").add(this.networkInterface);} else { this.networkInterface = null; _visitables.get("networkInterface").remove(this.networkInterface); } return (A) this;
  }
  public Boolean hasNetworkInterface() {
    return this.networkInterface != null;
  }
  public EgressRouterSpecFluent.NetworkInterfaceNested<A> withNewNetworkInterface() {
    return new EgressRouterSpecFluentImpl.NetworkInterfaceNestedImpl();
  }
  public EgressRouterSpecFluent.NetworkInterfaceNested<A> withNewNetworkInterfaceLike(EgressRouterInterface item) {
    return new EgressRouterSpecFluentImpl.NetworkInterfaceNestedImpl(item);
  }
  public EgressRouterSpecFluent.NetworkInterfaceNested<A> editNetworkInterface() {
    return withNewNetworkInterfaceLike(getNetworkInterface());
  }
  public EgressRouterSpecFluent.NetworkInterfaceNested<A> editOrNewNetworkInterface() {
    return withNewNetworkInterfaceLike(getNetworkInterface() != null ? getNetworkInterface(): new EgressRouterInterfaceBuilder().build());
  }
  public EgressRouterSpecFluent.NetworkInterfaceNested<A> editOrNewNetworkInterfaceLike(EgressRouterInterface item) {
    return withNewNetworkInterfaceLike(getNetworkInterface() != null ? getNetworkInterface(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRedirect instead.
   * @return The buildable object.
   */
  @Deprecated
  public RedirectConfig getRedirect() {
    return this.redirect!=null ?this.redirect.build():null;
  }
  public RedirectConfig buildRedirect() {
    return this.redirect!=null ?this.redirect.build():null;
  }
  public A withRedirect(RedirectConfig redirect) {
    _visitables.get("redirect").remove(this.redirect);
    if (redirect!=null){ this.redirect= new RedirectConfigBuilder(redirect); _visitables.get("redirect").add(this.redirect);} else { this.redirect = null; _visitables.get("redirect").remove(this.redirect); } return (A) this;
  }
  public Boolean hasRedirect() {
    return this.redirect != null;
  }
  public EgressRouterSpecFluent.RedirectNested<A> withNewRedirect() {
    return new EgressRouterSpecFluentImpl.RedirectNestedImpl();
  }
  public EgressRouterSpecFluent.RedirectNested<A> withNewRedirectLike(RedirectConfig item) {
    return new EgressRouterSpecFluentImpl.RedirectNestedImpl(item);
  }
  public EgressRouterSpecFluent.RedirectNested<A> editRedirect() {
    return withNewRedirectLike(getRedirect());
  }
  public EgressRouterSpecFluent.RedirectNested<A> editOrNewRedirect() {
    return withNewRedirectLike(getRedirect() != null ? getRedirect(): new RedirectConfigBuilder().build());
  }
  public EgressRouterSpecFluent.RedirectNested<A> editOrNewRedirectLike(RedirectConfig item) {
    return withNewRedirectLike(getRedirect() != null ? getRedirect(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EgressRouterSpecFluentImpl that = (EgressRouterSpecFluentImpl) o;
    if (addresses != null ? !addresses.equals(that.addresses) :that.addresses != null) return false;
    if (mode != null ? !mode.equals(that.mode) :that.mode != null) return false;
    if (networkInterface != null ? !networkInterface.equals(that.networkInterface) :that.networkInterface != null) return false;
    if (redirect != null ? !redirect.equals(that.redirect) :that.redirect != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(addresses,  mode,  networkInterface,  redirect,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (addresses != null && !addresses.isEmpty()) { sb.append("addresses:"); sb.append(addresses + ","); }
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (networkInterface != null) { sb.append("networkInterface:"); sb.append(networkInterface + ","); }
    if (redirect != null) { sb.append("redirect:"); sb.append(redirect + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AddressesNestedImpl<N> extends EgressRouterAddressFluentImpl<EgressRouterSpecFluent.AddressesNested<N>> implements EgressRouterSpecFluent.AddressesNested<N>,Nested<N>{
    AddressesNestedImpl(Integer index,EgressRouterAddress item) {
      this.index = index;
      this.builder = new EgressRouterAddressBuilder(this, item);
    }
    AddressesNestedImpl() {
      this.index = -1;
      this.builder = new EgressRouterAddressBuilder(this);
    }
    EgressRouterAddressBuilder builder;
    Integer index;
    public N and() {
      return (N) EgressRouterSpecFluentImpl.this.setToAddresses(index,builder.build());
    }
    public N endAddress() {
      return and();
    }
    
  }
  class NetworkInterfaceNestedImpl<N> extends EgressRouterInterfaceFluentImpl<EgressRouterSpecFluent.NetworkInterfaceNested<N>> implements EgressRouterSpecFluent.NetworkInterfaceNested<N>,Nested<N>{
    NetworkInterfaceNestedImpl(EgressRouterInterface item) {
      this.builder = new EgressRouterInterfaceBuilder(this, item);
    }
    NetworkInterfaceNestedImpl() {
      this.builder = new EgressRouterInterfaceBuilder(this);
    }
    EgressRouterInterfaceBuilder builder;
    public N and() {
      return (N) EgressRouterSpecFluentImpl.this.withNetworkInterface(builder.build());
    }
    public N endNetworkInterface() {
      return and();
    }
    
  }
  class RedirectNestedImpl<N> extends RedirectConfigFluentImpl<EgressRouterSpecFluent.RedirectNested<N>> implements EgressRouterSpecFluent.RedirectNested<N>,Nested<N>{
    RedirectNestedImpl(RedirectConfig item) {
      this.builder = new RedirectConfigBuilder(this, item);
    }
    RedirectNestedImpl() {
      this.builder = new RedirectConfigBuilder(this);
    }
    RedirectConfigBuilder builder;
    public N and() {
      return (N) EgressRouterSpecFluentImpl.this.withRedirect(builder.build());
    }
    public N endRedirect() {
      return and();
    }
    
  }
  
}