package io.fabric8.openshift.api.model.miscellaneous.network.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RedirectConfigBuilder extends RedirectConfigFluentImpl<RedirectConfigBuilder> implements VisitableBuilder<RedirectConfig,RedirectConfigBuilder>{
  public RedirectConfigBuilder() {
    this(false);
  }
  public RedirectConfigBuilder(Boolean validationEnabled) {
    this(new RedirectConfig(), validationEnabled);
  }
  public RedirectConfigBuilder(RedirectConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public RedirectConfigBuilder(RedirectConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RedirectConfig(), validationEnabled);
  }
  public RedirectConfigBuilder(RedirectConfigFluent<?> fluent,RedirectConfig instance) {
    this(fluent, instance, false);
  }
  public RedirectConfigBuilder(RedirectConfigFluent<?> fluent,RedirectConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withFallbackIP(instance.getFallbackIP()); 
    fluent.withRedirectRules(instance.getRedirectRules()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RedirectConfigBuilder(RedirectConfig instance) {
    this(instance,false);
  }
  public RedirectConfigBuilder(RedirectConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withFallbackIP(instance.getFallbackIP()); 
    this.withRedirectRules(instance.getRedirectRules()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  RedirectConfigFluent<?> fluent;
  Boolean validationEnabled;
  public RedirectConfig build() {
    RedirectConfig buildable = new RedirectConfig(fluent.getFallbackIP(),fluent.getRedirectRules());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}