package io.fabric8.openshift.api.model.miscellaneous.apiserver.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.Condition;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class APIRequestCountStatusFluentImpl<A extends APIRequestCountStatusFluent<A>> extends BaseFluent<A> implements APIRequestCountStatusFluent<A>{
  public APIRequestCountStatusFluentImpl() {
  }
  public APIRequestCountStatusFluentImpl(APIRequestCountStatus instance) {
    this.withConditions(instance.getConditions()); 
    this.withCurrentHour(instance.getCurrentHour()); 
    this.withLast24h(instance.getLast24h()); 
    this.withRemovedInRelease(instance.getRemovedInRelease()); 
    this.withRequestCount(instance.getRequestCount()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<Condition> conditions = new ArrayList<Condition>();
  private PerResourceAPIRequestLogBuilder currentHour;
  private ArrayList<PerResourceAPIRequestLogBuilder> last24h = new ArrayList<PerResourceAPIRequestLogBuilder>();
  private String removedInRelease;
  private Long requestCount;
  private Map<String,Object> additionalProperties;
  public A addToConditions(Integer index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  public A setToConditions(Integer index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.set(index, item); return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    for (Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<Condition> items) {
    for (Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public List<Condition> getConditions() {
    return this.conditions;
  }
  public Condition getCondition(Integer index) {
    return this.conditions.get(index);
  }
  public Condition getFirstCondition() {
    return this.conditions.get(0);
  }
  public Condition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  public Condition getMatchingCondition(Predicate<Condition> predicate) {
    for (Condition item: conditions) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<Condition> predicate) {
    for (Condition item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<Condition> conditions) {
    if (conditions != null) {this.conditions = new ArrayList(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildCurrentHour instead.
   * @return The buildable object.
   */
  @Deprecated
  public PerResourceAPIRequestLog getCurrentHour() {
    return this.currentHour!=null ?this.currentHour.build():null;
  }
  public PerResourceAPIRequestLog buildCurrentHour() {
    return this.currentHour!=null ?this.currentHour.build():null;
  }
  public A withCurrentHour(PerResourceAPIRequestLog currentHour) {
    _visitables.get("currentHour").remove(this.currentHour);
    if (currentHour!=null){ this.currentHour= new PerResourceAPIRequestLogBuilder(currentHour); _visitables.get("currentHour").add(this.currentHour);} else { this.currentHour = null; _visitables.get("currentHour").remove(this.currentHour); } return (A) this;
  }
  public Boolean hasCurrentHour() {
    return this.currentHour != null;
  }
  public APIRequestCountStatusFluent.CurrentHourNested<A> withNewCurrentHour() {
    return new APIRequestCountStatusFluentImpl.CurrentHourNestedImpl();
  }
  public APIRequestCountStatusFluent.CurrentHourNested<A> withNewCurrentHourLike(PerResourceAPIRequestLog item) {
    return new APIRequestCountStatusFluentImpl.CurrentHourNestedImpl(item);
  }
  public APIRequestCountStatusFluent.CurrentHourNested<A> editCurrentHour() {
    return withNewCurrentHourLike(getCurrentHour());
  }
  public APIRequestCountStatusFluent.CurrentHourNested<A> editOrNewCurrentHour() {
    return withNewCurrentHourLike(getCurrentHour() != null ? getCurrentHour(): new PerResourceAPIRequestLogBuilder().build());
  }
  public APIRequestCountStatusFluent.CurrentHourNested<A> editOrNewCurrentHourLike(PerResourceAPIRequestLog item) {
    return withNewCurrentHourLike(getCurrentHour() != null ? getCurrentHour(): item);
  }
  public A addToLast24h(Integer index,PerResourceAPIRequestLog item) {
    if (this.last24h == null) {this.last24h = new ArrayList<PerResourceAPIRequestLogBuilder>();}
    PerResourceAPIRequestLogBuilder builder = new PerResourceAPIRequestLogBuilder(item);_visitables.get("last24h").add(index >= 0 ? index : _visitables.get("last24h").size(), builder);this.last24h.add(index >= 0 ? index : last24h.size(), builder); return (A)this;
  }
  public A setToLast24h(Integer index,PerResourceAPIRequestLog item) {
    if (this.last24h == null) {this.last24h = new ArrayList<PerResourceAPIRequestLogBuilder>();}
    PerResourceAPIRequestLogBuilder builder = new PerResourceAPIRequestLogBuilder(item);
    if (index < 0 || index >= _visitables.get("last24h").size()) { _visitables.get("last24h").add(builder); } else { _visitables.get("last24h").set(index, builder);}
    if (index < 0 || index >= last24h.size()) { last24h.add(builder); } else { last24h.set(index, builder);}
     return (A)this;
  }
  public A addToLast24h(io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLog... items) {
    if (this.last24h == null) {this.last24h = new ArrayList<PerResourceAPIRequestLogBuilder>();}
    for (PerResourceAPIRequestLog item : items) {PerResourceAPIRequestLogBuilder builder = new PerResourceAPIRequestLogBuilder(item);_visitables.get("last24h").add(builder);this.last24h.add(builder);} return (A)this;
  }
  public A addAllToLast24h(Collection<PerResourceAPIRequestLog> items) {
    if (this.last24h == null) {this.last24h = new ArrayList<PerResourceAPIRequestLogBuilder>();}
    for (PerResourceAPIRequestLog item : items) {PerResourceAPIRequestLogBuilder builder = new PerResourceAPIRequestLogBuilder(item);_visitables.get("last24h").add(builder);this.last24h.add(builder);} return (A)this;
  }
  public A removeFromLast24h(io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLog... items) {
    for (PerResourceAPIRequestLog item : items) {PerResourceAPIRequestLogBuilder builder = new PerResourceAPIRequestLogBuilder(item);_visitables.get("last24h").remove(builder);if (this.last24h != null) {this.last24h.remove(builder);}} return (A)this;
  }
  public A removeAllFromLast24h(Collection<PerResourceAPIRequestLog> items) {
    for (PerResourceAPIRequestLog item : items) {PerResourceAPIRequestLogBuilder builder = new PerResourceAPIRequestLogBuilder(item);_visitables.get("last24h").remove(builder);if (this.last24h != null) {this.last24h.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromLast24h(Predicate<PerResourceAPIRequestLogBuilder> predicate) {
    if (last24h == null) return (A) this;
    final Iterator<PerResourceAPIRequestLogBuilder> each = last24h.iterator();
    final List visitables = _visitables.get("last24h");
    while (each.hasNext()) {
      PerResourceAPIRequestLogBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildLast24h instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<PerResourceAPIRequestLog> getLast24h() {
    return last24h != null ? build(last24h) : null;
  }
  public List<PerResourceAPIRequestLog> buildLast24h() {
    return last24h != null ? build(last24h) : null;
  }
  public PerResourceAPIRequestLog buildLast24h(Integer index) {
    return this.last24h.get(index).build();
  }
  public PerResourceAPIRequestLog buildFirstLast24h() {
    return this.last24h.get(0).build();
  }
  public PerResourceAPIRequestLog buildLastLast24h() {
    return this.last24h.get(last24h.size() - 1).build();
  }
  public PerResourceAPIRequestLog buildMatchingLast24h(Predicate<PerResourceAPIRequestLogBuilder> predicate) {
    for (PerResourceAPIRequestLogBuilder item: last24h) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingLast24h(Predicate<PerResourceAPIRequestLogBuilder> predicate) {
    for (PerResourceAPIRequestLogBuilder item: last24h) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withLast24h(List<PerResourceAPIRequestLog> last24h) {
    if (this.last24h != null) { _visitables.get("last24h").removeAll(this.last24h);}
    if (last24h != null) {this.last24h = new ArrayList(); for (PerResourceAPIRequestLog item : last24h){this.addToLast24h(item);}} else { this.last24h = null;} return (A) this;
  }
  public A withLast24h(io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerResourceAPIRequestLog... last24h) {
    if (this.last24h != null) {this.last24h.clear();}
    if (last24h != null) {for (PerResourceAPIRequestLog item :last24h){ this.addToLast24h(item);}} return (A) this;
  }
  public Boolean hasLast24h() {
    return last24h != null && !last24h.isEmpty();
  }
  public APIRequestCountStatusFluent.Last24hNested<A> addNewLast24h() {
    return new APIRequestCountStatusFluentImpl.Last24hNestedImpl();
  }
  public APIRequestCountStatusFluent.Last24hNested<A> addNewLast24hLike(PerResourceAPIRequestLog item) {
    return new APIRequestCountStatusFluentImpl.Last24hNestedImpl(-1, item);
  }
  public APIRequestCountStatusFluent.Last24hNested<A> setNewLast24hLike(Integer index,PerResourceAPIRequestLog item) {
    return new APIRequestCountStatusFluentImpl.Last24hNestedImpl(index, item);
  }
  public APIRequestCountStatusFluent.Last24hNested<A> editLast24h(Integer index) {
    if (last24h.size() <= index) throw new RuntimeException("Can't edit last24h. Index exceeds size.");
    return setNewLast24hLike(index, buildLast24h(index));
  }
  public APIRequestCountStatusFluent.Last24hNested<A> editFirstLast24h() {
    if (last24h.size() == 0) throw new RuntimeException("Can't edit first last24h. The list is empty.");
    return setNewLast24hLike(0, buildLast24h(0));
  }
  public APIRequestCountStatusFluent.Last24hNested<A> editLastLast24h() {
    int index = last24h.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last last24h. The list is empty.");
    return setNewLast24hLike(index, buildLast24h(index));
  }
  public APIRequestCountStatusFluent.Last24hNested<A> editMatchingLast24h(Predicate<PerResourceAPIRequestLogBuilder> predicate) {
    int index = -1;
    for (int i=0;i<last24h.size();i++) { 
    if (predicate.test(last24h.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching last24h. No match found.");
    return setNewLast24hLike(index, buildLast24h(index));
  }
  public String getRemovedInRelease() {
    return this.removedInRelease;
  }
  public A withRemovedInRelease(String removedInRelease) {
    this.removedInRelease=removedInRelease; return (A) this;
  }
  public Boolean hasRemovedInRelease() {
    return this.removedInRelease != null;
  }
  public Long getRequestCount() {
    return this.requestCount;
  }
  public A withRequestCount(Long requestCount) {
    this.requestCount=requestCount; return (A) this;
  }
  public Boolean hasRequestCount() {
    return this.requestCount != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    APIRequestCountStatusFluentImpl that = (APIRequestCountStatusFluentImpl) o;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (currentHour != null ? !currentHour.equals(that.currentHour) :that.currentHour != null) return false;
    if (last24h != null ? !last24h.equals(that.last24h) :that.last24h != null) return false;
    if (removedInRelease != null ? !removedInRelease.equals(that.removedInRelease) :that.removedInRelease != null) return false;
    if (requestCount != null ? !requestCount.equals(that.requestCount) :that.requestCount != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  currentHour,  last24h,  removedInRelease,  requestCount,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (currentHour != null) { sb.append("currentHour:"); sb.append(currentHour + ","); }
    if (last24h != null && !last24h.isEmpty()) { sb.append("last24h:"); sb.append(last24h + ","); }
    if (removedInRelease != null) { sb.append("removedInRelease:"); sb.append(removedInRelease + ","); }
    if (requestCount != null) { sb.append("requestCount:"); sb.append(requestCount + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class CurrentHourNestedImpl<N> extends PerResourceAPIRequestLogFluentImpl<APIRequestCountStatusFluent.CurrentHourNested<N>> implements APIRequestCountStatusFluent.CurrentHourNested<N>,Nested<N>{
    CurrentHourNestedImpl(PerResourceAPIRequestLog item) {
      this.builder = new PerResourceAPIRequestLogBuilder(this, item);
    }
    CurrentHourNestedImpl() {
      this.builder = new PerResourceAPIRequestLogBuilder(this);
    }
    PerResourceAPIRequestLogBuilder builder;
    public N and() {
      return (N) APIRequestCountStatusFluentImpl.this.withCurrentHour(builder.build());
    }
    public N endCurrentHour() {
      return and();
    }
    
  }
  class Last24hNestedImpl<N> extends PerResourceAPIRequestLogFluentImpl<APIRequestCountStatusFluent.Last24hNested<N>> implements APIRequestCountStatusFluent.Last24hNested<N>,Nested<N>{
    Last24hNestedImpl(Integer index,PerResourceAPIRequestLog item) {
      this.index = index;
      this.builder = new PerResourceAPIRequestLogBuilder(this, item);
    }
    Last24hNestedImpl() {
      this.index = -1;
      this.builder = new PerResourceAPIRequestLogBuilder(this);
    }
    PerResourceAPIRequestLogBuilder builder;
    Integer index;
    public N and() {
      return (N) APIRequestCountStatusFluentImpl.this.setToLast24h(index,builder.build());
    }
    public N endLast24h() {
      return and();
    }
    
  }
  
}