package io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CredentialsRequestSpecBuilder extends CredentialsRequestSpecFluentImpl<CredentialsRequestSpecBuilder> implements VisitableBuilder<CredentialsRequestSpec,CredentialsRequestSpecBuilder>{
  public CredentialsRequestSpecBuilder() {
    this(false);
  }
  public CredentialsRequestSpecBuilder(Boolean validationEnabled) {
    this(new CredentialsRequestSpec(), validationEnabled);
  }
  public CredentialsRequestSpecBuilder(CredentialsRequestSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public CredentialsRequestSpecBuilder(CredentialsRequestSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CredentialsRequestSpec(), validationEnabled);
  }
  public CredentialsRequestSpecBuilder(CredentialsRequestSpecFluent<?> fluent,CredentialsRequestSpec instance) {
    this(fluent, instance, false);
  }
  public CredentialsRequestSpecBuilder(CredentialsRequestSpecFluent<?> fluent,CredentialsRequestSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withProviderSpec(instance.getProviderSpec()); 
    fluent.withSecretRef(instance.getSecretRef()); 
    fluent.withServiceAccountNames(instance.getServiceAccountNames()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CredentialsRequestSpecBuilder(CredentialsRequestSpec instance) {
    this(instance,false);
  }
  public CredentialsRequestSpecBuilder(CredentialsRequestSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withProviderSpec(instance.getProviderSpec()); 
    this.withSecretRef(instance.getSecretRef()); 
    this.withServiceAccountNames(instance.getServiceAccountNames()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  CredentialsRequestSpecFluent<?> fluent;
  Boolean validationEnabled;
  public CredentialsRequestSpec build() {
    CredentialsRequestSpec buildable = new CredentialsRequestSpec(fluent.getProviderSpec(),fluent.getSecretRef(),fluent.getServiceAccountNames());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}