package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.Taint;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.SecretReference;
import java.lang.Integer;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class BareMetalHostSpecFluentImpl<A extends BareMetalHostSpecFluent<A>> extends BaseFluent<A> implements BareMetalHostSpecFluent<A>{
  public BareMetalHostSpecFluentImpl() {
  }
  public BareMetalHostSpecFluentImpl(BareMetalHostSpec instance) {
    this.withAutomatedCleaningMode(instance.getAutomatedCleaningMode()); 
    this.withBmc(instance.getBmc()); 
    this.withBootMACAddress(instance.getBootMACAddress()); 
    this.withBootMode(instance.getBootMode()); 
    this.withConsumerRef(instance.getConsumerRef()); 
    this.withCustomDeploy(instance.getCustomDeploy()); 
    this.withDescription(instance.getDescription()); 
    this.withExternallyProvisioned(instance.getExternallyProvisioned()); 
    this.withFirmware(instance.getFirmware()); 
    this.withHardwareProfile(instance.getHardwareProfile()); 
    this.withImage(instance.getImage()); 
    this.withMetaData(instance.getMetaData()); 
    this.withNetworkData(instance.getNetworkData()); 
    this.withOnline(instance.getOnline()); 
    this.withPreprovisioningNetworkDataName(instance.getPreprovisioningNetworkDataName()); 
    this.withRaid(instance.getRaid()); 
    this.withRootDeviceHints(instance.getRootDeviceHints()); 
    this.withTaints(instance.getTaints()); 
    this.withUserData(instance.getUserData()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String automatedCleaningMode;
  private BMCDetailsBuilder bmc;
  private String bootMACAddress;
  private String bootMode;
  private ObjectReferenceBuilder consumerRef;
  private CustomDeployBuilder customDeploy;
  private String description;
  private Boolean externallyProvisioned;
  private FirmwareConfigBuilder firmware;
  private String hardwareProfile;
  private ImageBuilder image;
  private SecretReference metaData;
  private SecretReference networkData;
  private Boolean online;
  private String preprovisioningNetworkDataName;
  private RAIDConfigBuilder raid;
  private RootDeviceHintsBuilder rootDeviceHints;
  private List<Taint> taints = new ArrayList<Taint>();
  private SecretReference userData;
  private Map<String,Object> additionalProperties;
  public String getAutomatedCleaningMode() {
    return this.automatedCleaningMode;
  }
  public A withAutomatedCleaningMode(String automatedCleaningMode) {
    this.automatedCleaningMode=automatedCleaningMode; return (A) this;
  }
  public Boolean hasAutomatedCleaningMode() {
    return this.automatedCleaningMode != null;
  }
  
  /**
   * This method has been deprecated, please use method buildBmc instead.
   * @return The buildable object.
   */
  @Deprecated
  public BMCDetails getBmc() {
    return this.bmc!=null ?this.bmc.build():null;
  }
  public BMCDetails buildBmc() {
    return this.bmc!=null ?this.bmc.build():null;
  }
  public A withBmc(BMCDetails bmc) {
    _visitables.get("bmc").remove(this.bmc);
    if (bmc!=null){ this.bmc= new BMCDetailsBuilder(bmc); _visitables.get("bmc").add(this.bmc);} else { this.bmc = null; _visitables.get("bmc").remove(this.bmc); } return (A) this;
  }
  public Boolean hasBmc() {
    return this.bmc != null;
  }
  public A withNewBmc(String address,String credentialsName,Boolean disableCertificateVerification) {
    return (A)withBmc(new BMCDetails(address, credentialsName, disableCertificateVerification));
  }
  public BareMetalHostSpecFluent.BmcNested<A> withNewBmc() {
    return new BareMetalHostSpecFluentImpl.BmcNestedImpl();
  }
  public BareMetalHostSpecFluent.BmcNested<A> withNewBmcLike(BMCDetails item) {
    return new BareMetalHostSpecFluentImpl.BmcNestedImpl(item);
  }
  public BareMetalHostSpecFluent.BmcNested<A> editBmc() {
    return withNewBmcLike(getBmc());
  }
  public BareMetalHostSpecFluent.BmcNested<A> editOrNewBmc() {
    return withNewBmcLike(getBmc() != null ? getBmc(): new BMCDetailsBuilder().build());
  }
  public BareMetalHostSpecFluent.BmcNested<A> editOrNewBmcLike(BMCDetails item) {
    return withNewBmcLike(getBmc() != null ? getBmc(): item);
  }
  public String getBootMACAddress() {
    return this.bootMACAddress;
  }
  public A withBootMACAddress(String bootMACAddress) {
    this.bootMACAddress=bootMACAddress; return (A) this;
  }
  public Boolean hasBootMACAddress() {
    return this.bootMACAddress != null;
  }
  public String getBootMode() {
    return this.bootMode;
  }
  public A withBootMode(String bootMode) {
    this.bootMode=bootMode; return (A) this;
  }
  public Boolean hasBootMode() {
    return this.bootMode != null;
  }
  
  /**
   * This method has been deprecated, please use method buildConsumerRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getConsumerRef() {
    return this.consumerRef!=null ?this.consumerRef.build():null;
  }
  public ObjectReference buildConsumerRef() {
    return this.consumerRef!=null ?this.consumerRef.build():null;
  }
  public A withConsumerRef(ObjectReference consumerRef) {
    _visitables.get("consumerRef").remove(this.consumerRef);
    if (consumerRef!=null){ this.consumerRef= new ObjectReferenceBuilder(consumerRef); _visitables.get("consumerRef").add(this.consumerRef);} else { this.consumerRef = null; _visitables.get("consumerRef").remove(this.consumerRef); } return (A) this;
  }
  public Boolean hasConsumerRef() {
    return this.consumerRef != null;
  }
  public BareMetalHostSpecFluent.ConsumerRefNested<A> withNewConsumerRef() {
    return new BareMetalHostSpecFluentImpl.ConsumerRefNestedImpl();
  }
  public BareMetalHostSpecFluent.ConsumerRefNested<A> withNewConsumerRefLike(ObjectReference item) {
    return new BareMetalHostSpecFluentImpl.ConsumerRefNestedImpl(item);
  }
  public BareMetalHostSpecFluent.ConsumerRefNested<A> editConsumerRef() {
    return withNewConsumerRefLike(getConsumerRef());
  }
  public BareMetalHostSpecFluent.ConsumerRefNested<A> editOrNewConsumerRef() {
    return withNewConsumerRefLike(getConsumerRef() != null ? getConsumerRef(): new ObjectReferenceBuilder().build());
  }
  public BareMetalHostSpecFluent.ConsumerRefNested<A> editOrNewConsumerRefLike(ObjectReference item) {
    return withNewConsumerRefLike(getConsumerRef() != null ? getConsumerRef(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildCustomDeploy instead.
   * @return The buildable object.
   */
  @Deprecated
  public CustomDeploy getCustomDeploy() {
    return this.customDeploy!=null ?this.customDeploy.build():null;
  }
  public CustomDeploy buildCustomDeploy() {
    return this.customDeploy!=null ?this.customDeploy.build():null;
  }
  public A withCustomDeploy(CustomDeploy customDeploy) {
    _visitables.get("customDeploy").remove(this.customDeploy);
    if (customDeploy!=null){ this.customDeploy= new CustomDeployBuilder(customDeploy); _visitables.get("customDeploy").add(this.customDeploy);} else { this.customDeploy = null; _visitables.get("customDeploy").remove(this.customDeploy); } return (A) this;
  }
  public Boolean hasCustomDeploy() {
    return this.customDeploy != null;
  }
  public A withNewCustomDeploy(String method) {
    return (A)withCustomDeploy(new CustomDeploy(method));
  }
  public BareMetalHostSpecFluent.CustomDeployNested<A> withNewCustomDeploy() {
    return new BareMetalHostSpecFluentImpl.CustomDeployNestedImpl();
  }
  public BareMetalHostSpecFluent.CustomDeployNested<A> withNewCustomDeployLike(CustomDeploy item) {
    return new BareMetalHostSpecFluentImpl.CustomDeployNestedImpl(item);
  }
  public BareMetalHostSpecFluent.CustomDeployNested<A> editCustomDeploy() {
    return withNewCustomDeployLike(getCustomDeploy());
  }
  public BareMetalHostSpecFluent.CustomDeployNested<A> editOrNewCustomDeploy() {
    return withNewCustomDeployLike(getCustomDeploy() != null ? getCustomDeploy(): new CustomDeployBuilder().build());
  }
  public BareMetalHostSpecFluent.CustomDeployNested<A> editOrNewCustomDeployLike(CustomDeploy item) {
    return withNewCustomDeployLike(getCustomDeploy() != null ? getCustomDeploy(): item);
  }
  public String getDescription() {
    return this.description;
  }
  public A withDescription(String description) {
    this.description=description; return (A) this;
  }
  public Boolean hasDescription() {
    return this.description != null;
  }
  public Boolean getExternallyProvisioned() {
    return this.externallyProvisioned;
  }
  public A withExternallyProvisioned(Boolean externallyProvisioned) {
    this.externallyProvisioned=externallyProvisioned; return (A) this;
  }
  public Boolean hasExternallyProvisioned() {
    return this.externallyProvisioned != null;
  }
  
  /**
   * This method has been deprecated, please use method buildFirmware instead.
   * @return The buildable object.
   */
  @Deprecated
  public FirmwareConfig getFirmware() {
    return this.firmware!=null ?this.firmware.build():null;
  }
  public FirmwareConfig buildFirmware() {
    return this.firmware!=null ?this.firmware.build():null;
  }
  public A withFirmware(FirmwareConfig firmware) {
    _visitables.get("firmware").remove(this.firmware);
    if (firmware!=null){ this.firmware= new FirmwareConfigBuilder(firmware); _visitables.get("firmware").add(this.firmware);} else { this.firmware = null; _visitables.get("firmware").remove(this.firmware); } return (A) this;
  }
  public Boolean hasFirmware() {
    return this.firmware != null;
  }
  public A withNewFirmware(Boolean simultaneousMultithreadingEnabled,Boolean sriovEnabled,Boolean virtualizationEnabled) {
    return (A)withFirmware(new FirmwareConfig(simultaneousMultithreadingEnabled, sriovEnabled, virtualizationEnabled));
  }
  public BareMetalHostSpecFluent.FirmwareNested<A> withNewFirmware() {
    return new BareMetalHostSpecFluentImpl.FirmwareNestedImpl();
  }
  public BareMetalHostSpecFluent.FirmwareNested<A> withNewFirmwareLike(FirmwareConfig item) {
    return new BareMetalHostSpecFluentImpl.FirmwareNestedImpl(item);
  }
  public BareMetalHostSpecFluent.FirmwareNested<A> editFirmware() {
    return withNewFirmwareLike(getFirmware());
  }
  public BareMetalHostSpecFluent.FirmwareNested<A> editOrNewFirmware() {
    return withNewFirmwareLike(getFirmware() != null ? getFirmware(): new FirmwareConfigBuilder().build());
  }
  public BareMetalHostSpecFluent.FirmwareNested<A> editOrNewFirmwareLike(FirmwareConfig item) {
    return withNewFirmwareLike(getFirmware() != null ? getFirmware(): item);
  }
  public String getHardwareProfile() {
    return this.hardwareProfile;
  }
  public A withHardwareProfile(String hardwareProfile) {
    this.hardwareProfile=hardwareProfile; return (A) this;
  }
  public Boolean hasHardwareProfile() {
    return this.hardwareProfile != null;
  }
  
  /**
   * This method has been deprecated, please use method buildImage instead.
   * @return The buildable object.
   */
  @Deprecated
  public Image getImage() {
    return this.image!=null ?this.image.build():null;
  }
  public Image buildImage() {
    return this.image!=null ?this.image.build():null;
  }
  public A withImage(Image image) {
    _visitables.get("image").remove(this.image);
    if (image!=null){ this.image= new ImageBuilder(image); _visitables.get("image").add(this.image);} else { this.image = null; _visitables.get("image").remove(this.image); } return (A) this;
  }
  public Boolean hasImage() {
    return this.image != null;
  }
  public A withNewImage(String checksum,String checksumType,String format,String url) {
    return (A)withImage(new Image(checksum, checksumType, format, url));
  }
  public BareMetalHostSpecFluent.ImageNested<A> withNewImage() {
    return new BareMetalHostSpecFluentImpl.ImageNestedImpl();
  }
  public BareMetalHostSpecFluent.ImageNested<A> withNewImageLike(Image item) {
    return new BareMetalHostSpecFluentImpl.ImageNestedImpl(item);
  }
  public BareMetalHostSpecFluent.ImageNested<A> editImage() {
    return withNewImageLike(getImage());
  }
  public BareMetalHostSpecFluent.ImageNested<A> editOrNewImage() {
    return withNewImageLike(getImage() != null ? getImage(): new ImageBuilder().build());
  }
  public BareMetalHostSpecFluent.ImageNested<A> editOrNewImageLike(Image item) {
    return withNewImageLike(getImage() != null ? getImage(): item);
  }
  public SecretReference getMetaData() {
    return this.metaData;
  }
  public A withMetaData(SecretReference metaData) {
    this.metaData=metaData; return (A) this;
  }
  public Boolean hasMetaData() {
    return this.metaData != null;
  }
  public A withNewMetaData(String name,String namespace) {
    return (A)withMetaData(new SecretReference(name, namespace));
  }
  public SecretReference getNetworkData() {
    return this.networkData;
  }
  public A withNetworkData(SecretReference networkData) {
    this.networkData=networkData; return (A) this;
  }
  public Boolean hasNetworkData() {
    return this.networkData != null;
  }
  public A withNewNetworkData(String name,String namespace) {
    return (A)withNetworkData(new SecretReference(name, namespace));
  }
  public Boolean getOnline() {
    return this.online;
  }
  public A withOnline(Boolean online) {
    this.online=online; return (A) this;
  }
  public Boolean hasOnline() {
    return this.online != null;
  }
  public String getPreprovisioningNetworkDataName() {
    return this.preprovisioningNetworkDataName;
  }
  public A withPreprovisioningNetworkDataName(String preprovisioningNetworkDataName) {
    this.preprovisioningNetworkDataName=preprovisioningNetworkDataName; return (A) this;
  }
  public Boolean hasPreprovisioningNetworkDataName() {
    return this.preprovisioningNetworkDataName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildRaid instead.
   * @return The buildable object.
   */
  @Deprecated
  public RAIDConfig getRaid() {
    return this.raid!=null ?this.raid.build():null;
  }
  public RAIDConfig buildRaid() {
    return this.raid!=null ?this.raid.build():null;
  }
  public A withRaid(RAIDConfig raid) {
    _visitables.get("raid").remove(this.raid);
    if (raid!=null){ this.raid= new RAIDConfigBuilder(raid); _visitables.get("raid").add(this.raid);} else { this.raid = null; _visitables.get("raid").remove(this.raid); } return (A) this;
  }
  public Boolean hasRaid() {
    return this.raid != null;
  }
  public BareMetalHostSpecFluent.RaidNested<A> withNewRaid() {
    return new BareMetalHostSpecFluentImpl.RaidNestedImpl();
  }
  public BareMetalHostSpecFluent.RaidNested<A> withNewRaidLike(RAIDConfig item) {
    return new BareMetalHostSpecFluentImpl.RaidNestedImpl(item);
  }
  public BareMetalHostSpecFluent.RaidNested<A> editRaid() {
    return withNewRaidLike(getRaid());
  }
  public BareMetalHostSpecFluent.RaidNested<A> editOrNewRaid() {
    return withNewRaidLike(getRaid() != null ? getRaid(): new RAIDConfigBuilder().build());
  }
  public BareMetalHostSpecFluent.RaidNested<A> editOrNewRaidLike(RAIDConfig item) {
    return withNewRaidLike(getRaid() != null ? getRaid(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRootDeviceHints instead.
   * @return The buildable object.
   */
  @Deprecated
  public RootDeviceHints getRootDeviceHints() {
    return this.rootDeviceHints!=null ?this.rootDeviceHints.build():null;
  }
  public RootDeviceHints buildRootDeviceHints() {
    return this.rootDeviceHints!=null ?this.rootDeviceHints.build():null;
  }
  public A withRootDeviceHints(RootDeviceHints rootDeviceHints) {
    _visitables.get("rootDeviceHints").remove(this.rootDeviceHints);
    if (rootDeviceHints!=null){ this.rootDeviceHints= new RootDeviceHintsBuilder(rootDeviceHints); _visitables.get("rootDeviceHints").add(this.rootDeviceHints);} else { this.rootDeviceHints = null; _visitables.get("rootDeviceHints").remove(this.rootDeviceHints); } return (A) this;
  }
  public Boolean hasRootDeviceHints() {
    return this.rootDeviceHints != null;
  }
  public BareMetalHostSpecFluent.RootDeviceHintsNested<A> withNewRootDeviceHints() {
    return new BareMetalHostSpecFluentImpl.RootDeviceHintsNestedImpl();
  }
  public BareMetalHostSpecFluent.RootDeviceHintsNested<A> withNewRootDeviceHintsLike(RootDeviceHints item) {
    return new BareMetalHostSpecFluentImpl.RootDeviceHintsNestedImpl(item);
  }
  public BareMetalHostSpecFluent.RootDeviceHintsNested<A> editRootDeviceHints() {
    return withNewRootDeviceHintsLike(getRootDeviceHints());
  }
  public BareMetalHostSpecFluent.RootDeviceHintsNested<A> editOrNewRootDeviceHints() {
    return withNewRootDeviceHintsLike(getRootDeviceHints() != null ? getRootDeviceHints(): new RootDeviceHintsBuilder().build());
  }
  public BareMetalHostSpecFluent.RootDeviceHintsNested<A> editOrNewRootDeviceHintsLike(RootDeviceHints item) {
    return withNewRootDeviceHintsLike(getRootDeviceHints() != null ? getRootDeviceHints(): item);
  }
  public A addToTaints(Integer index,Taint item) {
    if (this.taints == null) {this.taints = new ArrayList<Taint>();}
    this.taints.add(index, item);
    return (A)this;
  }
  public A setToTaints(Integer index,Taint item) {
    if (this.taints == null) {this.taints = new ArrayList<Taint>();}
    this.taints.set(index, item); return (A)this;
  }
  public A addToTaints(io.fabric8.kubernetes.api.model.Taint... items) {
    if (this.taints == null) {this.taints = new ArrayList<Taint>();}
    for (Taint item : items) {this.taints.add(item);} return (A)this;
  }
  public A addAllToTaints(Collection<Taint> items) {
    if (this.taints == null) {this.taints = new ArrayList<Taint>();}
    for (Taint item : items) {this.taints.add(item);} return (A)this;
  }
  public A removeFromTaints(io.fabric8.kubernetes.api.model.Taint... items) {
    for (Taint item : items) {if (this.taints!= null){ this.taints.remove(item);}} return (A)this;
  }
  public A removeAllFromTaints(Collection<Taint> items) {
    for (Taint item : items) {if (this.taints!= null){ this.taints.remove(item);}} return (A)this;
  }
  public List<Taint> getTaints() {
    return this.taints;
  }
  public Taint getTaint(Integer index) {
    return this.taints.get(index);
  }
  public Taint getFirstTaint() {
    return this.taints.get(0);
  }
  public Taint getLastTaint() {
    return this.taints.get(taints.size() - 1);
  }
  public Taint getMatchingTaint(Predicate<Taint> predicate) {
    for (Taint item: taints) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingTaint(Predicate<Taint> predicate) {
    for (Taint item: taints) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTaints(List<Taint> taints) {
    if (taints != null) {this.taints = new ArrayList(); for (Taint item : taints){this.addToTaints(item);}} else { this.taints = null;} return (A) this;
  }
  public A withTaints(io.fabric8.kubernetes.api.model.Taint... taints) {
    if (this.taints != null) {this.taints.clear();}
    if (taints != null) {for (Taint item :taints){ this.addToTaints(item);}} return (A) this;
  }
  public Boolean hasTaints() {
    return taints != null && !taints.isEmpty();
  }
  public A addNewTaint(String effect,String key,String timeAdded,String value) {
    return (A)addToTaints(new Taint(effect, key, timeAdded, value));
  }
  public SecretReference getUserData() {
    return this.userData;
  }
  public A withUserData(SecretReference userData) {
    this.userData=userData; return (A) this;
  }
  public Boolean hasUserData() {
    return this.userData != null;
  }
  public A withNewUserData(String name,String namespace) {
    return (A)withUserData(new SecretReference(name, namespace));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BareMetalHostSpecFluentImpl that = (BareMetalHostSpecFluentImpl) o;
    if (automatedCleaningMode != null ? !automatedCleaningMode.equals(that.automatedCleaningMode) :that.automatedCleaningMode != null) return false;
    if (bmc != null ? !bmc.equals(that.bmc) :that.bmc != null) return false;
    if (bootMACAddress != null ? !bootMACAddress.equals(that.bootMACAddress) :that.bootMACAddress != null) return false;
    if (bootMode != null ? !bootMode.equals(that.bootMode) :that.bootMode != null) return false;
    if (consumerRef != null ? !consumerRef.equals(that.consumerRef) :that.consumerRef != null) return false;
    if (customDeploy != null ? !customDeploy.equals(that.customDeploy) :that.customDeploy != null) return false;
    if (description != null ? !description.equals(that.description) :that.description != null) return false;
    if (externallyProvisioned != null ? !externallyProvisioned.equals(that.externallyProvisioned) :that.externallyProvisioned != null) return false;
    if (firmware != null ? !firmware.equals(that.firmware) :that.firmware != null) return false;
    if (hardwareProfile != null ? !hardwareProfile.equals(that.hardwareProfile) :that.hardwareProfile != null) return false;
    if (image != null ? !image.equals(that.image) :that.image != null) return false;
    if (metaData != null ? !metaData.equals(that.metaData) :that.metaData != null) return false;
    if (networkData != null ? !networkData.equals(that.networkData) :that.networkData != null) return false;
    if (online != null ? !online.equals(that.online) :that.online != null) return false;
    if (preprovisioningNetworkDataName != null ? !preprovisioningNetworkDataName.equals(that.preprovisioningNetworkDataName) :that.preprovisioningNetworkDataName != null) return false;
    if (raid != null ? !raid.equals(that.raid) :that.raid != null) return false;
    if (rootDeviceHints != null ? !rootDeviceHints.equals(that.rootDeviceHints) :that.rootDeviceHints != null) return false;
    if (taints != null ? !taints.equals(that.taints) :that.taints != null) return false;
    if (userData != null ? !userData.equals(that.userData) :that.userData != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(automatedCleaningMode,  bmc,  bootMACAddress,  bootMode,  consumerRef,  customDeploy,  description,  externallyProvisioned,  firmware,  hardwareProfile,  image,  metaData,  networkData,  online,  preprovisioningNetworkDataName,  raid,  rootDeviceHints,  taints,  userData,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (automatedCleaningMode != null) { sb.append("automatedCleaningMode:"); sb.append(automatedCleaningMode + ","); }
    if (bmc != null) { sb.append("bmc:"); sb.append(bmc + ","); }
    if (bootMACAddress != null) { sb.append("bootMACAddress:"); sb.append(bootMACAddress + ","); }
    if (bootMode != null) { sb.append("bootMode:"); sb.append(bootMode + ","); }
    if (consumerRef != null) { sb.append("consumerRef:"); sb.append(consumerRef + ","); }
    if (customDeploy != null) { sb.append("customDeploy:"); sb.append(customDeploy + ","); }
    if (description != null) { sb.append("description:"); sb.append(description + ","); }
    if (externallyProvisioned != null) { sb.append("externallyProvisioned:"); sb.append(externallyProvisioned + ","); }
    if (firmware != null) { sb.append("firmware:"); sb.append(firmware + ","); }
    if (hardwareProfile != null) { sb.append("hardwareProfile:"); sb.append(hardwareProfile + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (metaData != null) { sb.append("metaData:"); sb.append(metaData + ","); }
    if (networkData != null) { sb.append("networkData:"); sb.append(networkData + ","); }
    if (online != null) { sb.append("online:"); sb.append(online + ","); }
    if (preprovisioningNetworkDataName != null) { sb.append("preprovisioningNetworkDataName:"); sb.append(preprovisioningNetworkDataName + ","); }
    if (raid != null) { sb.append("raid:"); sb.append(raid + ","); }
    if (rootDeviceHints != null) { sb.append("rootDeviceHints:"); sb.append(rootDeviceHints + ","); }
    if (taints != null && !taints.isEmpty()) { sb.append("taints:"); sb.append(taints + ","); }
    if (userData != null) { sb.append("userData:"); sb.append(userData + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withExternallyProvisioned() {
    return withExternallyProvisioned(true);
  }
  public A withOnline() {
    return withOnline(true);
  }
  class BmcNestedImpl<N> extends BMCDetailsFluentImpl<BareMetalHostSpecFluent.BmcNested<N>> implements BareMetalHostSpecFluent.BmcNested<N>,Nested<N>{
    BmcNestedImpl(BMCDetails item) {
      this.builder = new BMCDetailsBuilder(this, item);
    }
    BmcNestedImpl() {
      this.builder = new BMCDetailsBuilder(this);
    }
    BMCDetailsBuilder builder;
    public N and() {
      return (N) BareMetalHostSpecFluentImpl.this.withBmc(builder.build());
    }
    public N endBmc() {
      return and();
    }
    
  }
  class ConsumerRefNestedImpl<N> extends ObjectReferenceFluentImpl<BareMetalHostSpecFluent.ConsumerRefNested<N>> implements BareMetalHostSpecFluent.ConsumerRefNested<N>,Nested<N>{
    ConsumerRefNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ConsumerRefNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) BareMetalHostSpecFluentImpl.this.withConsumerRef(builder.build());
    }
    public N endConsumerRef() {
      return and();
    }
    
  }
  class CustomDeployNestedImpl<N> extends CustomDeployFluentImpl<BareMetalHostSpecFluent.CustomDeployNested<N>> implements BareMetalHostSpecFluent.CustomDeployNested<N>,Nested<N>{
    CustomDeployNestedImpl(CustomDeploy item) {
      this.builder = new CustomDeployBuilder(this, item);
    }
    CustomDeployNestedImpl() {
      this.builder = new CustomDeployBuilder(this);
    }
    CustomDeployBuilder builder;
    public N and() {
      return (N) BareMetalHostSpecFluentImpl.this.withCustomDeploy(builder.build());
    }
    public N endCustomDeploy() {
      return and();
    }
    
  }
  class FirmwareNestedImpl<N> extends FirmwareConfigFluentImpl<BareMetalHostSpecFluent.FirmwareNested<N>> implements BareMetalHostSpecFluent.FirmwareNested<N>,Nested<N>{
    FirmwareNestedImpl(FirmwareConfig item) {
      this.builder = new FirmwareConfigBuilder(this, item);
    }
    FirmwareNestedImpl() {
      this.builder = new FirmwareConfigBuilder(this);
    }
    FirmwareConfigBuilder builder;
    public N and() {
      return (N) BareMetalHostSpecFluentImpl.this.withFirmware(builder.build());
    }
    public N endFirmware() {
      return and();
    }
    
  }
  class ImageNestedImpl<N> extends ImageFluentImpl<BareMetalHostSpecFluent.ImageNested<N>> implements BareMetalHostSpecFluent.ImageNested<N>,Nested<N>{
    ImageNestedImpl(Image item) {
      this.builder = new ImageBuilder(this, item);
    }
    ImageNestedImpl() {
      this.builder = new ImageBuilder(this);
    }
    ImageBuilder builder;
    public N and() {
      return (N) BareMetalHostSpecFluentImpl.this.withImage(builder.build());
    }
    public N endImage() {
      return and();
    }
    
  }
  class RaidNestedImpl<N> extends RAIDConfigFluentImpl<BareMetalHostSpecFluent.RaidNested<N>> implements BareMetalHostSpecFluent.RaidNested<N>,Nested<N>{
    RaidNestedImpl(RAIDConfig item) {
      this.builder = new RAIDConfigBuilder(this, item);
    }
    RaidNestedImpl() {
      this.builder = new RAIDConfigBuilder(this);
    }
    RAIDConfigBuilder builder;
    public N and() {
      return (N) BareMetalHostSpecFluentImpl.this.withRaid(builder.build());
    }
    public N endRaid() {
      return and();
    }
    
  }
  class RootDeviceHintsNestedImpl<N> extends RootDeviceHintsFluentImpl<BareMetalHostSpecFluent.RootDeviceHintsNested<N>> implements BareMetalHostSpecFluent.RootDeviceHintsNested<N>,Nested<N>{
    RootDeviceHintsNestedImpl(RootDeviceHints item) {
      this.builder = new RootDeviceHintsBuilder(this, item);
    }
    RootDeviceHintsNestedImpl() {
      this.builder = new RootDeviceHintsBuilder(this);
    }
    RootDeviceHintsBuilder builder;
    public N and() {
      return (N) BareMetalHostSpecFluentImpl.this.withRootDeviceHints(builder.build());
    }
    public N endRootDeviceHints() {
      return and();
    }
    
  }
  
}