package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HardwareDetailsBuilder extends HardwareDetailsFluentImpl<HardwareDetailsBuilder> implements VisitableBuilder<HardwareDetails,HardwareDetailsBuilder>{
  public HardwareDetailsBuilder() {
    this(false);
  }
  public HardwareDetailsBuilder(Boolean validationEnabled) {
    this(new HardwareDetails(), validationEnabled);
  }
  public HardwareDetailsBuilder(HardwareDetailsFluent<?> fluent) {
    this(fluent, false);
  }
  public HardwareDetailsBuilder(HardwareDetailsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HardwareDetails(), validationEnabled);
  }
  public HardwareDetailsBuilder(HardwareDetailsFluent<?> fluent,HardwareDetails instance) {
    this(fluent, instance, false);
  }
  public HardwareDetailsBuilder(HardwareDetailsFluent<?> fluent,HardwareDetails instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCpu(instance.getCpu()); 
    fluent.withFirmware(instance.getFirmware()); 
    fluent.withHostname(instance.getHostname()); 
    fluent.withNics(instance.getNics()); 
    fluent.withRamMebibytes(instance.getRamMebibytes()); 
    fluent.withStorage(instance.getStorage()); 
    fluent.withSystemVendor(instance.getSystemVendor()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HardwareDetailsBuilder(HardwareDetails instance) {
    this(instance,false);
  }
  public HardwareDetailsBuilder(HardwareDetails instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCpu(instance.getCpu()); 
    this.withFirmware(instance.getFirmware()); 
    this.withHostname(instance.getHostname()); 
    this.withNics(instance.getNics()); 
    this.withRamMebibytes(instance.getRamMebibytes()); 
    this.withStorage(instance.getStorage()); 
    this.withSystemVendor(instance.getSystemVendor()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  HardwareDetailsFluent<?> fluent;
  Boolean validationEnabled;
  public HardwareDetails build() {
    HardwareDetails buildable = new HardwareDetails(fluent.getCpu(),fluent.getFirmware(),fluent.getHostname(),fluent.getNics(),fluent.getRamMebibytes(),fluent.getStorage(),fluent.getSystemVendor());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}