package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HardwareSystemVendorBuilder extends HardwareSystemVendorFluentImpl<HardwareSystemVendorBuilder> implements VisitableBuilder<HardwareSystemVendor,HardwareSystemVendorBuilder>{
  public HardwareSystemVendorBuilder() {
    this(false);
  }
  public HardwareSystemVendorBuilder(Boolean validationEnabled) {
    this(new HardwareSystemVendor(), validationEnabled);
  }
  public HardwareSystemVendorBuilder(HardwareSystemVendorFluent<?> fluent) {
    this(fluent, false);
  }
  public HardwareSystemVendorBuilder(HardwareSystemVendorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HardwareSystemVendor(), validationEnabled);
  }
  public HardwareSystemVendorBuilder(HardwareSystemVendorFluent<?> fluent,HardwareSystemVendor instance) {
    this(fluent, instance, false);
  }
  public HardwareSystemVendorBuilder(HardwareSystemVendorFluent<?> fluent,HardwareSystemVendor instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withManufacturer(instance.getManufacturer()); 
    fluent.withProductName(instance.getProductName()); 
    fluent.withSerialNumber(instance.getSerialNumber()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HardwareSystemVendorBuilder(HardwareSystemVendor instance) {
    this(instance,false);
  }
  public HardwareSystemVendorBuilder(HardwareSystemVendor instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withManufacturer(instance.getManufacturer()); 
    this.withProductName(instance.getProductName()); 
    this.withSerialNumber(instance.getSerialNumber()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  HardwareSystemVendorFluent<?> fluent;
  Boolean validationEnabled;
  public HardwareSystemVendor build() {
    HardwareSystemVendor buildable = new HardwareSystemVendor(fluent.getManufacturer(),fluent.getProductName(),fluent.getSerialNumber());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}