package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NICBuilder extends NICFluentImpl<NICBuilder> implements VisitableBuilder<NIC,NICBuilder>{
  public NICBuilder() {
    this(false);
  }
  public NICBuilder(Boolean validationEnabled) {
    this(new NIC(), validationEnabled);
  }
  public NICBuilder(NICFluent<?> fluent) {
    this(fluent, false);
  }
  public NICBuilder(NICFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NIC(), validationEnabled);
  }
  public NICBuilder(NICFluent<?> fluent,NIC instance) {
    this(fluent, instance, false);
  }
  public NICBuilder(NICFluent<?> fluent,NIC instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withIp(instance.getIp()); 
    fluent.withMac(instance.getMac()); 
    fluent.withModel(instance.getModel()); 
    fluent.withName(instance.getName()); 
    fluent.withPxe(instance.getPxe()); 
    fluent.withSpeedGbps(instance.getSpeedGbps()); 
    fluent.withVlanId(instance.getVlanId()); 
    fluent.withVlans(instance.getVlans()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NICBuilder(NIC instance) {
    this(instance,false);
  }
  public NICBuilder(NIC instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withIp(instance.getIp()); 
    this.withMac(instance.getMac()); 
    this.withModel(instance.getModel()); 
    this.withName(instance.getName()); 
    this.withPxe(instance.getPxe()); 
    this.withSpeedGbps(instance.getSpeedGbps()); 
    this.withVlanId(instance.getVlanId()); 
    this.withVlans(instance.getVlans()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  NICFluent<?> fluent;
  Boolean validationEnabled;
  public NIC build() {
    NIC buildable = new NIC(fluent.getIp(),fluent.getMac(),fluent.getModel(),fluent.getName(),fluent.getPxe(),fluent.getSpeedGbps(),fluent.getVlanId(),fluent.getVlans());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}