package io.fabric8.openshift.api.model.miscellaneous.network.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OperatorPKIStatusBuilder extends OperatorPKIStatusFluentImpl<OperatorPKIStatusBuilder> implements VisitableBuilder<OperatorPKIStatus,OperatorPKIStatusBuilder>{
  public OperatorPKIStatusBuilder() {
    this(false);
  }
  public OperatorPKIStatusBuilder(Boolean validationEnabled) {
    this(new OperatorPKIStatus(), validationEnabled);
  }
  public OperatorPKIStatusBuilder(OperatorPKIStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public OperatorPKIStatusBuilder(OperatorPKIStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OperatorPKIStatus(), validationEnabled);
  }
  public OperatorPKIStatusBuilder(OperatorPKIStatusFluent<?> fluent,OperatorPKIStatus instance) {
    this(fluent, instance, false);
  }
  public OperatorPKIStatusBuilder(OperatorPKIStatusFluent<?> fluent,OperatorPKIStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OperatorPKIStatusBuilder(OperatorPKIStatus instance) {
    this(instance,false);
  }
  public OperatorPKIStatusBuilder(OperatorPKIStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  OperatorPKIStatusFluent<?> fluent;
  Boolean validationEnabled;
  public OperatorPKIStatus build() {
    OperatorPKIStatus buildable = new OperatorPKIStatus();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}