/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.CPU;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.CPUBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.CPUFluentImpl;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.Firmware;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.FirmwareBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.FirmwareFluentImpl;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.HardwareDetails;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.HardwareDetailsFluent;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.HardwareSystemVendor;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.HardwareSystemVendorBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.HardwareSystemVendorFluentImpl;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.NIC;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.NICBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.NICFluentImpl;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.Storage;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.StorageBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.StorageFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class HardwareDetailsFluentImpl<A extends HardwareDetailsFluent<A>>
extends BaseFluent<A>
implements HardwareDetailsFluent<A> {
    private CPUBuilder cpu;
    private FirmwareBuilder firmware;
    private String hostname;
    private ArrayList<NICBuilder> nics = new ArrayList();
    private Integer ramMebibytes;
    private ArrayList<StorageBuilder> storage = new ArrayList();
    private HardwareSystemVendorBuilder systemVendor;
    private Map<String, Object> additionalProperties;

    public HardwareDetailsFluentImpl() {
    }

    public HardwareDetailsFluentImpl(HardwareDetails instance) {
        if (instance != null) {
            this.withCpu(instance.getCpu());
            this.withFirmware(instance.getFirmware());
            this.withHostname(instance.getHostname());
            this.withNics(instance.getNics());
            this.withRamMebibytes(instance.getRamMebibytes());
            this.withStorage(instance.getStorage());
            this.withSystemVendor(instance.getSystemVendor());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    @Deprecated
    public CPU getCpu() {
        return this.cpu != null ? this.cpu.build() : null;
    }

    @Override
    public CPU buildCpu() {
        return this.cpu != null ? this.cpu.build() : null;
    }

    @Override
    public A withCpu(CPU cpu) {
        this._visitables.get((Object)"cpu").remove(this.cpu);
        if (cpu != null) {
            this.cpu = new CPUBuilder(cpu);
            this._visitables.get((Object)"cpu").add(this.cpu);
        } else {
            this.cpu = null;
            this._visitables.get((Object)"cpu").remove(this.cpu);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCpu() {
        return this.cpu != null;
    }

    @Override
    public HardwareDetailsFluent.CpuNested<A> withNewCpu() {
        return new CpuNestedImpl();
    }

    @Override
    public HardwareDetailsFluent.CpuNested<A> withNewCpuLike(CPU item) {
        return new CpuNestedImpl(item);
    }

    @Override
    public HardwareDetailsFluent.CpuNested<A> editCpu() {
        return this.withNewCpuLike(this.getCpu());
    }

    @Override
    public HardwareDetailsFluent.CpuNested<A> editOrNewCpu() {
        return this.withNewCpuLike(this.getCpu() != null ? this.getCpu() : new CPUBuilder().build());
    }

    @Override
    public HardwareDetailsFluent.CpuNested<A> editOrNewCpuLike(CPU item) {
        return this.withNewCpuLike(this.getCpu() != null ? this.getCpu() : item);
    }

    @Override
    @Deprecated
    public Firmware getFirmware() {
        return this.firmware != null ? this.firmware.build() : null;
    }

    @Override
    public Firmware buildFirmware() {
        return this.firmware != null ? this.firmware.build() : null;
    }

    @Override
    public A withFirmware(Firmware firmware) {
        this._visitables.get((Object)"firmware").remove(this.firmware);
        if (firmware != null) {
            this.firmware = new FirmwareBuilder(firmware);
            this._visitables.get((Object)"firmware").add(this.firmware);
        } else {
            this.firmware = null;
            this._visitables.get((Object)"firmware").remove(this.firmware);
        }
        return (A)this;
    }

    @Override
    public Boolean hasFirmware() {
        return this.firmware != null;
    }

    @Override
    public HardwareDetailsFluent.FirmwareNested<A> withNewFirmware() {
        return new FirmwareNestedImpl();
    }

    @Override
    public HardwareDetailsFluent.FirmwareNested<A> withNewFirmwareLike(Firmware item) {
        return new FirmwareNestedImpl(item);
    }

    @Override
    public HardwareDetailsFluent.FirmwareNested<A> editFirmware() {
        return this.withNewFirmwareLike(this.getFirmware());
    }

    @Override
    public HardwareDetailsFluent.FirmwareNested<A> editOrNewFirmware() {
        return this.withNewFirmwareLike(this.getFirmware() != null ? this.getFirmware() : new FirmwareBuilder().build());
    }

    @Override
    public HardwareDetailsFluent.FirmwareNested<A> editOrNewFirmwareLike(Firmware item) {
        return this.withNewFirmwareLike(this.getFirmware() != null ? this.getFirmware() : item);
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)this;
    }

    @Override
    public Boolean hasHostname() {
        return this.hostname != null;
    }

    @Override
    public A addToNics(int index, NIC item) {
        if (this.nics == null) {
            this.nics = new ArrayList();
        }
        NICBuilder builder = new NICBuilder(item);
        if (index < 0 || index >= this.nics.size()) {
            this._visitables.get((Object)"nics").add(builder);
            this.nics.add(builder);
        } else {
            this._visitables.get((Object)"nics").add(index, builder);
            this.nics.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToNics(int index, NIC item) {
        if (this.nics == null) {
            this.nics = new ArrayList();
        }
        NICBuilder builder = new NICBuilder(item);
        if (index < 0 || index >= this.nics.size()) {
            this._visitables.get((Object)"nics").add(builder);
            this.nics.add(builder);
        } else {
            this._visitables.get((Object)"nics").set(index, builder);
            this.nics.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToNics(NIC ... items) {
        if (this.nics == null) {
            this.nics = new ArrayList();
        }
        for (NIC item : items) {
            NICBuilder builder = new NICBuilder(item);
            this._visitables.get((Object)"nics").add(builder);
            this.nics.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToNics(Collection<NIC> items) {
        if (this.nics == null) {
            this.nics = new ArrayList();
        }
        for (NIC item : items) {
            NICBuilder builder = new NICBuilder(item);
            this._visitables.get((Object)"nics").add(builder);
            this.nics.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromNics(NIC ... items) {
        for (NIC item : items) {
            NICBuilder builder = new NICBuilder(item);
            this._visitables.get((Object)"nics").remove(builder);
            if (this.nics == null) continue;
            this.nics.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNics(Collection<NIC> items) {
        for (NIC item : items) {
            NICBuilder builder = new NICBuilder(item);
            this._visitables.get((Object)"nics").remove(builder);
            if (this.nics == null) continue;
            this.nics.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromNics(Predicate<NICBuilder> predicate) {
        if (this.nics == null) {
            return (A)this;
        }
        Iterator<NICBuilder> each = this.nics.iterator();
        List visitables = this._visitables.get((Object)"nics");
        while (each.hasNext()) {
            NICBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NIC> getNics() {
        return this.nics != null ? HardwareDetailsFluentImpl.build(this.nics) : null;
    }

    @Override
    public List<NIC> buildNics() {
        return this.nics != null ? HardwareDetailsFluentImpl.build(this.nics) : null;
    }

    @Override
    public NIC buildNic(int index) {
        return this.nics.get(index).build();
    }

    @Override
    public NIC buildFirstNic() {
        return this.nics.get(0).build();
    }

    @Override
    public NIC buildLastNic() {
        return this.nics.get(this.nics.size() - 1).build();
    }

    @Override
    public NIC buildMatchingNic(Predicate<NICBuilder> predicate) {
        for (NICBuilder item : this.nics) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNic(Predicate<NICBuilder> predicate) {
        for (NICBuilder item : this.nics) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNics(List<NIC> nics) {
        if (this.nics != null) {
            this._visitables.get((Object)"nics").clear();
        }
        if (nics != null) {
            this.nics = new ArrayList();
            for (NIC item : nics) {
                this.addToNics(item);
            }
        } else {
            this.nics = null;
        }
        return (A)this;
    }

    @Override
    public A withNics(NIC ... nics) {
        if (this.nics != null) {
            this.nics.clear();
            this._visitables.remove((Object)"nics");
        }
        if (nics != null) {
            for (NIC item : nics) {
                this.addToNics(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNics() {
        return this.nics != null && !this.nics.isEmpty();
    }

    @Override
    public HardwareDetailsFluent.NicsNested<A> addNewNic() {
        return new NicsNestedImpl();
    }

    @Override
    public HardwareDetailsFluent.NicsNested<A> addNewNicLike(NIC item) {
        return new NicsNestedImpl(-1, item);
    }

    @Override
    public HardwareDetailsFluent.NicsNested<A> setNewNicLike(int index, NIC item) {
        return new NicsNestedImpl(index, item);
    }

    @Override
    public HardwareDetailsFluent.NicsNested<A> editNic(int index) {
        if (this.nics.size() <= index) {
            throw new RuntimeException("Can't edit nics. Index exceeds size.");
        }
        return this.setNewNicLike(index, this.buildNic(index));
    }

    @Override
    public HardwareDetailsFluent.NicsNested<A> editFirstNic() {
        if (this.nics.size() == 0) {
            throw new RuntimeException("Can't edit first nics. The list is empty.");
        }
        return this.setNewNicLike(0, this.buildNic(0));
    }

    @Override
    public HardwareDetailsFluent.NicsNested<A> editLastNic() {
        int index = this.nics.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last nics. The list is empty.");
        }
        return this.setNewNicLike(index, this.buildNic(index));
    }

    @Override
    public HardwareDetailsFluent.NicsNested<A> editMatchingNic(Predicate<NICBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.nics.size(); ++i) {
            if (!predicate.test(this.nics.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching nics. No match found.");
        }
        return this.setNewNicLike(index, this.buildNic(index));
    }

    @Override
    public Integer getRamMebibytes() {
        return this.ramMebibytes;
    }

    @Override
    public A withRamMebibytes(Integer ramMebibytes) {
        this.ramMebibytes = ramMebibytes;
        return (A)this;
    }

    @Override
    public Boolean hasRamMebibytes() {
        return this.ramMebibytes != null;
    }

    @Override
    public A addToStorage(int index, Storage item) {
        if (this.storage == null) {
            this.storage = new ArrayList();
        }
        StorageBuilder builder = new StorageBuilder(item);
        if (index < 0 || index >= this.storage.size()) {
            this._visitables.get((Object)"storage").add(builder);
            this.storage.add(builder);
        } else {
            this._visitables.get((Object)"storage").add(index, builder);
            this.storage.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToStorage(int index, Storage item) {
        if (this.storage == null) {
            this.storage = new ArrayList();
        }
        StorageBuilder builder = new StorageBuilder(item);
        if (index < 0 || index >= this.storage.size()) {
            this._visitables.get((Object)"storage").add(builder);
            this.storage.add(builder);
        } else {
            this._visitables.get((Object)"storage").set(index, builder);
            this.storage.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToStorage(Storage ... items) {
        if (this.storage == null) {
            this.storage = new ArrayList();
        }
        for (Storage item : items) {
            StorageBuilder builder = new StorageBuilder(item);
            this._visitables.get((Object)"storage").add(builder);
            this.storage.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToStorage(Collection<Storage> items) {
        if (this.storage == null) {
            this.storage = new ArrayList();
        }
        for (Storage item : items) {
            StorageBuilder builder = new StorageBuilder(item);
            this._visitables.get((Object)"storage").add(builder);
            this.storage.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromStorage(Storage ... items) {
        for (Storage item : items) {
            StorageBuilder builder = new StorageBuilder(item);
            this._visitables.get((Object)"storage").remove(builder);
            if (this.storage == null) continue;
            this.storage.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromStorage(Collection<Storage> items) {
        for (Storage item : items) {
            StorageBuilder builder = new StorageBuilder(item);
            this._visitables.get((Object)"storage").remove(builder);
            if (this.storage == null) continue;
            this.storage.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromStorage(Predicate<StorageBuilder> predicate) {
        if (this.storage == null) {
            return (A)this;
        }
        Iterator<StorageBuilder> each = this.storage.iterator();
        List visitables = this._visitables.get((Object)"storage");
        while (each.hasNext()) {
            StorageBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Storage> getStorage() {
        return this.storage != null ? HardwareDetailsFluentImpl.build(this.storage) : null;
    }

    @Override
    public List<Storage> buildStorage() {
        return this.storage != null ? HardwareDetailsFluentImpl.build(this.storage) : null;
    }

    @Override
    public Storage buildStorage(int index) {
        return this.storage.get(index).build();
    }

    @Override
    public Storage buildFirstStorage() {
        return this.storage.get(0).build();
    }

    @Override
    public Storage buildLastStorage() {
        return this.storage.get(this.storage.size() - 1).build();
    }

    @Override
    public Storage buildMatchingStorage(Predicate<StorageBuilder> predicate) {
        for (StorageBuilder item : this.storage) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingStorage(Predicate<StorageBuilder> predicate) {
        for (StorageBuilder item : this.storage) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withStorage(List<Storage> storage) {
        if (this.storage != null) {
            this._visitables.get((Object)"storage").clear();
        }
        if (storage != null) {
            this.storage = new ArrayList();
            for (Storage item : storage) {
                this.addToStorage(item);
            }
        } else {
            this.storage = null;
        }
        return (A)this;
    }

    @Override
    public A withStorage(Storage ... storage) {
        if (this.storage != null) {
            this.storage.clear();
            this._visitables.remove((Object)"storage");
        }
        if (storage != null) {
            for (Storage item : storage) {
                this.addToStorage(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasStorage() {
        return this.storage != null && !this.storage.isEmpty();
    }

    @Override
    public HardwareDetailsFluent.StorageNested<A> addNewStorage() {
        return new StorageNestedImpl();
    }

    @Override
    public HardwareDetailsFluent.StorageNested<A> addNewStorageLike(Storage item) {
        return new StorageNestedImpl(-1, item);
    }

    @Override
    public HardwareDetailsFluent.StorageNested<A> setNewStorageLike(int index, Storage item) {
        return new StorageNestedImpl(index, item);
    }

    @Override
    public HardwareDetailsFluent.StorageNested<A> editStorage(int index) {
        if (this.storage.size() <= index) {
            throw new RuntimeException("Can't edit storage. Index exceeds size.");
        }
        return this.setNewStorageLike(index, this.buildStorage(index));
    }

    @Override
    public HardwareDetailsFluent.StorageNested<A> editFirstStorage() {
        if (this.storage.size() == 0) {
            throw new RuntimeException("Can't edit first storage. The list is empty.");
        }
        return this.setNewStorageLike(0, this.buildStorage(0));
    }

    @Override
    public HardwareDetailsFluent.StorageNested<A> editLastStorage() {
        int index = this.storage.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last storage. The list is empty.");
        }
        return this.setNewStorageLike(index, this.buildStorage(index));
    }

    @Override
    public HardwareDetailsFluent.StorageNested<A> editMatchingStorage(Predicate<StorageBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.storage.size(); ++i) {
            if (!predicate.test(this.storage.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching storage. No match found.");
        }
        return this.setNewStorageLike(index, this.buildStorage(index));
    }

    @Override
    @Deprecated
    public HardwareSystemVendor getSystemVendor() {
        return this.systemVendor != null ? this.systemVendor.build() : null;
    }

    @Override
    public HardwareSystemVendor buildSystemVendor() {
        return this.systemVendor != null ? this.systemVendor.build() : null;
    }

    @Override
    public A withSystemVendor(HardwareSystemVendor systemVendor) {
        this._visitables.get((Object)"systemVendor").remove(this.systemVendor);
        if (systemVendor != null) {
            this.systemVendor = new HardwareSystemVendorBuilder(systemVendor);
            this._visitables.get((Object)"systemVendor").add(this.systemVendor);
        } else {
            this.systemVendor = null;
            this._visitables.get((Object)"systemVendor").remove(this.systemVendor);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSystemVendor() {
        return this.systemVendor != null;
    }

    @Override
    public A withNewSystemVendor(String manufacturer, String productName, String serialNumber) {
        return this.withSystemVendor(new HardwareSystemVendor(manufacturer, productName, serialNumber));
    }

    @Override
    public HardwareDetailsFluent.SystemVendorNested<A> withNewSystemVendor() {
        return new SystemVendorNestedImpl();
    }

    @Override
    public HardwareDetailsFluent.SystemVendorNested<A> withNewSystemVendorLike(HardwareSystemVendor item) {
        return new SystemVendorNestedImpl(item);
    }

    @Override
    public HardwareDetailsFluent.SystemVendorNested<A> editSystemVendor() {
        return this.withNewSystemVendorLike(this.getSystemVendor());
    }

    @Override
    public HardwareDetailsFluent.SystemVendorNested<A> editOrNewSystemVendor() {
        return this.withNewSystemVendorLike(this.getSystemVendor() != null ? this.getSystemVendor() : new HardwareSystemVendorBuilder().build());
    }

    @Override
    public HardwareDetailsFluent.SystemVendorNested<A> editOrNewSystemVendorLike(HardwareSystemVendor item) {
        return this.withNewSystemVendorLike(this.getSystemVendor() != null ? this.getSystemVendor() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HardwareDetailsFluentImpl that = (HardwareDetailsFluentImpl)o;
        if (!Objects.equals(this.cpu, that.cpu)) {
            return false;
        }
        if (!Objects.equals(this.firmware, that.firmware)) {
            return false;
        }
        if (!Objects.equals(this.hostname, that.hostname)) {
            return false;
        }
        if (!Objects.equals(this.nics, that.nics)) {
            return false;
        }
        if (!Objects.equals(this.ramMebibytes, that.ramMebibytes)) {
            return false;
        }
        if (!Objects.equals(this.storage, that.storage)) {
            return false;
        }
        if (!Objects.equals(this.systemVendor, that.systemVendor)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.cpu, this.firmware, this.hostname, this.nics, this.ramMebibytes, this.storage, this.systemVendor, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cpu != null) {
            sb.append("cpu:");
            sb.append(this.cpu + ",");
        }
        if (this.firmware != null) {
            sb.append("firmware:");
            sb.append(this.firmware + ",");
        }
        if (this.hostname != null) {
            sb.append("hostname:");
            sb.append(this.hostname + ",");
        }
        if (this.nics != null) {
            sb.append("nics:");
            sb.append(this.nics + ",");
        }
        if (this.ramMebibytes != null) {
            sb.append("ramMebibytes:");
            sb.append(this.ramMebibytes + ",");
        }
        if (this.storage != null) {
            sb.append("storage:");
            sb.append(this.storage + ",");
        }
        if (this.systemVendor != null) {
            sb.append("systemVendor:");
            sb.append(this.systemVendor + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class SystemVendorNestedImpl<N>
    extends HardwareSystemVendorFluentImpl<HardwareDetailsFluent.SystemVendorNested<N>>
    implements HardwareDetailsFluent.SystemVendorNested<N>,
    Nested<N> {
        HardwareSystemVendorBuilder builder;

        SystemVendorNestedImpl(HardwareSystemVendor item) {
            this.builder = new HardwareSystemVendorBuilder(this, item);
        }

        SystemVendorNestedImpl() {
            this.builder = new HardwareSystemVendorBuilder(this);
        }

        @Override
        public N and() {
            return (N)HardwareDetailsFluentImpl.this.withSystemVendor(this.builder.build());
        }

        @Override
        public N endSystemVendor() {
            return this.and();
        }
    }

    class StorageNestedImpl<N>
    extends StorageFluentImpl<HardwareDetailsFluent.StorageNested<N>>
    implements HardwareDetailsFluent.StorageNested<N>,
    Nested<N> {
        StorageBuilder builder;
        int index;

        StorageNestedImpl(int index, Storage item) {
            this.index = index;
            this.builder = new StorageBuilder(this, item);
        }

        StorageNestedImpl() {
            this.index = -1;
            this.builder = new StorageBuilder(this);
        }

        @Override
        public N and() {
            return (N)HardwareDetailsFluentImpl.this.setToStorage(this.index, this.builder.build());
        }

        @Override
        public N endStorage() {
            return this.and();
        }
    }

    class NicsNestedImpl<N>
    extends NICFluentImpl<HardwareDetailsFluent.NicsNested<N>>
    implements HardwareDetailsFluent.NicsNested<N>,
    Nested<N> {
        NICBuilder builder;
        int index;

        NicsNestedImpl(int index, NIC item) {
            this.index = index;
            this.builder = new NICBuilder(this, item);
        }

        NicsNestedImpl() {
            this.index = -1;
            this.builder = new NICBuilder(this);
        }

        @Override
        public N and() {
            return (N)HardwareDetailsFluentImpl.this.setToNics(this.index, this.builder.build());
        }

        @Override
        public N endNic() {
            return this.and();
        }
    }

    class FirmwareNestedImpl<N>
    extends FirmwareFluentImpl<HardwareDetailsFluent.FirmwareNested<N>>
    implements HardwareDetailsFluent.FirmwareNested<N>,
    Nested<N> {
        FirmwareBuilder builder;

        FirmwareNestedImpl(Firmware item) {
            this.builder = new FirmwareBuilder(this, item);
        }

        FirmwareNestedImpl() {
            this.builder = new FirmwareBuilder(this);
        }

        @Override
        public N and() {
            return (N)HardwareDetailsFluentImpl.this.withFirmware(this.builder.build());
        }

        @Override
        public N endFirmware() {
            return this.and();
        }
    }

    class CpuNestedImpl<N>
    extends CPUFluentImpl<HardwareDetailsFluent.CpuNested<N>>
    implements HardwareDetailsFluent.CpuNested<N>,
    Nested<N> {
        CPUBuilder builder;

        CpuNestedImpl(CPU item) {
            this.builder = new CPUBuilder(this, item);
        }

        CpuNestedImpl() {
            this.builder = new CPUBuilder(this);
        }

        @Override
        public N and() {
            return (N)HardwareDetailsFluentImpl.this.withCpu(this.builder.build());
        }

        @Override
        public N endCpu() {
            return this.and();
        }
    }
}

