package io.fabric8.openshift.api.model.miscellaneous.cncf.cni.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkAttachmentDefinitionListBuilder extends NetworkAttachmentDefinitionListFluentImpl<NetworkAttachmentDefinitionListBuilder> implements VisitableBuilder<NetworkAttachmentDefinitionList,NetworkAttachmentDefinitionListBuilder>{
  public NetworkAttachmentDefinitionListBuilder() {
    this(false);
  }
  public NetworkAttachmentDefinitionListBuilder(Boolean validationEnabled) {
    this(new NetworkAttachmentDefinitionList(), validationEnabled);
  }
  public NetworkAttachmentDefinitionListBuilder(NetworkAttachmentDefinitionListFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkAttachmentDefinitionListBuilder(NetworkAttachmentDefinitionListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NetworkAttachmentDefinitionList(), validationEnabled);
  }
  public NetworkAttachmentDefinitionListBuilder(NetworkAttachmentDefinitionListFluent<?> fluent,NetworkAttachmentDefinitionList instance) {
    this(fluent, instance, false);
  }
  public NetworkAttachmentDefinitionListBuilder(NetworkAttachmentDefinitionListFluent<?> fluent,NetworkAttachmentDefinitionList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NetworkAttachmentDefinitionListBuilder(NetworkAttachmentDefinitionList instance) {
    this(instance,false);
  }
  public NetworkAttachmentDefinitionListBuilder(NetworkAttachmentDefinitionList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NetworkAttachmentDefinitionListFluent<?> fluent;
  Boolean validationEnabled;
  public NetworkAttachmentDefinitionList build() {
    NetworkAttachmentDefinitionList buildable = new NetworkAttachmentDefinitionList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}