package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageRegistryConfigRequestsLimitsBuilder extends ImageRegistryConfigRequestsLimitsFluentImpl<ImageRegistryConfigRequestsLimitsBuilder> implements VisitableBuilder<ImageRegistryConfigRequestsLimits,ImageRegistryConfigRequestsLimitsBuilder>{
  public ImageRegistryConfigRequestsLimitsBuilder() {
    this(false);
  }
  public ImageRegistryConfigRequestsLimitsBuilder(Boolean validationEnabled) {
    this(new ImageRegistryConfigRequestsLimits(), validationEnabled);
  }
  public ImageRegistryConfigRequestsLimitsBuilder(ImageRegistryConfigRequestsLimitsFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageRegistryConfigRequestsLimitsBuilder(ImageRegistryConfigRequestsLimitsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageRegistryConfigRequestsLimits(), validationEnabled);
  }
  public ImageRegistryConfigRequestsLimitsBuilder(ImageRegistryConfigRequestsLimitsFluent<?> fluent,ImageRegistryConfigRequestsLimits instance) {
    this(fluent, instance, false);
  }
  public ImageRegistryConfigRequestsLimitsBuilder(ImageRegistryConfigRequestsLimitsFluent<?> fluent,ImageRegistryConfigRequestsLimits instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withMaxInQueue(instance.getMaxInQueue());
      fluent.withMaxRunning(instance.getMaxRunning());
      fluent.withMaxWaitInQueue(instance.getMaxWaitInQueue());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageRegistryConfigRequestsLimitsBuilder(ImageRegistryConfigRequestsLimits instance) {
    this(instance,false);
  }
  public ImageRegistryConfigRequestsLimitsBuilder(ImageRegistryConfigRequestsLimits instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withMaxInQueue(instance.getMaxInQueue());
      this.withMaxRunning(instance.getMaxRunning());
      this.withMaxWaitInQueue(instance.getMaxWaitInQueue());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageRegistryConfigRequestsLimitsFluent<?> fluent;
  Boolean validationEnabled;
  public ImageRegistryConfigRequestsLimits build() {
    ImageRegistryConfigRequestsLimits buildable = new ImageRegistryConfigRequestsLimits(fluent.getMaxInQueue(),fluent.getMaxRunning(),fluent.getMaxWaitInQueue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}