package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageRegistryConfigStorageIBMCOSBuilder extends ImageRegistryConfigStorageIBMCOSFluentImpl<ImageRegistryConfigStorageIBMCOSBuilder> implements VisitableBuilder<ImageRegistryConfigStorageIBMCOS,ImageRegistryConfigStorageIBMCOSBuilder>{
  public ImageRegistryConfigStorageIBMCOSBuilder() {
    this(false);
  }
  public ImageRegistryConfigStorageIBMCOSBuilder(Boolean validationEnabled) {
    this(new ImageRegistryConfigStorageIBMCOS(), validationEnabled);
  }
  public ImageRegistryConfigStorageIBMCOSBuilder(ImageRegistryConfigStorageIBMCOSFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageRegistryConfigStorageIBMCOSBuilder(ImageRegistryConfigStorageIBMCOSFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageRegistryConfigStorageIBMCOS(), validationEnabled);
  }
  public ImageRegistryConfigStorageIBMCOSBuilder(ImageRegistryConfigStorageIBMCOSFluent<?> fluent,ImageRegistryConfigStorageIBMCOS instance) {
    this(fluent, instance, false);
  }
  public ImageRegistryConfigStorageIBMCOSBuilder(ImageRegistryConfigStorageIBMCOSFluent<?> fluent,ImageRegistryConfigStorageIBMCOS instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withBucket(instance.getBucket());
      fluent.withLocation(instance.getLocation());
      fluent.withResourceGroupName(instance.getResourceGroupName());
      fluent.withResourceKeyCRN(instance.getResourceKeyCRN());
      fluent.withServiceInstanceCRN(instance.getServiceInstanceCRN());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageRegistryConfigStorageIBMCOSBuilder(ImageRegistryConfigStorageIBMCOS instance) {
    this(instance,false);
  }
  public ImageRegistryConfigStorageIBMCOSBuilder(ImageRegistryConfigStorageIBMCOS instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withBucket(instance.getBucket());
      this.withLocation(instance.getLocation());
      this.withResourceGroupName(instance.getResourceGroupName());
      this.withResourceKeyCRN(instance.getResourceKeyCRN());
      this.withServiceInstanceCRN(instance.getServiceInstanceCRN());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageRegistryConfigStorageIBMCOSFluent<?> fluent;
  Boolean validationEnabled;
  public ImageRegistryConfigStorageIBMCOS build() {
    ImageRegistryConfigStorageIBMCOS buildable = new ImageRegistryConfigStorageIBMCOS(fluent.getBucket(),fluent.getLocation(),fluent.getResourceGroupName(),fluent.getResourceKeyCRN(),fluent.getServiceInstanceCRN());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}