package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ImageRegistryConfigStorageS3FluentImpl<A extends ImageRegistryConfigStorageS3Fluent<A>> extends BaseFluent<A> implements ImageRegistryConfigStorageS3Fluent<A>{
  public ImageRegistryConfigStorageS3FluentImpl() {
  }
  public ImageRegistryConfigStorageS3FluentImpl(ImageRegistryConfigStorageS3 instance) {
    if (instance != null) {
      this.withBucket(instance.getBucket());
      this.withCloudFront(instance.getCloudFront());
      this.withEncrypt(instance.getEncrypt());
      this.withKeyID(instance.getKeyID());
      this.withRegion(instance.getRegion());
      this.withRegionEndpoint(instance.getRegionEndpoint());
      this.withVirtualHostedStyle(instance.getVirtualHostedStyle());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String bucket;
  private ImageRegistryConfigStorageS3CloudFrontBuilder cloudFront;
  private Boolean encrypt;
  private String keyID;
  private String region;
  private String regionEndpoint;
  private Boolean virtualHostedStyle;
  private Map<String,Object> additionalProperties;
  public String getBucket() {
    return this.bucket;
  }
  public A withBucket(String bucket) {
    this.bucket=bucket; return (A) this;
  }
  public Boolean hasBucket() {
    return this.bucket != null;
  }
  
  /**
   * This method has been deprecated, please use method buildCloudFront instead.
   * @return The buildable object.
   */
  @Deprecated
  public ImageRegistryConfigStorageS3CloudFront getCloudFront() {
    return this.cloudFront!=null ?this.cloudFront.build():null;
  }
  public ImageRegistryConfigStorageS3CloudFront buildCloudFront() {
    return this.cloudFront!=null ?this.cloudFront.build():null;
  }
  public A withCloudFront(ImageRegistryConfigStorageS3CloudFront cloudFront) {
    _visitables.get("cloudFront").remove(this.cloudFront);
    if (cloudFront!=null){ this.cloudFront= new ImageRegistryConfigStorageS3CloudFrontBuilder(cloudFront); _visitables.get("cloudFront").add(this.cloudFront);} else { this.cloudFront = null; _visitables.get("cloudFront").remove(this.cloudFront); } return (A) this;
  }
  public Boolean hasCloudFront() {
    return this.cloudFront != null;
  }
  public ImageRegistryConfigStorageS3FluentImpl.CloudFrontNested<A> withNewCloudFront() {
    return new ImageRegistryConfigStorageS3FluentImpl.CloudFrontNestedImpl();
  }
  public ImageRegistryConfigStorageS3FluentImpl.CloudFrontNested<A> withNewCloudFrontLike(ImageRegistryConfigStorageS3CloudFront item) {
    return new ImageRegistryConfigStorageS3FluentImpl.CloudFrontNestedImpl(item);
  }
  public ImageRegistryConfigStorageS3FluentImpl.CloudFrontNested<A> editCloudFront() {
    return withNewCloudFrontLike(getCloudFront());
  }
  public ImageRegistryConfigStorageS3FluentImpl.CloudFrontNested<A> editOrNewCloudFront() {
    return withNewCloudFrontLike(getCloudFront() != null ? getCloudFront(): new ImageRegistryConfigStorageS3CloudFrontBuilder().build());
  }
  public ImageRegistryConfigStorageS3FluentImpl.CloudFrontNested<A> editOrNewCloudFrontLike(ImageRegistryConfigStorageS3CloudFront item) {
    return withNewCloudFrontLike(getCloudFront() != null ? getCloudFront(): item);
  }
  public Boolean getEncrypt() {
    return this.encrypt;
  }
  public A withEncrypt(Boolean encrypt) {
    this.encrypt=encrypt; return (A) this;
  }
  public Boolean hasEncrypt() {
    return this.encrypt != null;
  }
  public String getKeyID() {
    return this.keyID;
  }
  public A withKeyID(String keyID) {
    this.keyID=keyID; return (A) this;
  }
  public Boolean hasKeyID() {
    return this.keyID != null;
  }
  public String getRegion() {
    return this.region;
  }
  public A withRegion(String region) {
    this.region=region; return (A) this;
  }
  public Boolean hasRegion() {
    return this.region != null;
  }
  public String getRegionEndpoint() {
    return this.regionEndpoint;
  }
  public A withRegionEndpoint(String regionEndpoint) {
    this.regionEndpoint=regionEndpoint; return (A) this;
  }
  public Boolean hasRegionEndpoint() {
    return this.regionEndpoint != null;
  }
  public Boolean getVirtualHostedStyle() {
    return this.virtualHostedStyle;
  }
  public A withVirtualHostedStyle(Boolean virtualHostedStyle) {
    this.virtualHostedStyle=virtualHostedStyle; return (A) this;
  }
  public Boolean hasVirtualHostedStyle() {
    return this.virtualHostedStyle != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ImageRegistryConfigStorageS3FluentImpl that = (ImageRegistryConfigStorageS3FluentImpl) o;
    if (!java.util.Objects.equals(bucket, that.bucket)) return false;

    if (!java.util.Objects.equals(cloudFront, that.cloudFront)) return false;

    if (!java.util.Objects.equals(encrypt, that.encrypt)) return false;

    if (!java.util.Objects.equals(keyID, that.keyID)) return false;

    if (!java.util.Objects.equals(region, that.region)) return false;

    if (!java.util.Objects.equals(regionEndpoint, that.regionEndpoint)) return false;

    if (!java.util.Objects.equals(virtualHostedStyle, that.virtualHostedStyle)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(bucket,  cloudFront,  encrypt,  keyID,  region,  regionEndpoint,  virtualHostedStyle,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bucket != null) { sb.append("bucket:"); sb.append(bucket + ","); }
    if (cloudFront != null) { sb.append("cloudFront:"); sb.append(cloudFront + ","); }
    if (encrypt != null) { sb.append("encrypt:"); sb.append(encrypt + ","); }
    if (keyID != null) { sb.append("keyID:"); sb.append(keyID + ","); }
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (regionEndpoint != null) { sb.append("regionEndpoint:"); sb.append(regionEndpoint + ","); }
    if (virtualHostedStyle != null) { sb.append("virtualHostedStyle:"); sb.append(virtualHostedStyle + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withEncrypt() {
    return withEncrypt(true);
  }
  public A withVirtualHostedStyle() {
    return withVirtualHostedStyle(true);
  }
  class CloudFrontNestedImpl<N> extends ImageRegistryConfigStorageS3CloudFrontFluentImpl<ImageRegistryConfigStorageS3FluentImpl.CloudFrontNested<N>> implements ImageRegistryConfigStorageS3FluentImpl.CloudFrontNested<N>,Nested<N>{
    CloudFrontNestedImpl(ImageRegistryConfigStorageS3CloudFront item) {
      this.builder = new ImageRegistryConfigStorageS3CloudFrontBuilder(this, item);
    }
    CloudFrontNestedImpl() {
      this.builder = new ImageRegistryConfigStorageS3CloudFrontBuilder(this);
    }
    ImageRegistryConfigStorageS3CloudFrontBuilder builder;
    public N and() {
      return (N) ImageRegistryConfigStorageS3FluentImpl.this.withCloudFront(builder.build());
    }
    public N endCloudFront() {
      return and();
    }
    
  }
  
}