package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface ImageRegistrySpecFluent<A extends ImageRegistrySpecFluent<A>> extends Fluent<A>{
  public Affinity getAffinity();
  public A withAffinity(Affinity affinity);
  public Boolean hasAffinity();
  public Boolean getDefaultRoute();
  public A withDefaultRoute(Boolean defaultRoute);
  public Boolean hasDefaultRoute();
  public Boolean getDisableRedirect();
  public A withDisableRedirect(Boolean disableRedirect);
  public Boolean hasDisableRedirect();
  public String getHttpSecret();
  public A withHttpSecret(String httpSecret);
  public Boolean hasHttpSecret();
  public String getLogLevel();
  public A withLogLevel(String logLevel);
  public Boolean hasLogLevel();
  public Long getLogging();
  public A withLogging(Long logging);
  public Boolean hasLogging();
  public String getManagementState();
  public A withManagementState(String managementState);
  public Boolean hasManagementState();
  public A addToNodeSelector(String key,String value);
  public A addToNodeSelector(Map<String,String> map);
  public A removeFromNodeSelector(String key);
  public A removeFromNodeSelector(Map<String,String> map);
  public Map<String,String> getNodeSelector();
  public <K,V>A withNodeSelector(Map<String,String> nodeSelector);
  public Boolean hasNodeSelector();
  public A addToObservedConfig(String key,Object value);
  public A addToObservedConfig(Map<String,Object> map);
  public A removeFromObservedConfig(String key);
  public A removeFromObservedConfig(Map<String,Object> map);
  public Map<String,Object> getObservedConfig();
  public <K,V>A withObservedConfig(Map<String,Object> observedConfig);
  public Boolean hasObservedConfig();
  public String getOperatorLogLevel();
  public A withOperatorLogLevel(String operatorLogLevel);
  public Boolean hasOperatorLogLevel();
  
  /**
   * This method has been deprecated, please use method buildProxy instead.
   * @return The buildable object.
   */
  @Deprecated
  public ImageRegistryConfigProxy getProxy();
  public ImageRegistryConfigProxy buildProxy();
  public A withProxy(ImageRegistryConfigProxy proxy);
  public Boolean hasProxy();
  public A withNewProxy(String http,String https,String noProxy);
  public ImageRegistrySpecFluent.ProxyNested<A> withNewProxy();
  public ImageRegistrySpecFluent.ProxyNested<A> withNewProxyLike(ImageRegistryConfigProxy item);
  public ImageRegistrySpecFluent.ProxyNested<A> editProxy();
  public ImageRegistrySpecFluent.ProxyNested<A> editOrNewProxy();
  public ImageRegistrySpecFluent.ProxyNested<A> editOrNewProxyLike(ImageRegistryConfigProxy item);
  public Boolean getReadOnly();
  public A withReadOnly(Boolean readOnly);
  public Boolean hasReadOnly();
  public Integer getReplicas();
  public A withReplicas(Integer replicas);
  public Boolean hasReplicas();
  
  /**
   * This method has been deprecated, please use method buildRequests instead.
   * @return The buildable object.
   */
  @Deprecated
  public ImageRegistryConfigRequests getRequests();
  public ImageRegistryConfigRequests buildRequests();
  public A withRequests(ImageRegistryConfigRequests requests);
  public Boolean hasRequests();
  public ImageRegistrySpecFluent.RequestsNested<A> withNewRequests();
  public ImageRegistrySpecFluent.RequestsNested<A> withNewRequestsLike(ImageRegistryConfigRequests item);
  public ImageRegistrySpecFluent.RequestsNested<A> editRequests();
  public ImageRegistrySpecFluent.RequestsNested<A> editOrNewRequests();
  public ImageRegistrySpecFluent.RequestsNested<A> editOrNewRequestsLike(ImageRegistryConfigRequests item);
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceRequirements getResources();
  public ResourceRequirements buildResources();
  public A withResources(ResourceRequirements resources);
  public Boolean hasResources();
  public ImageRegistrySpecFluent.ResourcesNested<A> withNewResources();
  public ImageRegistrySpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item);
  public ImageRegistrySpecFluent.ResourcesNested<A> editResources();
  public ImageRegistrySpecFluent.ResourcesNested<A> editOrNewResources();
  public ImageRegistrySpecFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item);
  public String getRolloutStrategy();
  public A withRolloutStrategy(String rolloutStrategy);
  public Boolean hasRolloutStrategy();
  public A addToRoutes(int index,ImageRegistryConfigRoute item);
  public A setToRoutes(int index,ImageRegistryConfigRoute item);
  public A addToRoutes(io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRoute... items);
  public A addAllToRoutes(Collection<ImageRegistryConfigRoute> items);
  public A removeFromRoutes(io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRoute... items);
  public A removeAllFromRoutes(Collection<ImageRegistryConfigRoute> items);
  public A removeMatchingFromRoutes(Predicate<ImageRegistryConfigRouteBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildRoutes instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ImageRegistryConfigRoute> getRoutes();
  public List<ImageRegistryConfigRoute> buildRoutes();
  public ImageRegistryConfigRoute buildRoute(int index);
  public ImageRegistryConfigRoute buildFirstRoute();
  public ImageRegistryConfigRoute buildLastRoute();
  public ImageRegistryConfigRoute buildMatchingRoute(Predicate<ImageRegistryConfigRouteBuilder> predicate);
  public Boolean hasMatchingRoute(Predicate<ImageRegistryConfigRouteBuilder> predicate);
  public A withRoutes(List<ImageRegistryConfigRoute> routes);
  public A withRoutes(io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRoute... routes);
  public Boolean hasRoutes();
  public A addNewRoute(String hostname,String name,String secretName);
  public ImageRegistrySpecFluent.RoutesNested<A> addNewRoute();
  public ImageRegistrySpecFluent.RoutesNested<A> addNewRouteLike(ImageRegistryConfigRoute item);
  public ImageRegistrySpecFluent.RoutesNested<A> setNewRouteLike(int index,ImageRegistryConfigRoute item);
  public ImageRegistrySpecFluent.RoutesNested<A> editRoute(int index);
  public ImageRegistrySpecFluent.RoutesNested<A> editFirstRoute();
  public ImageRegistrySpecFluent.RoutesNested<A> editLastRoute();
  public ImageRegistrySpecFluent.RoutesNested<A> editMatchingRoute(Predicate<ImageRegistryConfigRouteBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildStorage instead.
   * @return The buildable object.
   */
  @Deprecated
  public ImageRegistryConfigStorage getStorage();
  public ImageRegistryConfigStorage buildStorage();
  public A withStorage(ImageRegistryConfigStorage storage);
  public Boolean hasStorage();
  public ImageRegistrySpecFluent.StorageNested<A> withNewStorage();
  public ImageRegistrySpecFluent.StorageNested<A> withNewStorageLike(ImageRegistryConfigStorage item);
  public ImageRegistrySpecFluent.StorageNested<A> editStorage();
  public ImageRegistrySpecFluent.StorageNested<A> editOrNewStorage();
  public ImageRegistrySpecFluent.StorageNested<A> editOrNewStorageLike(ImageRegistryConfigStorage item);
  public A addToTolerations(int index,Toleration item);
  public A setToTolerations(int index,Toleration item);
  public A addToTolerations(io.fabric8.kubernetes.api.model.Toleration... items);
  public A addAllToTolerations(Collection<Toleration> items);
  public A removeFromTolerations(io.fabric8.kubernetes.api.model.Toleration... items);
  public A removeAllFromTolerations(Collection<Toleration> items);
  public List<Toleration> getTolerations();
  public Toleration getToleration(int index);
  public Toleration getFirstToleration();
  public Toleration getLastToleration();
  public Toleration getMatchingToleration(Predicate<Toleration> predicate);
  public Boolean hasMatchingToleration(Predicate<Toleration> predicate);
  public A withTolerations(List<Toleration> tolerations);
  public A withTolerations(io.fabric8.kubernetes.api.model.Toleration... tolerations);
  public Boolean hasTolerations();
  public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value);
  public A addToUnsupportedConfigOverrides(String key,Object value);
  public A addToUnsupportedConfigOverrides(Map<String,Object> map);
  public A removeFromUnsupportedConfigOverrides(String key);
  public A removeFromUnsupportedConfigOverrides(Map<String,Object> map);
  public Map<String,Object> getUnsupportedConfigOverrides();
  public <K,V>A withUnsupportedConfigOverrides(Map<String,Object> unsupportedConfigOverrides);
  public Boolean hasUnsupportedConfigOverrides();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withDefaultRoute();
  public A withDisableRedirect();
  public A withReadOnly();
  public interface ProxyNested<N> extends Nested<N>,ImageRegistryConfigProxyFluent<ImageRegistrySpecFluent.ProxyNested<N>>{
    public N and();
    public N endProxy();
    
  }
  public interface RequestsNested<N> extends Nested<N>,ImageRegistryConfigRequestsFluent<ImageRegistrySpecFluent.RequestsNested<N>>{
    public N and();
    public N endRequests();
    
  }
  public interface ResourcesNested<N> extends Nested<N>,ResourceRequirementsFluent<ImageRegistrySpecFluent.ResourcesNested<N>>{
    public N and();
    public N endResources();
    
  }
  public interface RoutesNested<N> extends Nested<N>,ImageRegistryConfigRouteFluent<ImageRegistrySpecFluent.RoutesNested<N>>{
    public N and();
    public N endRoute();
    
  }
  public interface StorageNested<N> extends Nested<N>,ImageRegistryConfigStorageFluent<ImageRegistrySpecFluent.StorageNested<N>>{
    public N and();
    public N endStorage();
    
  }
  
}