package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ImageRegistrySpecFluentImpl<A extends ImageRegistrySpecFluent<A>> extends BaseFluent<A> implements ImageRegistrySpecFluent<A>{
  public ImageRegistrySpecFluentImpl() {
  }
  public ImageRegistrySpecFluentImpl(ImageRegistrySpec instance) {
    if (instance != null) {
      this.withAffinity(instance.getAffinity());
      this.withDefaultRoute(instance.getDefaultRoute());
      this.withDisableRedirect(instance.getDisableRedirect());
      this.withHttpSecret(instance.getHttpSecret());
      this.withLogLevel(instance.getLogLevel());
      this.withLogging(instance.getLogging());
      this.withManagementState(instance.getManagementState());
      this.withNodeSelector(instance.getNodeSelector());
      this.withObservedConfig(instance.getObservedConfig());
      this.withOperatorLogLevel(instance.getOperatorLogLevel());
      this.withProxy(instance.getProxy());
      this.withReadOnly(instance.getReadOnly());
      this.withReplicas(instance.getReplicas());
      this.withRequests(instance.getRequests());
      this.withResources(instance.getResources());
      this.withRolloutStrategy(instance.getRolloutStrategy());
      this.withRoutes(instance.getRoutes());
      this.withStorage(instance.getStorage());
      this.withTolerations(instance.getTolerations());
      this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private Affinity affinity;
  private Boolean defaultRoute;
  private Boolean disableRedirect;
  private String httpSecret;
  private String logLevel;
  private Long logging;
  private String managementState;
  private Map<String,String> nodeSelector;
  private Map<String,Object> observedConfig;
  private String operatorLogLevel;
  private ImageRegistryConfigProxyBuilder proxy;
  private Boolean readOnly;
  private Integer replicas;
  private ImageRegistryConfigRequestsBuilder requests;
  private ResourceRequirementsBuilder resources;
  private String rolloutStrategy;
  private ArrayList<ImageRegistryConfigRouteBuilder> routes = new ArrayList<ImageRegistryConfigRouteBuilder>();
  private ImageRegistryConfigStorageBuilder storage;
  private List<Toleration> tolerations = new ArrayList<Toleration>();
  private Map<String,Object> unsupportedConfigOverrides;
  private Map<String,Object> additionalProperties;
  public Affinity getAffinity() {
    return this.affinity;
  }
  public A withAffinity(Affinity affinity) {
    this.affinity=affinity; return (A) this;
  }
  public Boolean hasAffinity() {
    return this.affinity != null;
  }
  public Boolean getDefaultRoute() {
    return this.defaultRoute;
  }
  public A withDefaultRoute(Boolean defaultRoute) {
    this.defaultRoute=defaultRoute; return (A) this;
  }
  public Boolean hasDefaultRoute() {
    return this.defaultRoute != null;
  }
  public Boolean getDisableRedirect() {
    return this.disableRedirect;
  }
  public A withDisableRedirect(Boolean disableRedirect) {
    this.disableRedirect=disableRedirect; return (A) this;
  }
  public Boolean hasDisableRedirect() {
    return this.disableRedirect != null;
  }
  public String getHttpSecret() {
    return this.httpSecret;
  }
  public A withHttpSecret(String httpSecret) {
    this.httpSecret=httpSecret; return (A) this;
  }
  public Boolean hasHttpSecret() {
    return this.httpSecret != null;
  }
  public String getLogLevel() {
    return this.logLevel;
  }
  public A withLogLevel(String logLevel) {
    this.logLevel=logLevel; return (A) this;
  }
  public Boolean hasLogLevel() {
    return this.logLevel != null;
  }
  public Long getLogging() {
    return this.logging;
  }
  public A withLogging(Long logging) {
    this.logging=logging; return (A) this;
  }
  public Boolean hasLogging() {
    return this.logging != null;
  }
  public String getManagementState() {
    return this.managementState;
  }
  public A withManagementState(String managementState) {
    this.managementState=managementState; return (A) this;
  }
  public Boolean hasManagementState() {
    return this.managementState != null;
  }
  public A addToNodeSelector(String key,String value) {
    if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new LinkedHashMap(); }
    if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
  }
  public A addToNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null && map != null) { this.nodeSelector = new LinkedHashMap(); }
    if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
  }
  public A removeFromNodeSelector(String key) {
    if(this.nodeSelector == null) { return (A) this; }
    if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
  }
  public A removeFromNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
  }
  public Map<String,String> getNodeSelector() {
    return this.nodeSelector;
  }
  public <K,V>A withNodeSelector(Map<String,String> nodeSelector) {
    if (nodeSelector == null) { this.nodeSelector =  null;} else {this.nodeSelector = new LinkedHashMap(nodeSelector);} return (A) this;
  }
  public Boolean hasNodeSelector() {
    return this.nodeSelector != null;
  }
  public A addToObservedConfig(String key,Object value) {
    if(this.observedConfig == null && key != null && value != null) { this.observedConfig = new LinkedHashMap(); }
    if(key != null && value != null) {this.observedConfig.put(key, value);} return (A)this;
  }
  public A addToObservedConfig(Map<String,Object> map) {
    if(this.observedConfig == null && map != null) { this.observedConfig = new LinkedHashMap(); }
    if(map != null) { this.observedConfig.putAll(map);} return (A)this;
  }
  public A removeFromObservedConfig(String key) {
    if(this.observedConfig == null) { return (A) this; }
    if(key != null && this.observedConfig != null) {this.observedConfig.remove(key);} return (A)this;
  }
  public A removeFromObservedConfig(Map<String,Object> map) {
    if(this.observedConfig == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.observedConfig != null){this.observedConfig.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getObservedConfig() {
    return this.observedConfig;
  }
  public <K,V>A withObservedConfig(Map<String,Object> observedConfig) {
    if (observedConfig == null) { this.observedConfig =  null;} else {this.observedConfig = new LinkedHashMap(observedConfig);} return (A) this;
  }
  public Boolean hasObservedConfig() {
    return this.observedConfig != null;
  }
  public String getOperatorLogLevel() {
    return this.operatorLogLevel;
  }
  public A withOperatorLogLevel(String operatorLogLevel) {
    this.operatorLogLevel=operatorLogLevel; return (A) this;
  }
  public Boolean hasOperatorLogLevel() {
    return this.operatorLogLevel != null;
  }
  
  /**
   * This method has been deprecated, please use method buildProxy instead.
   * @return The buildable object.
   */
  @Deprecated
  public ImageRegistryConfigProxy getProxy() {
    return this.proxy!=null ?this.proxy.build():null;
  }
  public ImageRegistryConfigProxy buildProxy() {
    return this.proxy!=null ?this.proxy.build():null;
  }
  public A withProxy(ImageRegistryConfigProxy proxy) {
    _visitables.get("proxy").remove(this.proxy);
    if (proxy!=null){ this.proxy= new ImageRegistryConfigProxyBuilder(proxy); _visitables.get("proxy").add(this.proxy);} else { this.proxy = null; _visitables.get("proxy").remove(this.proxy); } return (A) this;
  }
  public Boolean hasProxy() {
    return this.proxy != null;
  }
  public A withNewProxy(String http,String https,String noProxy) {
    return (A)withProxy(new ImageRegistryConfigProxy(http, https, noProxy));
  }
  public ImageRegistrySpecFluentImpl.ProxyNested<A> withNewProxy() {
    return new ImageRegistrySpecFluentImpl.ProxyNestedImpl();
  }
  public ImageRegistrySpecFluentImpl.ProxyNested<A> withNewProxyLike(ImageRegistryConfigProxy item) {
    return new ImageRegistrySpecFluentImpl.ProxyNestedImpl(item);
  }
  public ImageRegistrySpecFluentImpl.ProxyNested<A> editProxy() {
    return withNewProxyLike(getProxy());
  }
  public ImageRegistrySpecFluentImpl.ProxyNested<A> editOrNewProxy() {
    return withNewProxyLike(getProxy() != null ? getProxy(): new ImageRegistryConfigProxyBuilder().build());
  }
  public ImageRegistrySpecFluentImpl.ProxyNested<A> editOrNewProxyLike(ImageRegistryConfigProxy item) {
    return withNewProxyLike(getProxy() != null ? getProxy(): item);
  }
  public Boolean getReadOnly() {
    return this.readOnly;
  }
  public A withReadOnly(Boolean readOnly) {
    this.readOnly=readOnly; return (A) this;
  }
  public Boolean hasReadOnly() {
    return this.readOnly != null;
  }
  public Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public Boolean hasReplicas() {
    return this.replicas != null;
  }
  
  /**
   * This method has been deprecated, please use method buildRequests instead.
   * @return The buildable object.
   */
  @Deprecated
  public ImageRegistryConfigRequests getRequests() {
    return this.requests!=null ?this.requests.build():null;
  }
  public ImageRegistryConfigRequests buildRequests() {
    return this.requests!=null ?this.requests.build():null;
  }
  public A withRequests(ImageRegistryConfigRequests requests) {
    _visitables.get("requests").remove(this.requests);
    if (requests!=null){ this.requests= new ImageRegistryConfigRequestsBuilder(requests); _visitables.get("requests").add(this.requests);} else { this.requests = null; _visitables.get("requests").remove(this.requests); } return (A) this;
  }
  public Boolean hasRequests() {
    return this.requests != null;
  }
  public ImageRegistrySpecFluentImpl.RequestsNested<A> withNewRequests() {
    return new ImageRegistrySpecFluentImpl.RequestsNestedImpl();
  }
  public ImageRegistrySpecFluentImpl.RequestsNested<A> withNewRequestsLike(ImageRegistryConfigRequests item) {
    return new ImageRegistrySpecFluentImpl.RequestsNestedImpl(item);
  }
  public ImageRegistrySpecFluentImpl.RequestsNested<A> editRequests() {
    return withNewRequestsLike(getRequests());
  }
  public ImageRegistrySpecFluentImpl.RequestsNested<A> editOrNewRequests() {
    return withNewRequestsLike(getRequests() != null ? getRequests(): new ImageRegistryConfigRequestsBuilder().build());
  }
  public ImageRegistrySpecFluentImpl.RequestsNested<A> editOrNewRequestsLike(ImageRegistryConfigRequests item) {
    return withNewRequestsLike(getRequests() != null ? getRequests(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceRequirements getResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public ResourceRequirements buildResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public A withResources(ResourceRequirements resources) {
    _visitables.get("resources").remove(this.resources);
    if (resources!=null){ this.resources= new ResourceRequirementsBuilder(resources); _visitables.get("resources").add(this.resources);} else { this.resources = null; _visitables.get("resources").remove(this.resources); } return (A) this;
  }
  public Boolean hasResources() {
    return this.resources != null;
  }
  public ImageRegistrySpecFluentImpl.ResourcesNested<A> withNewResources() {
    return new ImageRegistrySpecFluentImpl.ResourcesNestedImpl();
  }
  public ImageRegistrySpecFluentImpl.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
    return new ImageRegistrySpecFluentImpl.ResourcesNestedImpl(item);
  }
  public ImageRegistrySpecFluentImpl.ResourcesNested<A> editResources() {
    return withNewResourcesLike(getResources());
  }
  public ImageRegistrySpecFluentImpl.ResourcesNested<A> editOrNewResources() {
    return withNewResourcesLike(getResources() != null ? getResources(): new ResourceRequirementsBuilder().build());
  }
  public ImageRegistrySpecFluentImpl.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
    return withNewResourcesLike(getResources() != null ? getResources(): item);
  }
  public String getRolloutStrategy() {
    return this.rolloutStrategy;
  }
  public A withRolloutStrategy(String rolloutStrategy) {
    this.rolloutStrategy=rolloutStrategy; return (A) this;
  }
  public Boolean hasRolloutStrategy() {
    return this.rolloutStrategy != null;
  }
  public A addToRoutes(int index,ImageRegistryConfigRoute item) {
    if (this.routes == null) {this.routes = new ArrayList<ImageRegistryConfigRouteBuilder>();}
    ImageRegistryConfigRouteBuilder builder = new ImageRegistryConfigRouteBuilder(item);
    if (index < 0 || index >= routes.size()) { _visitables.get("routes").add(builder); routes.add(builder); } else { _visitables.get("routes").add(index, builder); routes.add(index, builder);}
    return (A)this;
  }
  public A setToRoutes(int index,ImageRegistryConfigRoute item) {
    if (this.routes == null) {this.routes = new ArrayList<ImageRegistryConfigRouteBuilder>();}
    ImageRegistryConfigRouteBuilder builder = new ImageRegistryConfigRouteBuilder(item);
    if (index < 0 || index >= routes.size()) { _visitables.get("routes").add(builder); routes.add(builder); } else { _visitables.get("routes").set(index, builder); routes.set(index, builder);}
    return (A)this;
  }
  public A addToRoutes(io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRoute... items) {
    if (this.routes == null) {this.routes = new ArrayList<ImageRegistryConfigRouteBuilder>();}
    for (ImageRegistryConfigRoute item : items) {ImageRegistryConfigRouteBuilder builder = new ImageRegistryConfigRouteBuilder(item);_visitables.get("routes").add(builder);this.routes.add(builder);} return (A)this;
  }
  public A addAllToRoutes(Collection<ImageRegistryConfigRoute> items) {
    if (this.routes == null) {this.routes = new ArrayList<ImageRegistryConfigRouteBuilder>();}
    for (ImageRegistryConfigRoute item : items) {ImageRegistryConfigRouteBuilder builder = new ImageRegistryConfigRouteBuilder(item);_visitables.get("routes").add(builder);this.routes.add(builder);} return (A)this;
  }
  public A removeFromRoutes(io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRoute... items) {
    for (ImageRegistryConfigRoute item : items) {ImageRegistryConfigRouteBuilder builder = new ImageRegistryConfigRouteBuilder(item);_visitables.get("routes").remove(builder);if (this.routes != null) {this.routes.remove(builder);}} return (A)this;
  }
  public A removeAllFromRoutes(Collection<ImageRegistryConfigRoute> items) {
    for (ImageRegistryConfigRoute item : items) {ImageRegistryConfigRouteBuilder builder = new ImageRegistryConfigRouteBuilder(item);_visitables.get("routes").remove(builder);if (this.routes != null) {this.routes.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRoutes(Predicate<ImageRegistryConfigRouteBuilder> predicate) {
    if (routes == null) return (A) this;
    final Iterator<ImageRegistryConfigRouteBuilder> each = routes.iterator();
    final List visitables = _visitables.get("routes");
    while (each.hasNext()) {
      ImageRegistryConfigRouteBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRoutes instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ImageRegistryConfigRoute> getRoutes() {
    return routes != null ? build(routes) : null;
  }
  public List<ImageRegistryConfigRoute> buildRoutes() {
    return routes != null ? build(routes) : null;
  }
  public ImageRegistryConfigRoute buildRoute(int index) {
    return this.routes.get(index).build();
  }
  public ImageRegistryConfigRoute buildFirstRoute() {
    return this.routes.get(0).build();
  }
  public ImageRegistryConfigRoute buildLastRoute() {
    return this.routes.get(routes.size() - 1).build();
  }
  public ImageRegistryConfigRoute buildMatchingRoute(Predicate<ImageRegistryConfigRouteBuilder> predicate) {
    for (ImageRegistryConfigRouteBuilder item: routes) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingRoute(Predicate<ImageRegistryConfigRouteBuilder> predicate) {
    for (ImageRegistryConfigRouteBuilder item: routes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRoutes(List<ImageRegistryConfigRoute> routes) {
    if (this.routes != null) { _visitables.get("routes").clear();}
    if (routes != null) {this.routes = new ArrayList(); for (ImageRegistryConfigRoute item : routes){this.addToRoutes(item);}} else { this.routes = null;} return (A) this;
  }
  public A withRoutes(io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ImageRegistryConfigRoute... routes) {
    if (this.routes != null) {this.routes.clear(); _visitables.remove("routes"); }
    if (routes != null) {for (ImageRegistryConfigRoute item :routes){ this.addToRoutes(item);}} return (A) this;
  }
  public Boolean hasRoutes() {
    return routes != null && !routes.isEmpty();
  }
  public A addNewRoute(String hostname,String name,String secretName) {
    return (A)addToRoutes(new ImageRegistryConfigRoute(hostname, name, secretName));
  }
  public ImageRegistrySpecFluentImpl.RoutesNested<A> addNewRoute() {
    return new ImageRegistrySpecFluentImpl.RoutesNestedImpl();
  }
  public ImageRegistrySpecFluentImpl.RoutesNested<A> addNewRouteLike(ImageRegistryConfigRoute item) {
    return new ImageRegistrySpecFluentImpl.RoutesNestedImpl(-1, item);
  }
  public ImageRegistrySpecFluentImpl.RoutesNested<A> setNewRouteLike(int index,ImageRegistryConfigRoute item) {
    return new ImageRegistrySpecFluentImpl.RoutesNestedImpl(index, item);
  }
  public ImageRegistrySpecFluentImpl.RoutesNested<A> editRoute(int index) {
    if (routes.size() <= index) throw new RuntimeException("Can't edit routes. Index exceeds size.");
    return setNewRouteLike(index, buildRoute(index));
  }
  public ImageRegistrySpecFluentImpl.RoutesNested<A> editFirstRoute() {
    if (routes.size() == 0) throw new RuntimeException("Can't edit first routes. The list is empty.");
    return setNewRouteLike(0, buildRoute(0));
  }
  public ImageRegistrySpecFluentImpl.RoutesNested<A> editLastRoute() {
    int index = routes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last routes. The list is empty.");
    return setNewRouteLike(index, buildRoute(index));
  }
  public ImageRegistrySpecFluentImpl.RoutesNested<A> editMatchingRoute(Predicate<ImageRegistryConfigRouteBuilder> predicate) {
    int index = -1;
    for (int i=0;i<routes.size();i++) { 
    if (predicate.test(routes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching routes. No match found.");
    return setNewRouteLike(index, buildRoute(index));
  }
  
  /**
   * This method has been deprecated, please use method buildStorage instead.
   * @return The buildable object.
   */
  @Deprecated
  public ImageRegistryConfigStorage getStorage() {
    return this.storage!=null ?this.storage.build():null;
  }
  public ImageRegistryConfigStorage buildStorage() {
    return this.storage!=null ?this.storage.build():null;
  }
  public A withStorage(ImageRegistryConfigStorage storage) {
    _visitables.get("storage").remove(this.storage);
    if (storage!=null){ this.storage= new ImageRegistryConfigStorageBuilder(storage); _visitables.get("storage").add(this.storage);} else { this.storage = null; _visitables.get("storage").remove(this.storage); } return (A) this;
  }
  public Boolean hasStorage() {
    return this.storage != null;
  }
  public ImageRegistrySpecFluentImpl.StorageNested<A> withNewStorage() {
    return new ImageRegistrySpecFluentImpl.StorageNestedImpl();
  }
  public ImageRegistrySpecFluentImpl.StorageNested<A> withNewStorageLike(ImageRegistryConfigStorage item) {
    return new ImageRegistrySpecFluentImpl.StorageNestedImpl(item);
  }
  public ImageRegistrySpecFluentImpl.StorageNested<A> editStorage() {
    return withNewStorageLike(getStorage());
  }
  public ImageRegistrySpecFluentImpl.StorageNested<A> editOrNewStorage() {
    return withNewStorageLike(getStorage() != null ? getStorage(): new ImageRegistryConfigStorageBuilder().build());
  }
  public ImageRegistrySpecFluentImpl.StorageNested<A> editOrNewStorageLike(ImageRegistryConfigStorage item) {
    return withNewStorageLike(getStorage() != null ? getStorage(): item);
  }
  public A addToTolerations(int index,Toleration item) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    this.tolerations.add(index, item);
    return (A)this;
  }
  public A setToTolerations(int index,Toleration item) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    this.tolerations.set(index, item); return (A)this;
  }
  public A addToTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
  }
  public A addAllToTolerations(Collection<Toleration> items) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
  }
  public A removeFromTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
  }
  public A removeAllFromTolerations(Collection<Toleration> items) {
    for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
  }
  public List<Toleration> getTolerations() {
    return this.tolerations;
  }
  public Toleration getToleration(int index) {
    return this.tolerations.get(index);
  }
  public Toleration getFirstToleration() {
    return this.tolerations.get(0);
  }
  public Toleration getLastToleration() {
    return this.tolerations.get(tolerations.size() - 1);
  }
  public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
    for (Toleration item: tolerations) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingToleration(Predicate<Toleration> predicate) {
    for (Toleration item: tolerations) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTolerations(List<Toleration> tolerations) {
    if (tolerations != null) {this.tolerations = new ArrayList(); for (Toleration item : tolerations){this.addToTolerations(item);}} else { this.tolerations = null;} return (A) this;
  }
  public A withTolerations(io.fabric8.kubernetes.api.model.Toleration... tolerations) {
    if (this.tolerations != null) {this.tolerations.clear(); _visitables.remove("tolerations"); }
    if (tolerations != null) {for (Toleration item :tolerations){ this.addToTolerations(item);}} return (A) this;
  }
  public Boolean hasTolerations() {
    return tolerations != null && !tolerations.isEmpty();
  }
  public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value) {
    return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
  }
  public A addToUnsupportedConfigOverrides(String key,Object value) {
    if(this.unsupportedConfigOverrides == null && key != null && value != null) { this.unsupportedConfigOverrides = new LinkedHashMap(); }
    if(key != null && value != null) {this.unsupportedConfigOverrides.put(key, value);} return (A)this;
  }
  public A addToUnsupportedConfigOverrides(Map<String,Object> map) {
    if(this.unsupportedConfigOverrides == null && map != null) { this.unsupportedConfigOverrides = new LinkedHashMap(); }
    if(map != null) { this.unsupportedConfigOverrides.putAll(map);} return (A)this;
  }
  public A removeFromUnsupportedConfigOverrides(String key) {
    if(this.unsupportedConfigOverrides == null) { return (A) this; }
    if(key != null && this.unsupportedConfigOverrides != null) {this.unsupportedConfigOverrides.remove(key);} return (A)this;
  }
  public A removeFromUnsupportedConfigOverrides(Map<String,Object> map) {
    if(this.unsupportedConfigOverrides == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.unsupportedConfigOverrides != null){this.unsupportedConfigOverrides.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides;
  }
  public <K,V>A withUnsupportedConfigOverrides(Map<String,Object> unsupportedConfigOverrides) {
    if (unsupportedConfigOverrides == null) { this.unsupportedConfigOverrides =  null;} else {this.unsupportedConfigOverrides = new LinkedHashMap(unsupportedConfigOverrides);} return (A) this;
  }
  public Boolean hasUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ImageRegistrySpecFluentImpl that = (ImageRegistrySpecFluentImpl) o;
    if (!java.util.Objects.equals(affinity, that.affinity)) return false;

    if (!java.util.Objects.equals(defaultRoute, that.defaultRoute)) return false;

    if (!java.util.Objects.equals(disableRedirect, that.disableRedirect)) return false;

    if (!java.util.Objects.equals(httpSecret, that.httpSecret)) return false;

    if (!java.util.Objects.equals(logLevel, that.logLevel)) return false;

    if (!java.util.Objects.equals(logging, that.logging)) return false;

    if (!java.util.Objects.equals(managementState, that.managementState)) return false;

    if (!java.util.Objects.equals(nodeSelector, that.nodeSelector)) return false;

    if (!java.util.Objects.equals(observedConfig, that.observedConfig)) return false;

    if (!java.util.Objects.equals(operatorLogLevel, that.operatorLogLevel)) return false;

    if (!java.util.Objects.equals(proxy, that.proxy)) return false;

    if (!java.util.Objects.equals(readOnly, that.readOnly)) return false;

    if (!java.util.Objects.equals(replicas, that.replicas)) return false;

    if (!java.util.Objects.equals(requests, that.requests)) return false;

    if (!java.util.Objects.equals(resources, that.resources)) return false;

    if (!java.util.Objects.equals(rolloutStrategy, that.rolloutStrategy)) return false;

    if (!java.util.Objects.equals(routes, that.routes)) return false;

    if (!java.util.Objects.equals(storage, that.storage)) return false;

    if (!java.util.Objects.equals(tolerations, that.tolerations)) return false;

    if (!java.util.Objects.equals(unsupportedConfigOverrides, that.unsupportedConfigOverrides)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(affinity,  defaultRoute,  disableRedirect,  httpSecret,  logLevel,  logging,  managementState,  nodeSelector,  observedConfig,  operatorLogLevel,  proxy,  readOnly,  replicas,  requests,  resources,  rolloutStrategy,  routes,  storage,  tolerations,  unsupportedConfigOverrides,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (affinity != null) { sb.append("affinity:"); sb.append(affinity + ","); }
    if (defaultRoute != null) { sb.append("defaultRoute:"); sb.append(defaultRoute + ","); }
    if (disableRedirect != null) { sb.append("disableRedirect:"); sb.append(disableRedirect + ","); }
    if (httpSecret != null) { sb.append("httpSecret:"); sb.append(httpSecret + ","); }
    if (logLevel != null) { sb.append("logLevel:"); sb.append(logLevel + ","); }
    if (logging != null) { sb.append("logging:"); sb.append(logging + ","); }
    if (managementState != null) { sb.append("managementState:"); sb.append(managementState + ","); }
    if (nodeSelector != null && !nodeSelector.isEmpty()) { sb.append("nodeSelector:"); sb.append(nodeSelector + ","); }
    if (observedConfig != null && !observedConfig.isEmpty()) { sb.append("observedConfig:"); sb.append(observedConfig + ","); }
    if (operatorLogLevel != null) { sb.append("operatorLogLevel:"); sb.append(operatorLogLevel + ","); }
    if (proxy != null) { sb.append("proxy:"); sb.append(proxy + ","); }
    if (readOnly != null) { sb.append("readOnly:"); sb.append(readOnly + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (requests != null) { sb.append("requests:"); sb.append(requests + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (rolloutStrategy != null) { sb.append("rolloutStrategy:"); sb.append(rolloutStrategy + ","); }
    if (routes != null) { sb.append("routes:"); sb.append(routes + ","); }
    if (storage != null) { sb.append("storage:"); sb.append(storage + ","); }
    if (tolerations != null && !tolerations.isEmpty()) { sb.append("tolerations:"); sb.append(tolerations + ","); }
    if (unsupportedConfigOverrides != null && !unsupportedConfigOverrides.isEmpty()) { sb.append("unsupportedConfigOverrides:"); sb.append(unsupportedConfigOverrides + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withDefaultRoute() {
    return withDefaultRoute(true);
  }
  public A withDisableRedirect() {
    return withDisableRedirect(true);
  }
  public A withReadOnly() {
    return withReadOnly(true);
  }
  class ProxyNestedImpl<N> extends ImageRegistryConfigProxyFluentImpl<ImageRegistrySpecFluentImpl.ProxyNested<N>> implements ImageRegistrySpecFluentImpl.ProxyNested<N>,Nested<N>{
    ProxyNestedImpl(ImageRegistryConfigProxy item) {
      this.builder = new ImageRegistryConfigProxyBuilder(this, item);
    }
    ProxyNestedImpl() {
      this.builder = new ImageRegistryConfigProxyBuilder(this);
    }
    ImageRegistryConfigProxyBuilder builder;
    public N and() {
      return (N) ImageRegistrySpecFluentImpl.this.withProxy(builder.build());
    }
    public N endProxy() {
      return and();
    }
    
  }
  class RequestsNestedImpl<N> extends ImageRegistryConfigRequestsFluentImpl<ImageRegistrySpecFluentImpl.RequestsNested<N>> implements ImageRegistrySpecFluentImpl.RequestsNested<N>,Nested<N>{
    RequestsNestedImpl(ImageRegistryConfigRequests item) {
      this.builder = new ImageRegistryConfigRequestsBuilder(this, item);
    }
    RequestsNestedImpl() {
      this.builder = new ImageRegistryConfigRequestsBuilder(this);
    }
    ImageRegistryConfigRequestsBuilder builder;
    public N and() {
      return (N) ImageRegistrySpecFluentImpl.this.withRequests(builder.build());
    }
    public N endRequests() {
      return and();
    }
    
  }
  class ResourcesNestedImpl<N> extends ResourceRequirementsFluentImpl<ImageRegistrySpecFluentImpl.ResourcesNested<N>> implements ImageRegistrySpecFluentImpl.ResourcesNested<N>,Nested<N>{
    ResourcesNestedImpl(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourcesNestedImpl() {
      this.builder = new ResourceRequirementsBuilder(this);
    }
    ResourceRequirementsBuilder builder;
    public N and() {
      return (N) ImageRegistrySpecFluentImpl.this.withResources(builder.build());
    }
    public N endResources() {
      return and();
    }
    
  }
  class RoutesNestedImpl<N> extends ImageRegistryConfigRouteFluentImpl<ImageRegistrySpecFluentImpl.RoutesNested<N>> implements ImageRegistrySpecFluentImpl.RoutesNested<N>,Nested<N>{
    RoutesNestedImpl(int index,ImageRegistryConfigRoute item) {
      this.index = index;
      this.builder = new ImageRegistryConfigRouteBuilder(this, item);
    }
    RoutesNestedImpl() {
      this.index = -1;
      this.builder = new ImageRegistryConfigRouteBuilder(this);
    }
    ImageRegistryConfigRouteBuilder builder;
    int index;
    public N and() {
      return (N) ImageRegistrySpecFluentImpl.this.setToRoutes(index,builder.build());
    }
    public N endRoute() {
      return and();
    }
    
  }
  class StorageNestedImpl<N> extends ImageRegistryConfigStorageFluentImpl<ImageRegistrySpecFluentImpl.StorageNested<N>> implements ImageRegistrySpecFluentImpl.StorageNested<N>,Nested<N>{
    StorageNestedImpl(ImageRegistryConfigStorage item) {
      this.builder = new ImageRegistryConfigStorageBuilder(this, item);
    }
    StorageNestedImpl() {
      this.builder = new ImageRegistryConfigStorageBuilder(this);
    }
    ImageRegistryConfigStorageBuilder builder;
    public N and() {
      return (N) ImageRegistrySpecFluentImpl.this.withStorage(builder.build());
    }
    public N endStorage() {
      return and();
    }
    
  }
  
}