package io.fabric8.openshift.api.model.miscellaneous.network.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EgressRouterAddressBuilder extends EgressRouterAddressFluentImpl<EgressRouterAddressBuilder> implements VisitableBuilder<EgressRouterAddress,EgressRouterAddressBuilder>{
  public EgressRouterAddressBuilder() {
    this(false);
  }
  public EgressRouterAddressBuilder(Boolean validationEnabled) {
    this(new EgressRouterAddress(), validationEnabled);
  }
  public EgressRouterAddressBuilder(EgressRouterAddressFluent<?> fluent) {
    this(fluent, false);
  }
  public EgressRouterAddressBuilder(EgressRouterAddressFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EgressRouterAddress(), validationEnabled);
  }
  public EgressRouterAddressBuilder(EgressRouterAddressFluent<?> fluent,EgressRouterAddress instance) {
    this(fluent, instance, false);
  }
  public EgressRouterAddressBuilder(EgressRouterAddressFluent<?> fluent,EgressRouterAddress instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withGateway(instance.getGateway());
      fluent.withIp(instance.getIp());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EgressRouterAddressBuilder(EgressRouterAddress instance) {
    this(instance,false);
  }
  public EgressRouterAddressBuilder(EgressRouterAddress instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withGateway(instance.getGateway());
      this.withIp(instance.getIp());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EgressRouterAddressFluent<?> fluent;
  Boolean validationEnabled;
  public EgressRouterAddress build() {
    EgressRouterAddress buildable = new EgressRouterAddress(fluent.getGateway(),fluent.getIp());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}