package io.fabric8.openshift.api.model.miscellaneous.apiserver.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class APIRequestCountSpecBuilder extends APIRequestCountSpecFluent<APIRequestCountSpecBuilder> implements VisitableBuilder<APIRequestCountSpec,APIRequestCountSpecBuilder>{
  public APIRequestCountSpecBuilder() {
    this(false);
  }
  public APIRequestCountSpecBuilder(Boolean validationEnabled) {
    this(new APIRequestCountSpec(), validationEnabled);
  }
  public APIRequestCountSpecBuilder(APIRequestCountSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public APIRequestCountSpecBuilder(APIRequestCountSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new APIRequestCountSpec(), validationEnabled);
  }
  public APIRequestCountSpecBuilder(APIRequestCountSpecFluent<?> fluent,APIRequestCountSpec instance) {
    this(fluent, instance, false);
  }
  public APIRequestCountSpecBuilder(APIRequestCountSpecFluent<?> fluent,APIRequestCountSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new APIRequestCountSpec());

    if (instance != null) {
      fluent.withNumberOfUsersToReport(instance.getNumberOfUsersToReport());
      fluent.withNumberOfUsersToReport(instance.getNumberOfUsersToReport());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public APIRequestCountSpecBuilder(APIRequestCountSpec instance) {
    this(instance,false);
  }
  public APIRequestCountSpecBuilder(APIRequestCountSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new APIRequestCountSpec());

    if (instance != null) {
      this.withNumberOfUsersToReport(instance.getNumberOfUsersToReport());
      this.withNumberOfUsersToReport(instance.getNumberOfUsersToReport());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  APIRequestCountSpecFluent<?> fluent;
  Boolean validationEnabled;
  public APIRequestCountSpec build() {
    APIRequestCountSpec buildable = new APIRequestCountSpec(fluent.getNumberOfUsersToReport());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}