package io.fabric8.openshift.api.model.miscellaneous.apiserver.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class APIRequestCountStatusBuilder extends APIRequestCountStatusFluent<APIRequestCountStatusBuilder> implements VisitableBuilder<APIRequestCountStatus,APIRequestCountStatusBuilder>{
  public APIRequestCountStatusBuilder() {
    this(false);
  }
  public APIRequestCountStatusBuilder(Boolean validationEnabled) {
    this(new APIRequestCountStatus(), validationEnabled);
  }
  public APIRequestCountStatusBuilder(APIRequestCountStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public APIRequestCountStatusBuilder(APIRequestCountStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new APIRequestCountStatus(), validationEnabled);
  }
  public APIRequestCountStatusBuilder(APIRequestCountStatusFluent<?> fluent,APIRequestCountStatus instance) {
    this(fluent, instance, false);
  }
  public APIRequestCountStatusBuilder(APIRequestCountStatusFluent<?> fluent,APIRequestCountStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new APIRequestCountStatus());

    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withCurrentHour(instance.getCurrentHour());
      fluent.withLast24h(instance.getLast24h());
      fluent.withRemovedInRelease(instance.getRemovedInRelease());
      fluent.withRequestCount(instance.getRequestCount());
      fluent.withConditions(instance.getConditions());
      fluent.withCurrentHour(instance.getCurrentHour());
      fluent.withLast24h(instance.getLast24h());
      fluent.withRemovedInRelease(instance.getRemovedInRelease());
      fluent.withRequestCount(instance.getRequestCount());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public APIRequestCountStatusBuilder(APIRequestCountStatus instance) {
    this(instance,false);
  }
  public APIRequestCountStatusBuilder(APIRequestCountStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new APIRequestCountStatus());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withCurrentHour(instance.getCurrentHour());
      this.withLast24h(instance.getLast24h());
      this.withRemovedInRelease(instance.getRemovedInRelease());
      this.withRequestCount(instance.getRequestCount());
      this.withConditions(instance.getConditions());
      this.withCurrentHour(instance.getCurrentHour());
      this.withLast24h(instance.getLast24h());
      this.withRemovedInRelease(instance.getRemovedInRelease());
      this.withRequestCount(instance.getRequestCount());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  APIRequestCountStatusFluent<?> fluent;
  Boolean validationEnabled;
  public APIRequestCountStatus build() {
    APIRequestCountStatus buildable = new APIRequestCountStatus(fluent.getConditions(),fluent.buildCurrentHour(),fluent.buildLast24h(),fluent.getRemovedInRelease(),fluent.getRequestCount());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}