package io.fabric8.openshift.api.model.miscellaneous.apiserver.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PerUserAPIRequestCountBuilder extends PerUserAPIRequestCountFluent<PerUserAPIRequestCountBuilder> implements VisitableBuilder<PerUserAPIRequestCount,PerUserAPIRequestCountBuilder>{
  public PerUserAPIRequestCountBuilder() {
    this(false);
  }
  public PerUserAPIRequestCountBuilder(Boolean validationEnabled) {
    this(new PerUserAPIRequestCount(), validationEnabled);
  }
  public PerUserAPIRequestCountBuilder(PerUserAPIRequestCountFluent<?> fluent) {
    this(fluent, false);
  }
  public PerUserAPIRequestCountBuilder(PerUserAPIRequestCountFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PerUserAPIRequestCount(), validationEnabled);
  }
  public PerUserAPIRequestCountBuilder(PerUserAPIRequestCountFluent<?> fluent,PerUserAPIRequestCount instance) {
    this(fluent, instance, false);
  }
  public PerUserAPIRequestCountBuilder(PerUserAPIRequestCountFluent<?> fluent,PerUserAPIRequestCount instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PerUserAPIRequestCount());

    if (instance != null) {
      fluent.withByVerb(instance.getByVerb());
      fluent.withRequestCount(instance.getRequestCount());
      fluent.withUserAgent(instance.getUserAgent());
      fluent.withUsername(instance.getUsername());
      fluent.withByVerb(instance.getByVerb());
      fluent.withRequestCount(instance.getRequestCount());
      fluent.withUserAgent(instance.getUserAgent());
      fluent.withUsername(instance.getUsername());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PerUserAPIRequestCountBuilder(PerUserAPIRequestCount instance) {
    this(instance,false);
  }
  public PerUserAPIRequestCountBuilder(PerUserAPIRequestCount instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PerUserAPIRequestCount());

    if (instance != null) {
      this.withByVerb(instance.getByVerb());
      this.withRequestCount(instance.getRequestCount());
      this.withUserAgent(instance.getUserAgent());
      this.withUsername(instance.getUsername());
      this.withByVerb(instance.getByVerb());
      this.withRequestCount(instance.getRequestCount());
      this.withUserAgent(instance.getUserAgent());
      this.withUsername(instance.getUsername());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PerUserAPIRequestCountFluent<?> fluent;
  Boolean validationEnabled;
  public PerUserAPIRequestCount build() {
    PerUserAPIRequestCount buildable = new PerUserAPIRequestCount(fluent.buildByVerb(),fluent.getRequestCount(),fluent.getUserAgent(),fluent.getUsername());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}