package io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CredentialsRequestBuilder extends CredentialsRequestFluent<CredentialsRequestBuilder> implements VisitableBuilder<CredentialsRequest,CredentialsRequestBuilder>{
  public CredentialsRequestBuilder() {
    this(false);
  }
  public CredentialsRequestBuilder(Boolean validationEnabled) {
    this(new CredentialsRequest(), validationEnabled);
  }
  public CredentialsRequestBuilder(CredentialsRequestFluent<?> fluent) {
    this(fluent, false);
  }
  public CredentialsRequestBuilder(CredentialsRequestFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CredentialsRequest(), validationEnabled);
  }
  public CredentialsRequestBuilder(CredentialsRequestFluent<?> fluent,CredentialsRequest instance) {
    this(fluent, instance, false);
  }
  public CredentialsRequestBuilder(CredentialsRequestFluent<?> fluent,CredentialsRequest instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CredentialsRequest());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CredentialsRequestBuilder(CredentialsRequest instance) {
    this(instance,false);
  }
  public CredentialsRequestBuilder(CredentialsRequest instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CredentialsRequest());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CredentialsRequestFluent<?> fluent;
  Boolean validationEnabled;
  public CredentialsRequest build() {
    CredentialsRequest buildable = new CredentialsRequest(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}