package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EncryptionAlibabaBuilder extends EncryptionAlibabaFluent<EncryptionAlibabaBuilder> implements VisitableBuilder<EncryptionAlibaba,EncryptionAlibabaBuilder>{
  public EncryptionAlibabaBuilder() {
    this(false);
  }
  public EncryptionAlibabaBuilder(Boolean validationEnabled) {
    this(new EncryptionAlibaba(), validationEnabled);
  }
  public EncryptionAlibabaBuilder(EncryptionAlibabaFluent<?> fluent) {
    this(fluent, false);
  }
  public EncryptionAlibabaBuilder(EncryptionAlibabaFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EncryptionAlibaba(), validationEnabled);
  }
  public EncryptionAlibabaBuilder(EncryptionAlibabaFluent<?> fluent,EncryptionAlibaba instance) {
    this(fluent, instance, false);
  }
  public EncryptionAlibabaBuilder(EncryptionAlibabaFluent<?> fluent,EncryptionAlibaba instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new EncryptionAlibaba());

    if (instance != null) {
      fluent.withKms(instance.getKms());
      fluent.withMethod(instance.getMethod());
      fluent.withKms(instance.getKms());
      fluent.withMethod(instance.getMethod());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EncryptionAlibabaBuilder(EncryptionAlibaba instance) {
    this(instance,false);
  }
  public EncryptionAlibabaBuilder(EncryptionAlibaba instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new EncryptionAlibaba());

    if (instance != null) {
      this.withKms(instance.getKms());
      this.withMethod(instance.getMethod());
      this.withKms(instance.getKms());
      this.withMethod(instance.getMethod());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EncryptionAlibabaFluent<?> fluent;
  Boolean validationEnabled;
  public EncryptionAlibaba build() {
    EncryptionAlibaba buildable = new EncryptionAlibaba(fluent.buildKms(),fluent.getMethod());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}