package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageRegistryConfigProxyBuilder extends ImageRegistryConfigProxyFluent<ImageRegistryConfigProxyBuilder> implements VisitableBuilder<ImageRegistryConfigProxy,ImageRegistryConfigProxyBuilder>{
  public ImageRegistryConfigProxyBuilder() {
    this(false);
  }
  public ImageRegistryConfigProxyBuilder(Boolean validationEnabled) {
    this(new ImageRegistryConfigProxy(), validationEnabled);
  }
  public ImageRegistryConfigProxyBuilder(ImageRegistryConfigProxyFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageRegistryConfigProxyBuilder(ImageRegistryConfigProxyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageRegistryConfigProxy(), validationEnabled);
  }
  public ImageRegistryConfigProxyBuilder(ImageRegistryConfigProxyFluent<?> fluent,ImageRegistryConfigProxy instance) {
    this(fluent, instance, false);
  }
  public ImageRegistryConfigProxyBuilder(ImageRegistryConfigProxyFluent<?> fluent,ImageRegistryConfigProxy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ImageRegistryConfigProxy());

    if (instance != null) {
      fluent.withHttp(instance.getHttp());
      fluent.withHttps(instance.getHttps());
      fluent.withNoProxy(instance.getNoProxy());
      fluent.withHttp(instance.getHttp());
      fluent.withHttps(instance.getHttps());
      fluent.withNoProxy(instance.getNoProxy());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageRegistryConfigProxyBuilder(ImageRegistryConfigProxy instance) {
    this(instance,false);
  }
  public ImageRegistryConfigProxyBuilder(ImageRegistryConfigProxy instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ImageRegistryConfigProxy());

    if (instance != null) {
      this.withHttp(instance.getHttp());
      this.withHttps(instance.getHttps());
      this.withNoProxy(instance.getNoProxy());
      this.withHttp(instance.getHttp());
      this.withHttps(instance.getHttps());
      this.withNoProxy(instance.getNoProxy());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageRegistryConfigProxyFluent<?> fluent;
  Boolean validationEnabled;
  public ImageRegistryConfigProxy build() {
    ImageRegistryConfigProxy buildable = new ImageRegistryConfigProxy(fluent.getHttp(),fluent.getHttps(),fluent.getNoProxy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}