package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageRegistryConfigRequestsBuilder extends ImageRegistryConfigRequestsFluent<ImageRegistryConfigRequestsBuilder> implements VisitableBuilder<ImageRegistryConfigRequests,ImageRegistryConfigRequestsBuilder>{
  public ImageRegistryConfigRequestsBuilder() {
    this(false);
  }
  public ImageRegistryConfigRequestsBuilder(Boolean validationEnabled) {
    this(new ImageRegistryConfigRequests(), validationEnabled);
  }
  public ImageRegistryConfigRequestsBuilder(ImageRegistryConfigRequestsFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageRegistryConfigRequestsBuilder(ImageRegistryConfigRequestsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageRegistryConfigRequests(), validationEnabled);
  }
  public ImageRegistryConfigRequestsBuilder(ImageRegistryConfigRequestsFluent<?> fluent,ImageRegistryConfigRequests instance) {
    this(fluent, instance, false);
  }
  public ImageRegistryConfigRequestsBuilder(ImageRegistryConfigRequestsFluent<?> fluent,ImageRegistryConfigRequests instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ImageRegistryConfigRequests());

    if (instance != null) {
      fluent.withRead(instance.getRead());
      fluent.withWrite(instance.getWrite());
      fluent.withRead(instance.getRead());
      fluent.withWrite(instance.getWrite());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageRegistryConfigRequestsBuilder(ImageRegistryConfigRequests instance) {
    this(instance,false);
  }
  public ImageRegistryConfigRequestsBuilder(ImageRegistryConfigRequests instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ImageRegistryConfigRequests());

    if (instance != null) {
      this.withRead(instance.getRead());
      this.withWrite(instance.getWrite());
      this.withRead(instance.getRead());
      this.withWrite(instance.getWrite());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageRegistryConfigRequestsFluent<?> fluent;
  Boolean validationEnabled;
  public ImageRegistryConfigRequests build() {
    ImageRegistryConfigRequests buildable = new ImageRegistryConfigRequests(fluent.buildRead(),fluent.buildWrite());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}