package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageRegistryConfigStorageGCSBuilder extends ImageRegistryConfigStorageGCSFluent<ImageRegistryConfigStorageGCSBuilder> implements VisitableBuilder<ImageRegistryConfigStorageGCS,ImageRegistryConfigStorageGCSBuilder>{
  public ImageRegistryConfigStorageGCSBuilder() {
    this(false);
  }
  public ImageRegistryConfigStorageGCSBuilder(Boolean validationEnabled) {
    this(new ImageRegistryConfigStorageGCS(), validationEnabled);
  }
  public ImageRegistryConfigStorageGCSBuilder(ImageRegistryConfigStorageGCSFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageRegistryConfigStorageGCSBuilder(ImageRegistryConfigStorageGCSFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageRegistryConfigStorageGCS(), validationEnabled);
  }
  public ImageRegistryConfigStorageGCSBuilder(ImageRegistryConfigStorageGCSFluent<?> fluent,ImageRegistryConfigStorageGCS instance) {
    this(fluent, instance, false);
  }
  public ImageRegistryConfigStorageGCSBuilder(ImageRegistryConfigStorageGCSFluent<?> fluent,ImageRegistryConfigStorageGCS instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ImageRegistryConfigStorageGCS());

    if (instance != null) {
      fluent.withBucket(instance.getBucket());
      fluent.withKeyID(instance.getKeyID());
      fluent.withProjectID(instance.getProjectID());
      fluent.withRegion(instance.getRegion());
      fluent.withBucket(instance.getBucket());
      fluent.withKeyID(instance.getKeyID());
      fluent.withProjectID(instance.getProjectID());
      fluent.withRegion(instance.getRegion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageRegistryConfigStorageGCSBuilder(ImageRegistryConfigStorageGCS instance) {
    this(instance,false);
  }
  public ImageRegistryConfigStorageGCSBuilder(ImageRegistryConfigStorageGCS instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ImageRegistryConfigStorageGCS());

    if (instance != null) {
      this.withBucket(instance.getBucket());
      this.withKeyID(instance.getKeyID());
      this.withProjectID(instance.getProjectID());
      this.withRegion(instance.getRegion());
      this.withBucket(instance.getBucket());
      this.withKeyID(instance.getKeyID());
      this.withProjectID(instance.getProjectID());
      this.withRegion(instance.getRegion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageRegistryConfigStorageGCSFluent<?> fluent;
  Boolean validationEnabled;
  public ImageRegistryConfigStorageGCS build() {
    ImageRegistryConfigStorageGCS buildable = new ImageRegistryConfigStorageGCS(fluent.getBucket(),fluent.getKeyID(),fluent.getProjectID(),fluent.getRegion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}