package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageRegistryConfigStoragePVCBuilder extends ImageRegistryConfigStoragePVCFluent<ImageRegistryConfigStoragePVCBuilder> implements VisitableBuilder<ImageRegistryConfigStoragePVC,ImageRegistryConfigStoragePVCBuilder>{
  public ImageRegistryConfigStoragePVCBuilder() {
    this(false);
  }
  public ImageRegistryConfigStoragePVCBuilder(Boolean validationEnabled) {
    this(new ImageRegistryConfigStoragePVC(), validationEnabled);
  }
  public ImageRegistryConfigStoragePVCBuilder(ImageRegistryConfigStoragePVCFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageRegistryConfigStoragePVCBuilder(ImageRegistryConfigStoragePVCFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageRegistryConfigStoragePVC(), validationEnabled);
  }
  public ImageRegistryConfigStoragePVCBuilder(ImageRegistryConfigStoragePVCFluent<?> fluent,ImageRegistryConfigStoragePVC instance) {
    this(fluent, instance, false);
  }
  public ImageRegistryConfigStoragePVCBuilder(ImageRegistryConfigStoragePVCFluent<?> fluent,ImageRegistryConfigStoragePVC instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ImageRegistryConfigStoragePVC());

    if (instance != null) {
      fluent.withClaim(instance.getClaim());
      fluent.withClaim(instance.getClaim());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageRegistryConfigStoragePVCBuilder(ImageRegistryConfigStoragePVC instance) {
    this(instance,false);
  }
  public ImageRegistryConfigStoragePVCBuilder(ImageRegistryConfigStoragePVC instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ImageRegistryConfigStoragePVC());

    if (instance != null) {
      this.withClaim(instance.getClaim());
      this.withClaim(instance.getClaim());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageRegistryConfigStoragePVCFluent<?> fluent;
  Boolean validationEnabled;
  public ImageRegistryConfigStoragePVC build() {
    ImageRegistryConfigStoragePVC buildable = new ImageRegistryConfigStoragePVC(fluent.getClaim());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}