package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageRegistryConfigStorageS3CloudFrontBuilder extends ImageRegistryConfigStorageS3CloudFrontFluent<ImageRegistryConfigStorageS3CloudFrontBuilder> implements VisitableBuilder<ImageRegistryConfigStorageS3CloudFront,ImageRegistryConfigStorageS3CloudFrontBuilder>{
  public ImageRegistryConfigStorageS3CloudFrontBuilder() {
    this(false);
  }
  public ImageRegistryConfigStorageS3CloudFrontBuilder(Boolean validationEnabled) {
    this(new ImageRegistryConfigStorageS3CloudFront(), validationEnabled);
  }
  public ImageRegistryConfigStorageS3CloudFrontBuilder(ImageRegistryConfigStorageS3CloudFrontFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageRegistryConfigStorageS3CloudFrontBuilder(ImageRegistryConfigStorageS3CloudFrontFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageRegistryConfigStorageS3CloudFront(), validationEnabled);
  }
  public ImageRegistryConfigStorageS3CloudFrontBuilder(ImageRegistryConfigStorageS3CloudFrontFluent<?> fluent,ImageRegistryConfigStorageS3CloudFront instance) {
    this(fluent, instance, false);
  }
  public ImageRegistryConfigStorageS3CloudFrontBuilder(ImageRegistryConfigStorageS3CloudFrontFluent<?> fluent,ImageRegistryConfigStorageS3CloudFront instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ImageRegistryConfigStorageS3CloudFront());

    if (instance != null) {
      fluent.withBaseURL(instance.getBaseURL());
      fluent.withDuration(instance.getDuration());
      fluent.withKeypairID(instance.getKeypairID());
      fluent.withPrivateKey(instance.getPrivateKey());
      fluent.withBaseURL(instance.getBaseURL());
      fluent.withDuration(instance.getDuration());
      fluent.withKeypairID(instance.getKeypairID());
      fluent.withPrivateKey(instance.getPrivateKey());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageRegistryConfigStorageS3CloudFrontBuilder(ImageRegistryConfigStorageS3CloudFront instance) {
    this(instance,false);
  }
  public ImageRegistryConfigStorageS3CloudFrontBuilder(ImageRegistryConfigStorageS3CloudFront instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ImageRegistryConfigStorageS3CloudFront());

    if (instance != null) {
      this.withBaseURL(instance.getBaseURL());
      this.withDuration(instance.getDuration());
      this.withKeypairID(instance.getKeypairID());
      this.withPrivateKey(instance.getPrivateKey());
      this.withBaseURL(instance.getBaseURL());
      this.withDuration(instance.getDuration());
      this.withKeypairID(instance.getKeypairID());
      this.withPrivateKey(instance.getPrivateKey());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageRegistryConfigStorageS3CloudFrontFluent<?> fluent;
  Boolean validationEnabled;
  public ImageRegistryConfigStorageS3CloudFront build() {
    ImageRegistryConfigStorageS3CloudFront buildable = new ImageRegistryConfigStorageS3CloudFront(fluent.getBaseURL(),fluent.getDuration(),fluent.getKeypairID(),fluent.getPrivateKey());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}