package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageRegistryStatusBuilder extends ImageRegistryStatusFluent<ImageRegistryStatusBuilder> implements VisitableBuilder<ImageRegistryStatus,ImageRegistryStatusBuilder>{
  public ImageRegistryStatusBuilder() {
    this(false);
  }
  public ImageRegistryStatusBuilder(Boolean validationEnabled) {
    this(new ImageRegistryStatus(), validationEnabled);
  }
  public ImageRegistryStatusBuilder(ImageRegistryStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageRegistryStatusBuilder(ImageRegistryStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageRegistryStatus(), validationEnabled);
  }
  public ImageRegistryStatusBuilder(ImageRegistryStatusFluent<?> fluent,ImageRegistryStatus instance) {
    this(fluent, instance, false);
  }
  public ImageRegistryStatusBuilder(ImageRegistryStatusFluent<?> fluent,ImageRegistryStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ImageRegistryStatus());

    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withGenerations(instance.getGenerations());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withReadyReplicas(instance.getReadyReplicas());
      fluent.withStorage(instance.getStorage());
      fluent.withStorageManaged(instance.getStorageManaged());
      fluent.withVersion(instance.getVersion());
      fluent.withConditions(instance.getConditions());
      fluent.withGenerations(instance.getGenerations());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withReadyReplicas(instance.getReadyReplicas());
      fluent.withStorage(instance.getStorage());
      fluent.withStorageManaged(instance.getStorageManaged());
      fluent.withVersion(instance.getVersion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageRegistryStatusBuilder(ImageRegistryStatus instance) {
    this(instance,false);
  }
  public ImageRegistryStatusBuilder(ImageRegistryStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ImageRegistryStatus());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withGenerations(instance.getGenerations());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withReadyReplicas(instance.getReadyReplicas());
      this.withStorage(instance.getStorage());
      this.withStorageManaged(instance.getStorageManaged());
      this.withVersion(instance.getVersion());
      this.withConditions(instance.getConditions());
      this.withGenerations(instance.getGenerations());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withReadyReplicas(instance.getReadyReplicas());
      this.withStorage(instance.getStorage());
      this.withStorageManaged(instance.getStorageManaged());
      this.withVersion(instance.getVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageRegistryStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ImageRegistryStatus build() {
    ImageRegistryStatus buildable = new ImageRegistryStatus(fluent.getConditions(),fluent.getGenerations(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.buildStorage(),fluent.getStorageManaged(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}