package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KMSEncryptionAlibabaBuilder extends KMSEncryptionAlibabaFluent<KMSEncryptionAlibabaBuilder> implements VisitableBuilder<KMSEncryptionAlibaba,KMSEncryptionAlibabaBuilder>{
  public KMSEncryptionAlibabaBuilder() {
    this(false);
  }
  public KMSEncryptionAlibabaBuilder(Boolean validationEnabled) {
    this(new KMSEncryptionAlibaba(), validationEnabled);
  }
  public KMSEncryptionAlibabaBuilder(KMSEncryptionAlibabaFluent<?> fluent) {
    this(fluent, false);
  }
  public KMSEncryptionAlibabaBuilder(KMSEncryptionAlibabaFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KMSEncryptionAlibaba(), validationEnabled);
  }
  public KMSEncryptionAlibabaBuilder(KMSEncryptionAlibabaFluent<?> fluent,KMSEncryptionAlibaba instance) {
    this(fluent, instance, false);
  }
  public KMSEncryptionAlibabaBuilder(KMSEncryptionAlibabaFluent<?> fluent,KMSEncryptionAlibaba instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KMSEncryptionAlibaba());

    if (instance != null) {
      fluent.withKeyID(instance.getKeyID());
      fluent.withKeyID(instance.getKeyID());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KMSEncryptionAlibabaBuilder(KMSEncryptionAlibaba instance) {
    this(instance,false);
  }
  public KMSEncryptionAlibabaBuilder(KMSEncryptionAlibaba instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KMSEncryptionAlibaba());

    if (instance != null) {
      this.withKeyID(instance.getKeyID());
      this.withKeyID(instance.getKeyID());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  KMSEncryptionAlibabaFluent<?> fluent;
  Boolean validationEnabled;
  public KMSEncryptionAlibaba build() {
    KMSEncryptionAlibaba buildable = new KMSEncryptionAlibaba(fluent.getKeyID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}