package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class S3TrustedCASourceBuilder extends S3TrustedCASourceFluent<S3TrustedCASourceBuilder> implements VisitableBuilder<S3TrustedCASource,S3TrustedCASourceBuilder>{
  public S3TrustedCASourceBuilder() {
    this(false);
  }
  public S3TrustedCASourceBuilder(Boolean validationEnabled) {
    this(new S3TrustedCASource(), validationEnabled);
  }
  public S3TrustedCASourceBuilder(S3TrustedCASourceFluent<?> fluent) {
    this(fluent, false);
  }
  public S3TrustedCASourceBuilder(S3TrustedCASourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new S3TrustedCASource(), validationEnabled);
  }
  public S3TrustedCASourceBuilder(S3TrustedCASourceFluent<?> fluent,S3TrustedCASource instance) {
    this(fluent, instance, false);
  }
  public S3TrustedCASourceBuilder(S3TrustedCASourceFluent<?> fluent,S3TrustedCASource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new S3TrustedCASource());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withName(instance.getName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public S3TrustedCASourceBuilder(S3TrustedCASource instance) {
    this(instance,false);
  }
  public S3TrustedCASourceBuilder(S3TrustedCASource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new S3TrustedCASource());

    if (instance != null) {
      this.withName(instance.getName());
      this.withName(instance.getName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  S3TrustedCASourceFluent<?> fluent;
  Boolean validationEnabled;
  public S3TrustedCASource build() {
    S3TrustedCASource buildable = new S3TrustedCASource(fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}