package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BareMetalHostBuilder extends BareMetalHostFluent<BareMetalHostBuilder> implements VisitableBuilder<BareMetalHost,BareMetalHostBuilder>{
  public BareMetalHostBuilder() {
    this(false);
  }
  public BareMetalHostBuilder(Boolean validationEnabled) {
    this(new BareMetalHost(), validationEnabled);
  }
  public BareMetalHostBuilder(BareMetalHostFluent<?> fluent) {
    this(fluent, false);
  }
  public BareMetalHostBuilder(BareMetalHostFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BareMetalHost(), validationEnabled);
  }
  public BareMetalHostBuilder(BareMetalHostFluent<?> fluent,BareMetalHost instance) {
    this(fluent, instance, false);
  }
  public BareMetalHostBuilder(BareMetalHostFluent<?> fluent,BareMetalHost instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new BareMetalHost());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BareMetalHostBuilder(BareMetalHost instance) {
    this(instance,false);
  }
  public BareMetalHostBuilder(BareMetalHost instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new BareMetalHost());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  BareMetalHostFluent<?> fluent;
  Boolean validationEnabled;
  public BareMetalHost build() {
    BareMetalHost buildable = new BareMetalHost(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}