package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BareMetalHostStatusBuilder extends BareMetalHostStatusFluent<BareMetalHostStatusBuilder> implements VisitableBuilder<BareMetalHostStatus,BareMetalHostStatusBuilder>{
  public BareMetalHostStatusBuilder() {
    this(false);
  }
  public BareMetalHostStatusBuilder(Boolean validationEnabled) {
    this(new BareMetalHostStatus(), validationEnabled);
  }
  public BareMetalHostStatusBuilder(BareMetalHostStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public BareMetalHostStatusBuilder(BareMetalHostStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BareMetalHostStatus(), validationEnabled);
  }
  public BareMetalHostStatusBuilder(BareMetalHostStatusFluent<?> fluent,BareMetalHostStatus instance) {
    this(fluent, instance, false);
  }
  public BareMetalHostStatusBuilder(BareMetalHostStatusFluent<?> fluent,BareMetalHostStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new BareMetalHostStatus());

    if (instance != null) {
      fluent.withErrorCount(instance.getErrorCount());
      fluent.withErrorMessage(instance.getErrorMessage());
      fluent.withErrorType(instance.getErrorType());
      fluent.withGoodCredentials(instance.getGoodCredentials());
      fluent.withHardware(instance.getHardware());
      fluent.withHardwareProfile(instance.getHardwareProfile());
      fluent.withLastUpdated(instance.getLastUpdated());
      fluent.withOperationHistory(instance.getOperationHistory());
      fluent.withOperationalStatus(instance.getOperationalStatus());
      fluent.withPoweredOn(instance.getPoweredOn());
      fluent.withProvisioning(instance.getProvisioning());
      fluent.withTriedCredentials(instance.getTriedCredentials());
      fluent.withErrorCount(instance.getErrorCount());
      fluent.withErrorMessage(instance.getErrorMessage());
      fluent.withErrorType(instance.getErrorType());
      fluent.withGoodCredentials(instance.getGoodCredentials());
      fluent.withHardware(instance.getHardware());
      fluent.withHardwareProfile(instance.getHardwareProfile());
      fluent.withLastUpdated(instance.getLastUpdated());
      fluent.withOperationHistory(instance.getOperationHistory());
      fluent.withOperationalStatus(instance.getOperationalStatus());
      fluent.withPoweredOn(instance.getPoweredOn());
      fluent.withProvisioning(instance.getProvisioning());
      fluent.withTriedCredentials(instance.getTriedCredentials());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BareMetalHostStatusBuilder(BareMetalHostStatus instance) {
    this(instance,false);
  }
  public BareMetalHostStatusBuilder(BareMetalHostStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new BareMetalHostStatus());

    if (instance != null) {
      this.withErrorCount(instance.getErrorCount());
      this.withErrorMessage(instance.getErrorMessage());
      this.withErrorType(instance.getErrorType());
      this.withGoodCredentials(instance.getGoodCredentials());
      this.withHardware(instance.getHardware());
      this.withHardwareProfile(instance.getHardwareProfile());
      this.withLastUpdated(instance.getLastUpdated());
      this.withOperationHistory(instance.getOperationHistory());
      this.withOperationalStatus(instance.getOperationalStatus());
      this.withPoweredOn(instance.getPoweredOn());
      this.withProvisioning(instance.getProvisioning());
      this.withTriedCredentials(instance.getTriedCredentials());
      this.withErrorCount(instance.getErrorCount());
      this.withErrorMessage(instance.getErrorMessage());
      this.withErrorType(instance.getErrorType());
      this.withGoodCredentials(instance.getGoodCredentials());
      this.withHardware(instance.getHardware());
      this.withHardwareProfile(instance.getHardwareProfile());
      this.withLastUpdated(instance.getLastUpdated());
      this.withOperationHistory(instance.getOperationHistory());
      this.withOperationalStatus(instance.getOperationalStatus());
      this.withPoweredOn(instance.getPoweredOn());
      this.withProvisioning(instance.getProvisioning());
      this.withTriedCredentials(instance.getTriedCredentials());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  BareMetalHostStatusFluent<?> fluent;
  Boolean validationEnabled;
  public BareMetalHostStatus build() {
    BareMetalHostStatus buildable = new BareMetalHostStatus(fluent.getErrorCount(),fluent.getErrorMessage(),fluent.getErrorType(),fluent.buildGoodCredentials(),fluent.buildHardware(),fluent.getHardwareProfile(),fluent.getLastUpdated(),fluent.buildOperationHistory(),fluent.getOperationalStatus(),fluent.getPoweredOn(),fluent.buildProvisioning(),fluent.buildTriedCredentials());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}