package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.lang.Double;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CPUFluent<A extends CPUFluent<A>> extends BaseFluent<A>{
  public CPUFluent() {
  }
  public CPUFluent(CPU instance) {
    instance = (instance != null ? instance : new CPU());

    if (instance != null) {
      this.withArch(instance.getArch());
      this.withClockMegahertz(instance.getClockMegahertz());
      this.withCount(instance.getCount());
      this.withFlags(instance.getFlags());
      this.withModel(instance.getModel());
      this.withArch(instance.getArch());
      this.withClockMegahertz(instance.getClockMegahertz());
      this.withCount(instance.getCount());
      this.withFlags(instance.getFlags());
      this.withModel(instance.getModel());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String arch;
  private Double clockMegahertz;
  private Integer count;
  private List<String> flags = new ArrayList<String>();
  private String model;
  private Map<String,Object> additionalProperties;
  public String getArch() {
    return this.arch;
  }
  public A withArch(String arch) {
    this.arch=arch; return (A) this;
  }
  public boolean hasArch() {
    return this.arch != null;
  }
  public Double getClockMegahertz() {
    return this.clockMegahertz;
  }
  public A withClockMegahertz(Double clockMegahertz) {
    this.clockMegahertz=clockMegahertz; return (A) this;
  }
  public boolean hasClockMegahertz() {
    return this.clockMegahertz != null;
  }
  public Integer getCount() {
    return this.count;
  }
  public A withCount(Integer count) {
    this.count=count; return (A) this;
  }
  public boolean hasCount() {
    return this.count != null;
  }
  public A addToFlags(int index,String item) {
    if (this.flags == null) {this.flags = new ArrayList<String>();}
    this.flags.add(index, item);
    return (A)this;
  }
  public A setToFlags(int index,String item) {
    if (this.flags == null) {this.flags = new ArrayList<String>();}
    this.flags.set(index, item); return (A)this;
  }
  public A addToFlags(java.lang.String... items) {
    if (this.flags == null) {this.flags = new ArrayList<String>();}
    for (String item : items) {this.flags.add(item);} return (A)this;
  }
  public A addAllToFlags(Collection<String> items) {
    if (this.flags == null) {this.flags = new ArrayList<String>();}
    for (String item : items) {this.flags.add(item);} return (A)this;
  }
  public A removeFromFlags(java.lang.String... items) {
    if (this.flags == null) return (A)this;
    for (String item : items) { this.flags.remove(item);} return (A)this;
  }
  public A removeAllFromFlags(Collection<String> items) {
    if (this.flags == null) return (A)this;
    for (String item : items) { this.flags.remove(item);} return (A)this;
  }
  public List<String> getFlags() {
    return this.flags;
  }
  public String getFlag(int index) {
    return this.flags.get(index);
  }
  public String getFirstFlag() {
    return this.flags.get(0);
  }
  public String getLastFlag() {
    return this.flags.get(flags.size() - 1);
  }
  public String getMatchingFlag(Predicate<String> predicate) {
    for (String item: flags) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingFlag(Predicate<String> predicate) {
    for (String item: flags) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withFlags(List<String> flags) {
    if (flags != null) {this.flags = new ArrayList(); for (String item : flags){this.addToFlags(item);}} else { this.flags = null;} return (A) this;
  }
  public A withFlags(java.lang.String... flags) {
    if (this.flags != null) {this.flags.clear(); _visitables.remove("flags"); }
    if (flags != null) {for (String item :flags){ this.addToFlags(item);}} return (A) this;
  }
  public boolean hasFlags() {
    return flags != null && !flags.isEmpty();
  }
  public String getModel() {
    return this.model;
  }
  public A withModel(String model) {
    this.model=model; return (A) this;
  }
  public boolean hasModel() {
    return this.model != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CPUFluent that = (CPUFluent) o;
    if (!java.util.Objects.equals(arch, that.arch)) return false;

    if (!java.util.Objects.equals(clockMegahertz, that.clockMegahertz)) return false;

    if (!java.util.Objects.equals(count, that.count)) return false;

    if (!java.util.Objects.equals(flags, that.flags)) return false;

    if (!java.util.Objects.equals(model, that.model)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(arch,  clockMegahertz,  count,  flags,  model,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (arch != null) { sb.append("arch:"); sb.append(arch + ","); }
    if (clockMegahertz != null) { sb.append("clockMegahertz:"); sb.append(clockMegahertz + ","); }
    if (count != null) { sb.append("count:"); sb.append(count + ","); }
    if (flags != null && !flags.isEmpty()) { sb.append("flags:"); sb.append(flags + ","); }
    if (model != null) { sb.append("model:"); sb.append(model + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}