package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CredentialsStatusBuilder extends CredentialsStatusFluent<CredentialsStatusBuilder> implements VisitableBuilder<CredentialsStatus,CredentialsStatusBuilder>{
  public CredentialsStatusBuilder() {
    this(false);
  }
  public CredentialsStatusBuilder(Boolean validationEnabled) {
    this(new CredentialsStatus(), validationEnabled);
  }
  public CredentialsStatusBuilder(CredentialsStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public CredentialsStatusBuilder(CredentialsStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CredentialsStatus(), validationEnabled);
  }
  public CredentialsStatusBuilder(CredentialsStatusFluent<?> fluent,CredentialsStatus instance) {
    this(fluent, instance, false);
  }
  public CredentialsStatusBuilder(CredentialsStatusFluent<?> fluent,CredentialsStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CredentialsStatus());

    if (instance != null) {
      fluent.withCredentials(instance.getCredentials());
      fluent.withCredentialsVersion(instance.getCredentialsVersion());
      fluent.withCredentials(instance.getCredentials());
      fluent.withCredentialsVersion(instance.getCredentialsVersion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CredentialsStatusBuilder(CredentialsStatus instance) {
    this(instance,false);
  }
  public CredentialsStatusBuilder(CredentialsStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CredentialsStatus());

    if (instance != null) {
      this.withCredentials(instance.getCredentials());
      this.withCredentialsVersion(instance.getCredentialsVersion());
      this.withCredentials(instance.getCredentials());
      this.withCredentialsVersion(instance.getCredentialsVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CredentialsStatusFluent<?> fluent;
  Boolean validationEnabled;
  public CredentialsStatus build() {
    CredentialsStatus buildable = new CredentialsStatus(fluent.getCredentials(),fluent.getCredentialsVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}