package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HardwareRAIDVolumeBuilder extends HardwareRAIDVolumeFluent<HardwareRAIDVolumeBuilder> implements VisitableBuilder<HardwareRAIDVolume,HardwareRAIDVolumeBuilder>{
  public HardwareRAIDVolumeBuilder() {
    this(false);
  }
  public HardwareRAIDVolumeBuilder(Boolean validationEnabled) {
    this(new HardwareRAIDVolume(), validationEnabled);
  }
  public HardwareRAIDVolumeBuilder(HardwareRAIDVolumeFluent<?> fluent) {
    this(fluent, false);
  }
  public HardwareRAIDVolumeBuilder(HardwareRAIDVolumeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HardwareRAIDVolume(), validationEnabled);
  }
  public HardwareRAIDVolumeBuilder(HardwareRAIDVolumeFluent<?> fluent,HardwareRAIDVolume instance) {
    this(fluent, instance, false);
  }
  public HardwareRAIDVolumeBuilder(HardwareRAIDVolumeFluent<?> fluent,HardwareRAIDVolume instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new HardwareRAIDVolume());

    if (instance != null) {
      fluent.withController(instance.getController());
      fluent.withLevel(instance.getLevel());
      fluent.withName(instance.getName());
      fluent.withNumberOfPhysicalDisks(instance.getNumberOfPhysicalDisks());
      fluent.withPhysicalDisks(instance.getPhysicalDisks());
      fluent.withRotational(instance.getRotational());
      fluent.withSizeGibibytes(instance.getSizeGibibytes());
      fluent.withController(instance.getController());
      fluent.withLevel(instance.getLevel());
      fluent.withName(instance.getName());
      fluent.withNumberOfPhysicalDisks(instance.getNumberOfPhysicalDisks());
      fluent.withPhysicalDisks(instance.getPhysicalDisks());
      fluent.withRotational(instance.getRotational());
      fluent.withSizeGibibytes(instance.getSizeGibibytes());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HardwareRAIDVolumeBuilder(HardwareRAIDVolume instance) {
    this(instance,false);
  }
  public HardwareRAIDVolumeBuilder(HardwareRAIDVolume instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new HardwareRAIDVolume());

    if (instance != null) {
      this.withController(instance.getController());
      this.withLevel(instance.getLevel());
      this.withName(instance.getName());
      this.withNumberOfPhysicalDisks(instance.getNumberOfPhysicalDisks());
      this.withPhysicalDisks(instance.getPhysicalDisks());
      this.withRotational(instance.getRotational());
      this.withSizeGibibytes(instance.getSizeGibibytes());
      this.withController(instance.getController());
      this.withLevel(instance.getLevel());
      this.withName(instance.getName());
      this.withNumberOfPhysicalDisks(instance.getNumberOfPhysicalDisks());
      this.withPhysicalDisks(instance.getPhysicalDisks());
      this.withRotational(instance.getRotational());
      this.withSizeGibibytes(instance.getSizeGibibytes());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  HardwareRAIDVolumeFluent<?> fluent;
  Boolean validationEnabled;
  public HardwareRAIDVolume build() {
    HardwareRAIDVolume buildable = new HardwareRAIDVolume(fluent.getController(),fluent.getLevel(),fluent.getName(),fluent.getNumberOfPhysicalDisks(),fluent.getPhysicalDisks(),fluent.getRotational(),fluent.getSizeGibibytes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}