package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OperationHistoryBuilder extends OperationHistoryFluent<OperationHistoryBuilder> implements VisitableBuilder<OperationHistory,OperationHistoryBuilder>{
  public OperationHistoryBuilder() {
    this(false);
  }
  public OperationHistoryBuilder(Boolean validationEnabled) {
    this(new OperationHistory(), validationEnabled);
  }
  public OperationHistoryBuilder(OperationHistoryFluent<?> fluent) {
    this(fluent, false);
  }
  public OperationHistoryBuilder(OperationHistoryFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OperationHistory(), validationEnabled);
  }
  public OperationHistoryBuilder(OperationHistoryFluent<?> fluent,OperationHistory instance) {
    this(fluent, instance, false);
  }
  public OperationHistoryBuilder(OperationHistoryFluent<?> fluent,OperationHistory instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new OperationHistory());

    if (instance != null) {
      fluent.withDeprovision(instance.getDeprovision());
      fluent.withInspect(instance.getInspect());
      fluent.withProvision(instance.getProvision());
      fluent.withRegister(instance.getRegister());
      fluent.withDeprovision(instance.getDeprovision());
      fluent.withInspect(instance.getInspect());
      fluent.withProvision(instance.getProvision());
      fluent.withRegister(instance.getRegister());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OperationHistoryBuilder(OperationHistory instance) {
    this(instance,false);
  }
  public OperationHistoryBuilder(OperationHistory instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new OperationHistory());

    if (instance != null) {
      this.withDeprovision(instance.getDeprovision());
      this.withInspect(instance.getInspect());
      this.withProvision(instance.getProvision());
      this.withRegister(instance.getRegister());
      this.withDeprovision(instance.getDeprovision());
      this.withInspect(instance.getInspect());
      this.withProvision(instance.getProvision());
      this.withRegister(instance.getRegister());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OperationHistoryFluent<?> fluent;
  Boolean validationEnabled;
  public OperationHistory build() {
    OperationHistory buildable = new OperationHistory(fluent.buildDeprovision(),fluent.buildInspect(),fluent.buildProvision(),fluent.buildRegister());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}