package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProvisionStatusBuilder extends ProvisionStatusFluent<ProvisionStatusBuilder> implements VisitableBuilder<ProvisionStatus,ProvisionStatusBuilder>{
  public ProvisionStatusBuilder() {
    this(false);
  }
  public ProvisionStatusBuilder(Boolean validationEnabled) {
    this(new ProvisionStatus(), validationEnabled);
  }
  public ProvisionStatusBuilder(ProvisionStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ProvisionStatusBuilder(ProvisionStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ProvisionStatus(), validationEnabled);
  }
  public ProvisionStatusBuilder(ProvisionStatusFluent<?> fluent,ProvisionStatus instance) {
    this(fluent, instance, false);
  }
  public ProvisionStatusBuilder(ProvisionStatusFluent<?> fluent,ProvisionStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ProvisionStatus());

    if (instance != null) {
      fluent.withId(instance.getId());
      fluent.withBootMode(instance.getBootMode());
      fluent.withCustomDeploy(instance.getCustomDeploy());
      fluent.withFirmware(instance.getFirmware());
      fluent.withImage(instance.getImage());
      fluent.withRaid(instance.getRaid());
      fluent.withRootDeviceHints(instance.getRootDeviceHints());
      fluent.withState(instance.getState());
      fluent.withId(instance.getId());
      fluent.withBootMode(instance.getBootMode());
      fluent.withCustomDeploy(instance.getCustomDeploy());
      fluent.withFirmware(instance.getFirmware());
      fluent.withImage(instance.getImage());
      fluent.withRaid(instance.getRaid());
      fluent.withRootDeviceHints(instance.getRootDeviceHints());
      fluent.withState(instance.getState());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ProvisionStatusBuilder(ProvisionStatus instance) {
    this(instance,false);
  }
  public ProvisionStatusBuilder(ProvisionStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ProvisionStatus());

    if (instance != null) {
      this.withId(instance.getId());
      this.withBootMode(instance.getBootMode());
      this.withCustomDeploy(instance.getCustomDeploy());
      this.withFirmware(instance.getFirmware());
      this.withImage(instance.getImage());
      this.withRaid(instance.getRaid());
      this.withRootDeviceHints(instance.getRootDeviceHints());
      this.withState(instance.getState());
      this.withId(instance.getId());
      this.withBootMode(instance.getBootMode());
      this.withCustomDeploy(instance.getCustomDeploy());
      this.withFirmware(instance.getFirmware());
      this.withImage(instance.getImage());
      this.withRaid(instance.getRaid());
      this.withRootDeviceHints(instance.getRootDeviceHints());
      this.withState(instance.getState());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ProvisionStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ProvisionStatus build() {
    ProvisionStatus buildable = new ProvisionStatus(fluent.getId(),fluent.getBootMode(),fluent.buildCustomDeploy(),fluent.buildFirmware(),fluent.buildImage(),fluent.buildRaid(),fluent.buildRootDeviceHints(),fluent.getState());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}