package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SoftwareRAIDVolumeBuilder extends SoftwareRAIDVolumeFluent<SoftwareRAIDVolumeBuilder> implements VisitableBuilder<SoftwareRAIDVolume,SoftwareRAIDVolumeBuilder>{
  public SoftwareRAIDVolumeBuilder() {
    this(false);
  }
  public SoftwareRAIDVolumeBuilder(Boolean validationEnabled) {
    this(new SoftwareRAIDVolume(), validationEnabled);
  }
  public SoftwareRAIDVolumeBuilder(SoftwareRAIDVolumeFluent<?> fluent) {
    this(fluent, false);
  }
  public SoftwareRAIDVolumeBuilder(SoftwareRAIDVolumeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SoftwareRAIDVolume(), validationEnabled);
  }
  public SoftwareRAIDVolumeBuilder(SoftwareRAIDVolumeFluent<?> fluent,SoftwareRAIDVolume instance) {
    this(fluent, instance, false);
  }
  public SoftwareRAIDVolumeBuilder(SoftwareRAIDVolumeFluent<?> fluent,SoftwareRAIDVolume instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SoftwareRAIDVolume());

    if (instance != null) {
      fluent.withLevel(instance.getLevel());
      fluent.withPhysicalDisks(instance.getPhysicalDisks());
      fluent.withSizeGibibytes(instance.getSizeGibibytes());
      fluent.withLevel(instance.getLevel());
      fluent.withPhysicalDisks(instance.getPhysicalDisks());
      fluent.withSizeGibibytes(instance.getSizeGibibytes());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SoftwareRAIDVolumeBuilder(SoftwareRAIDVolume instance) {
    this(instance,false);
  }
  public SoftwareRAIDVolumeBuilder(SoftwareRAIDVolume instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SoftwareRAIDVolume());

    if (instance != null) {
      this.withLevel(instance.getLevel());
      this.withPhysicalDisks(instance.getPhysicalDisks());
      this.withSizeGibibytes(instance.getSizeGibibytes());
      this.withLevel(instance.getLevel());
      this.withPhysicalDisks(instance.getPhysicalDisks());
      this.withSizeGibibytes(instance.getSizeGibibytes());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SoftwareRAIDVolumeFluent<?> fluent;
  Boolean validationEnabled;
  public SoftwareRAIDVolume build() {
    SoftwareRAIDVolume buildable = new SoftwareRAIDVolume(fluent.getLevel(),fluent.buildPhysicalDisks(),fluent.getSizeGibibytes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}