package io.fabric8.openshift.api.model.miscellaneous.network.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EgressRouterInterfaceBuilder extends EgressRouterInterfaceFluent<EgressRouterInterfaceBuilder> implements VisitableBuilder<EgressRouterInterface,EgressRouterInterfaceBuilder>{
  public EgressRouterInterfaceBuilder() {
    this(false);
  }
  public EgressRouterInterfaceBuilder(Boolean validationEnabled) {
    this(new EgressRouterInterface(), validationEnabled);
  }
  public EgressRouterInterfaceBuilder(EgressRouterInterfaceFluent<?> fluent) {
    this(fluent, false);
  }
  public EgressRouterInterfaceBuilder(EgressRouterInterfaceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EgressRouterInterface(), validationEnabled);
  }
  public EgressRouterInterfaceBuilder(EgressRouterInterfaceFluent<?> fluent,EgressRouterInterface instance) {
    this(fluent, instance, false);
  }
  public EgressRouterInterfaceBuilder(EgressRouterInterfaceFluent<?> fluent,EgressRouterInterface instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new EgressRouterInterface());

    if (instance != null) {
      fluent.withMacvlan(instance.getMacvlan());
      fluent.withMacvlan(instance.getMacvlan());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EgressRouterInterfaceBuilder(EgressRouterInterface instance) {
    this(instance,false);
  }
  public EgressRouterInterfaceBuilder(EgressRouterInterface instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new EgressRouterInterface());

    if (instance != null) {
      this.withMacvlan(instance.getMacvlan());
      this.withMacvlan(instance.getMacvlan());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EgressRouterInterfaceFluent<?> fluent;
  Boolean validationEnabled;
  public EgressRouterInterface build() {
    EgressRouterInterface buildable = new EgressRouterInterface(fluent.buildMacvlan());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}