package io.fabric8.openshift.api.model.miscellaneous.network.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EgressRouterListBuilder extends EgressRouterListFluent<EgressRouterListBuilder> implements VisitableBuilder<EgressRouterList,EgressRouterListBuilder>{
  public EgressRouterListBuilder() {
    this(false);
  }
  public EgressRouterListBuilder(Boolean validationEnabled) {
    this(new EgressRouterList(), validationEnabled);
  }
  public EgressRouterListBuilder(EgressRouterListFluent<?> fluent) {
    this(fluent, false);
  }
  public EgressRouterListBuilder(EgressRouterListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EgressRouterList(), validationEnabled);
  }
  public EgressRouterListBuilder(EgressRouterListFluent<?> fluent,EgressRouterList instance) {
    this(fluent, instance, false);
  }
  public EgressRouterListBuilder(EgressRouterListFluent<?> fluent,EgressRouterList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new EgressRouterList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EgressRouterListBuilder(EgressRouterList instance) {
    this(instance,false);
  }
  public EgressRouterListBuilder(EgressRouterList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new EgressRouterList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EgressRouterListFluent<?> fluent;
  Boolean validationEnabled;
  public EgressRouterList build() {
    EgressRouterList buildable = new EgressRouterList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}