package io.fabric8.openshift.api.model.miscellaneous.network.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EgressRouterSpecBuilder extends EgressRouterSpecFluent<EgressRouterSpecBuilder> implements VisitableBuilder<EgressRouterSpec,EgressRouterSpecBuilder>{
  public EgressRouterSpecBuilder() {
    this(false);
  }
  public EgressRouterSpecBuilder(Boolean validationEnabled) {
    this(new EgressRouterSpec(), validationEnabled);
  }
  public EgressRouterSpecBuilder(EgressRouterSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public EgressRouterSpecBuilder(EgressRouterSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EgressRouterSpec(), validationEnabled);
  }
  public EgressRouterSpecBuilder(EgressRouterSpecFluent<?> fluent,EgressRouterSpec instance) {
    this(fluent, instance, false);
  }
  public EgressRouterSpecBuilder(EgressRouterSpecFluent<?> fluent,EgressRouterSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new EgressRouterSpec());

    if (instance != null) {
      fluent.withAddresses(instance.getAddresses());
      fluent.withMode(instance.getMode());
      fluent.withNetworkInterface(instance.getNetworkInterface());
      fluent.withRedirect(instance.getRedirect());
      fluent.withAddresses(instance.getAddresses());
      fluent.withMode(instance.getMode());
      fluent.withNetworkInterface(instance.getNetworkInterface());
      fluent.withRedirect(instance.getRedirect());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EgressRouterSpecBuilder(EgressRouterSpec instance) {
    this(instance,false);
  }
  public EgressRouterSpecBuilder(EgressRouterSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new EgressRouterSpec());

    if (instance != null) {
      this.withAddresses(instance.getAddresses());
      this.withMode(instance.getMode());
      this.withNetworkInterface(instance.getNetworkInterface());
      this.withRedirect(instance.getRedirect());
      this.withAddresses(instance.getAddresses());
      this.withMode(instance.getMode());
      this.withNetworkInterface(instance.getNetworkInterface());
      this.withRedirect(instance.getRedirect());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EgressRouterSpecFluent<?> fluent;
  Boolean validationEnabled;
  public EgressRouterSpec build() {
    EgressRouterSpec buildable = new EgressRouterSpec(fluent.buildAddresses(),fluent.getMode(),fluent.buildNetworkInterface(),fluent.buildRedirect());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}