package io.fabric8.openshift.api.model.miscellaneous.network.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OperatorPKIListBuilder extends OperatorPKIListFluent<OperatorPKIListBuilder> implements VisitableBuilder<OperatorPKIList,OperatorPKIListBuilder>{
  public OperatorPKIListBuilder() {
    this(false);
  }
  public OperatorPKIListBuilder(Boolean validationEnabled) {
    this(new OperatorPKIList(), validationEnabled);
  }
  public OperatorPKIListBuilder(OperatorPKIListFluent<?> fluent) {
    this(fluent, false);
  }
  public OperatorPKIListBuilder(OperatorPKIListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OperatorPKIList(), validationEnabled);
  }
  public OperatorPKIListBuilder(OperatorPKIListFluent<?> fluent,OperatorPKIList instance) {
    this(fluent, instance, false);
  }
  public OperatorPKIListBuilder(OperatorPKIListFluent<?> fluent,OperatorPKIList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new OperatorPKIList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OperatorPKIListBuilder(OperatorPKIList instance) {
    this(instance,false);
  }
  public OperatorPKIListBuilder(OperatorPKIList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new OperatorPKIList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OperatorPKIListFluent<?> fluent;
  Boolean validationEnabled;
  public OperatorPKIList build() {
    OperatorPKIList buildable = new OperatorPKIList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}