package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class EncryptionAlibabaFluent<A extends EncryptionAlibabaFluent<A>> extends BaseFluent<A>{
  public EncryptionAlibabaFluent() {
  }
  
  public EncryptionAlibabaFluent(EncryptionAlibaba instance) {
    this.copyInstance(instance);
  }
  private KMSEncryptionAlibabaBuilder kms;
  private String method;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(EncryptionAlibaba instance) {
    instance = (instance != null ? instance : new EncryptionAlibaba());
  
    if (instance != null) {
        this.withKms(instance.getKms());
        this.withMethod(instance.getMethod());
        this.withKms(instance.getKms());
        this.withMethod(instance.getMethod());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public KMSEncryptionAlibaba buildKms() {
    return this.kms!=null ?this.kms.build():null;
  }
  
  public A withKms(KMSEncryptionAlibaba kms) {
    _visitables.get("kms").remove(this.kms);
    if (kms!=null){ this.kms= new KMSEncryptionAlibabaBuilder(kms); _visitables.get("kms").add(this.kms);} else { this.kms = null; _visitables.get("kms").remove(this.kms); } return (A) this;
  }
  
  public boolean hasKms() {
    return this.kms != null;
  }
  
  public A withNewKms(String keyID) {
    return (A)withKms(new KMSEncryptionAlibaba(keyID));
  }
  
  public KmsNested<A> withNewKms() {
    return new KmsNested(null);
  }
  
  public KmsNested<A> withNewKmsLike(KMSEncryptionAlibaba item) {
    return new KmsNested(item);
  }
  
  public KmsNested<A> editKms() {
    return withNewKmsLike(java.util.Optional.ofNullable(buildKms()).orElse(null));
  }
  
  public KmsNested<A> editOrNewKms() {
    return withNewKmsLike(java.util.Optional.ofNullable(buildKms()).orElse(new KMSEncryptionAlibabaBuilder().build()));
  }
  
  public KmsNested<A> editOrNewKmsLike(KMSEncryptionAlibaba item) {
    return withNewKmsLike(java.util.Optional.ofNullable(buildKms()).orElse(item));
  }
  
  public String getMethod() {
    return this.method;
  }
  
  public A withMethod(String method) {
    this.method=method; return (A) this;
  }
  
  public boolean hasMethod() {
    return this.method != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EncryptionAlibabaFluent that = (EncryptionAlibabaFluent) o;
    if (!java.util.Objects.equals(kms, that.kms)) return false;
  
    if (!java.util.Objects.equals(method, that.method)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(kms,  method,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (kms != null) { sb.append("kms:"); sb.append(kms + ","); }
    if (method != null) { sb.append("method:"); sb.append(method + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class KmsNested<N> extends KMSEncryptionAlibabaFluent<KmsNested<N>> implements Nested<N>{
    KmsNested(KMSEncryptionAlibaba item) {
      this.builder = new KMSEncryptionAlibabaBuilder(this, item);
    }
    KMSEncryptionAlibabaBuilder builder;
    
    public N and() {
      return (N) EncryptionAlibabaFluent.this.withKms(builder.build());
    }
    
    public N endKms() {
      return and();
    }
    
  
  }

}