package io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ImageRegistryConfigStorageS3Fluent<A extends ImageRegistryConfigStorageS3Fluent<A>> extends BaseFluent<A>{
  public ImageRegistryConfigStorageS3Fluent() {
  }
  
  public ImageRegistryConfigStorageS3Fluent(ImageRegistryConfigStorageS3 instance) {
    this.copyInstance(instance);
  }
  private String bucket;
  private ImageRegistryConfigStorageS3CloudFrontBuilder cloudFront;
  private Boolean encrypt;
  private String keyID;
  private String region;
  private String regionEndpoint;
  private S3TrustedCASourceBuilder trustedCA;
  private Boolean virtualHostedStyle;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ImageRegistryConfigStorageS3 instance) {
    instance = (instance != null ? instance : new ImageRegistryConfigStorageS3());
  
    if (instance != null) {
        this.withBucket(instance.getBucket());
        this.withCloudFront(instance.getCloudFront());
        this.withEncrypt(instance.getEncrypt());
        this.withKeyID(instance.getKeyID());
        this.withRegion(instance.getRegion());
        this.withRegionEndpoint(instance.getRegionEndpoint());
        this.withTrustedCA(instance.getTrustedCA());
        this.withVirtualHostedStyle(instance.getVirtualHostedStyle());
        this.withBucket(instance.getBucket());
        this.withCloudFront(instance.getCloudFront());
        this.withEncrypt(instance.getEncrypt());
        this.withKeyID(instance.getKeyID());
        this.withRegion(instance.getRegion());
        this.withRegionEndpoint(instance.getRegionEndpoint());
        this.withTrustedCA(instance.getTrustedCA());
        this.withVirtualHostedStyle(instance.getVirtualHostedStyle());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public String getBucket() {
    return this.bucket;
  }
  
  public A withBucket(String bucket) {
    this.bucket=bucket; return (A) this;
  }
  
  public boolean hasBucket() {
    return this.bucket != null;
  }
  
  public ImageRegistryConfigStorageS3CloudFront buildCloudFront() {
    return this.cloudFront!=null ?this.cloudFront.build():null;
  }
  
  public A withCloudFront(ImageRegistryConfigStorageS3CloudFront cloudFront) {
    _visitables.get("cloudFront").remove(this.cloudFront);
    if (cloudFront!=null){ this.cloudFront= new ImageRegistryConfigStorageS3CloudFrontBuilder(cloudFront); _visitables.get("cloudFront").add(this.cloudFront);} else { this.cloudFront = null; _visitables.get("cloudFront").remove(this.cloudFront); } return (A) this;
  }
  
  public boolean hasCloudFront() {
    return this.cloudFront != null;
  }
  
  public CloudFrontNested<A> withNewCloudFront() {
    return new CloudFrontNested(null);
  }
  
  public CloudFrontNested<A> withNewCloudFrontLike(ImageRegistryConfigStorageS3CloudFront item) {
    return new CloudFrontNested(item);
  }
  
  public CloudFrontNested<A> editCloudFront() {
    return withNewCloudFrontLike(java.util.Optional.ofNullable(buildCloudFront()).orElse(null));
  }
  
  public CloudFrontNested<A> editOrNewCloudFront() {
    return withNewCloudFrontLike(java.util.Optional.ofNullable(buildCloudFront()).orElse(new ImageRegistryConfigStorageS3CloudFrontBuilder().build()));
  }
  
  public CloudFrontNested<A> editOrNewCloudFrontLike(ImageRegistryConfigStorageS3CloudFront item) {
    return withNewCloudFrontLike(java.util.Optional.ofNullable(buildCloudFront()).orElse(item));
  }
  
  public Boolean getEncrypt() {
    return this.encrypt;
  }
  
  public A withEncrypt(Boolean encrypt) {
    this.encrypt=encrypt; return (A) this;
  }
  
  public boolean hasEncrypt() {
    return this.encrypt != null;
  }
  
  public String getKeyID() {
    return this.keyID;
  }
  
  public A withKeyID(String keyID) {
    this.keyID=keyID; return (A) this;
  }
  
  public boolean hasKeyID() {
    return this.keyID != null;
  }
  
  public String getRegion() {
    return this.region;
  }
  
  public A withRegion(String region) {
    this.region=region; return (A) this;
  }
  
  public boolean hasRegion() {
    return this.region != null;
  }
  
  public String getRegionEndpoint() {
    return this.regionEndpoint;
  }
  
  public A withRegionEndpoint(String regionEndpoint) {
    this.regionEndpoint=regionEndpoint; return (A) this;
  }
  
  public boolean hasRegionEndpoint() {
    return this.regionEndpoint != null;
  }
  
  public S3TrustedCASource buildTrustedCA() {
    return this.trustedCA!=null ?this.trustedCA.build():null;
  }
  
  public A withTrustedCA(S3TrustedCASource trustedCA) {
    _visitables.get("trustedCA").remove(this.trustedCA);
    if (trustedCA!=null){ this.trustedCA= new S3TrustedCASourceBuilder(trustedCA); _visitables.get("trustedCA").add(this.trustedCA);} else { this.trustedCA = null; _visitables.get("trustedCA").remove(this.trustedCA); } return (A) this;
  }
  
  public boolean hasTrustedCA() {
    return this.trustedCA != null;
  }
  
  public A withNewTrustedCA(String name) {
    return (A)withTrustedCA(new S3TrustedCASource(name));
  }
  
  public TrustedCANested<A> withNewTrustedCA() {
    return new TrustedCANested(null);
  }
  
  public TrustedCANested<A> withNewTrustedCALike(S3TrustedCASource item) {
    return new TrustedCANested(item);
  }
  
  public TrustedCANested<A> editTrustedCA() {
    return withNewTrustedCALike(java.util.Optional.ofNullable(buildTrustedCA()).orElse(null));
  }
  
  public TrustedCANested<A> editOrNewTrustedCA() {
    return withNewTrustedCALike(java.util.Optional.ofNullable(buildTrustedCA()).orElse(new S3TrustedCASourceBuilder().build()));
  }
  
  public TrustedCANested<A> editOrNewTrustedCALike(S3TrustedCASource item) {
    return withNewTrustedCALike(java.util.Optional.ofNullable(buildTrustedCA()).orElse(item));
  }
  
  public Boolean getVirtualHostedStyle() {
    return this.virtualHostedStyle;
  }
  
  public A withVirtualHostedStyle(Boolean virtualHostedStyle) {
    this.virtualHostedStyle=virtualHostedStyle; return (A) this;
  }
  
  public boolean hasVirtualHostedStyle() {
    return this.virtualHostedStyle != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ImageRegistryConfigStorageS3Fluent that = (ImageRegistryConfigStorageS3Fluent) o;
    if (!java.util.Objects.equals(bucket, that.bucket)) return false;
  
    if (!java.util.Objects.equals(cloudFront, that.cloudFront)) return false;
  
    if (!java.util.Objects.equals(encrypt, that.encrypt)) return false;
  
    if (!java.util.Objects.equals(keyID, that.keyID)) return false;
  
    if (!java.util.Objects.equals(region, that.region)) return false;
  
    if (!java.util.Objects.equals(regionEndpoint, that.regionEndpoint)) return false;
  
    if (!java.util.Objects.equals(trustedCA, that.trustedCA)) return false;
  
    if (!java.util.Objects.equals(virtualHostedStyle, that.virtualHostedStyle)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(bucket,  cloudFront,  encrypt,  keyID,  region,  regionEndpoint,  trustedCA,  virtualHostedStyle,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bucket != null) { sb.append("bucket:"); sb.append(bucket + ","); }
    if (cloudFront != null) { sb.append("cloudFront:"); sb.append(cloudFront + ","); }
    if (encrypt != null) { sb.append("encrypt:"); sb.append(encrypt + ","); }
    if (keyID != null) { sb.append("keyID:"); sb.append(keyID + ","); }
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (regionEndpoint != null) { sb.append("regionEndpoint:"); sb.append(regionEndpoint + ","); }
    if (trustedCA != null) { sb.append("trustedCA:"); sb.append(trustedCA + ","); }
    if (virtualHostedStyle != null) { sb.append("virtualHostedStyle:"); sb.append(virtualHostedStyle + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withEncrypt() {
    return withEncrypt(true);
  }
  
  public A withVirtualHostedStyle() {
    return withVirtualHostedStyle(true);
  }
  public class CloudFrontNested<N> extends ImageRegistryConfigStorageS3CloudFrontFluent<CloudFrontNested<N>> implements Nested<N>{
    CloudFrontNested(ImageRegistryConfigStorageS3CloudFront item) {
      this.builder = new ImageRegistryConfigStorageS3CloudFrontBuilder(this, item);
    }
    ImageRegistryConfigStorageS3CloudFrontBuilder builder;
    
    public N and() {
      return (N) ImageRegistryConfigStorageS3Fluent.this.withCloudFront(builder.build());
    }
    
    public N endCloudFront() {
      return and();
    }
    
  
  }
  public class TrustedCANested<N> extends S3TrustedCASourceFluent<TrustedCANested<N>> implements Nested<N>{
    TrustedCANested(S3TrustedCASource item) {
      this.builder = new S3TrustedCASourceBuilder(this, item);
    }
    S3TrustedCASourceBuilder builder;
    
    public N and() {
      return (N) ImageRegistryConfigStorageS3Fluent.this.withTrustedCA(builder.build());
    }
    
    public N endTrustedCA() {
      return and();
    }
    
  
  }

}