package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.Taint;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.SecretReference;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class BareMetalHostSpecFluent<A extends BareMetalHostSpecFluent<A>> extends BaseFluent<A>{
  public BareMetalHostSpecFluent() {
  }
  
  public BareMetalHostSpecFluent(BareMetalHostSpec instance) {
    this.copyInstance(instance);
  }
  private String architecture;
  private String automatedCleaningMode;
  private BMCDetailsBuilder bmc;
  private String bootMACAddress;
  private String bootMode;
  private ObjectReferenceBuilder consumerRef;
  private CustomDeployBuilder customDeploy;
  private String description;
  private Boolean externallyProvisioned;
  private FirmwareConfigBuilder firmware;
  private String hardwareProfile;
  private ImageBuilder image;
  private SecretReference metaData;
  private SecretReference networkData;
  private Boolean online;
  private String preprovisioningNetworkDataName;
  private RAIDConfigBuilder raid;
  private RootDeviceHintsBuilder rootDeviceHints;
  private List<Taint> taints = new ArrayList<Taint>();
  private SecretReference userData;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(BareMetalHostSpec instance) {
    instance = (instance != null ? instance : new BareMetalHostSpec());
  
    if (instance != null) {
        this.withArchitecture(instance.getArchitecture());
        this.withAutomatedCleaningMode(instance.getAutomatedCleaningMode());
        this.withBmc(instance.getBmc());
        this.withBootMACAddress(instance.getBootMACAddress());
        this.withBootMode(instance.getBootMode());
        this.withConsumerRef(instance.getConsumerRef());
        this.withCustomDeploy(instance.getCustomDeploy());
        this.withDescription(instance.getDescription());
        this.withExternallyProvisioned(instance.getExternallyProvisioned());
        this.withFirmware(instance.getFirmware());
        this.withHardwareProfile(instance.getHardwareProfile());
        this.withImage(instance.getImage());
        this.withMetaData(instance.getMetaData());
        this.withNetworkData(instance.getNetworkData());
        this.withOnline(instance.getOnline());
        this.withPreprovisioningNetworkDataName(instance.getPreprovisioningNetworkDataName());
        this.withRaid(instance.getRaid());
        this.withRootDeviceHints(instance.getRootDeviceHints());
        this.withTaints(instance.getTaints());
        this.withUserData(instance.getUserData());
        this.withArchitecture(instance.getArchitecture());
        this.withAutomatedCleaningMode(instance.getAutomatedCleaningMode());
        this.withBmc(instance.getBmc());
        this.withBootMACAddress(instance.getBootMACAddress());
        this.withBootMode(instance.getBootMode());
        this.withConsumerRef(instance.getConsumerRef());
        this.withCustomDeploy(instance.getCustomDeploy());
        this.withDescription(instance.getDescription());
        this.withExternallyProvisioned(instance.getExternallyProvisioned());
        this.withFirmware(instance.getFirmware());
        this.withHardwareProfile(instance.getHardwareProfile());
        this.withImage(instance.getImage());
        this.withMetaData(instance.getMetaData());
        this.withNetworkData(instance.getNetworkData());
        this.withOnline(instance.getOnline());
        this.withPreprovisioningNetworkDataName(instance.getPreprovisioningNetworkDataName());
        this.withRaid(instance.getRaid());
        this.withRootDeviceHints(instance.getRootDeviceHints());
        this.withTaints(instance.getTaints());
        this.withUserData(instance.getUserData());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public String getArchitecture() {
    return this.architecture;
  }
  
  public A withArchitecture(String architecture) {
    this.architecture=architecture; return (A) this;
  }
  
  public boolean hasArchitecture() {
    return this.architecture != null;
  }
  
  public String getAutomatedCleaningMode() {
    return this.automatedCleaningMode;
  }
  
  public A withAutomatedCleaningMode(String automatedCleaningMode) {
    this.automatedCleaningMode=automatedCleaningMode; return (A) this;
  }
  
  public boolean hasAutomatedCleaningMode() {
    return this.automatedCleaningMode != null;
  }
  
  public BMCDetails buildBmc() {
    return this.bmc!=null ?this.bmc.build():null;
  }
  
  public A withBmc(BMCDetails bmc) {
    _visitables.get("bmc").remove(this.bmc);
    if (bmc!=null){ this.bmc= new BMCDetailsBuilder(bmc); _visitables.get("bmc").add(this.bmc);} else { this.bmc = null; _visitables.get("bmc").remove(this.bmc); } return (A) this;
  }
  
  public boolean hasBmc() {
    return this.bmc != null;
  }
  
  public A withNewBmc(String address,String credentialsName,Boolean disableCertificateVerification) {
    return (A)withBmc(new BMCDetails(address, credentialsName, disableCertificateVerification));
  }
  
  public BmcNested<A> withNewBmc() {
    return new BmcNested(null);
  }
  
  public BmcNested<A> withNewBmcLike(BMCDetails item) {
    return new BmcNested(item);
  }
  
  public BmcNested<A> editBmc() {
    return withNewBmcLike(java.util.Optional.ofNullable(buildBmc()).orElse(null));
  }
  
  public BmcNested<A> editOrNewBmc() {
    return withNewBmcLike(java.util.Optional.ofNullable(buildBmc()).orElse(new BMCDetailsBuilder().build()));
  }
  
  public BmcNested<A> editOrNewBmcLike(BMCDetails item) {
    return withNewBmcLike(java.util.Optional.ofNullable(buildBmc()).orElse(item));
  }
  
  public String getBootMACAddress() {
    return this.bootMACAddress;
  }
  
  public A withBootMACAddress(String bootMACAddress) {
    this.bootMACAddress=bootMACAddress; return (A) this;
  }
  
  public boolean hasBootMACAddress() {
    return this.bootMACAddress != null;
  }
  
  public String getBootMode() {
    return this.bootMode;
  }
  
  public A withBootMode(String bootMode) {
    this.bootMode=bootMode; return (A) this;
  }
  
  public boolean hasBootMode() {
    return this.bootMode != null;
  }
  
  public ObjectReference buildConsumerRef() {
    return this.consumerRef!=null ?this.consumerRef.build():null;
  }
  
  public A withConsumerRef(ObjectReference consumerRef) {
    _visitables.get("consumerRef").remove(this.consumerRef);
    if (consumerRef!=null){ this.consumerRef= new ObjectReferenceBuilder(consumerRef); _visitables.get("consumerRef").add(this.consumerRef);} else { this.consumerRef = null; _visitables.get("consumerRef").remove(this.consumerRef); } return (A) this;
  }
  
  public boolean hasConsumerRef() {
    return this.consumerRef != null;
  }
  
  public ConsumerRefNested<A> withNewConsumerRef() {
    return new ConsumerRefNested(null);
  }
  
  public ConsumerRefNested<A> withNewConsumerRefLike(ObjectReference item) {
    return new ConsumerRefNested(item);
  }
  
  public ConsumerRefNested<A> editConsumerRef() {
    return withNewConsumerRefLike(java.util.Optional.ofNullable(buildConsumerRef()).orElse(null));
  }
  
  public ConsumerRefNested<A> editOrNewConsumerRef() {
    return withNewConsumerRefLike(java.util.Optional.ofNullable(buildConsumerRef()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public ConsumerRefNested<A> editOrNewConsumerRefLike(ObjectReference item) {
    return withNewConsumerRefLike(java.util.Optional.ofNullable(buildConsumerRef()).orElse(item));
  }
  
  public CustomDeploy buildCustomDeploy() {
    return this.customDeploy!=null ?this.customDeploy.build():null;
  }
  
  public A withCustomDeploy(CustomDeploy customDeploy) {
    _visitables.get("customDeploy").remove(this.customDeploy);
    if (customDeploy!=null){ this.customDeploy= new CustomDeployBuilder(customDeploy); _visitables.get("customDeploy").add(this.customDeploy);} else { this.customDeploy = null; _visitables.get("customDeploy").remove(this.customDeploy); } return (A) this;
  }
  
  public boolean hasCustomDeploy() {
    return this.customDeploy != null;
  }
  
  public A withNewCustomDeploy(String method) {
    return (A)withCustomDeploy(new CustomDeploy(method));
  }
  
  public CustomDeployNested<A> withNewCustomDeploy() {
    return new CustomDeployNested(null);
  }
  
  public CustomDeployNested<A> withNewCustomDeployLike(CustomDeploy item) {
    return new CustomDeployNested(item);
  }
  
  public CustomDeployNested<A> editCustomDeploy() {
    return withNewCustomDeployLike(java.util.Optional.ofNullable(buildCustomDeploy()).orElse(null));
  }
  
  public CustomDeployNested<A> editOrNewCustomDeploy() {
    return withNewCustomDeployLike(java.util.Optional.ofNullable(buildCustomDeploy()).orElse(new CustomDeployBuilder().build()));
  }
  
  public CustomDeployNested<A> editOrNewCustomDeployLike(CustomDeploy item) {
    return withNewCustomDeployLike(java.util.Optional.ofNullable(buildCustomDeploy()).orElse(item));
  }
  
  public String getDescription() {
    return this.description;
  }
  
  public A withDescription(String description) {
    this.description=description; return (A) this;
  }
  
  public boolean hasDescription() {
    return this.description != null;
  }
  
  public Boolean getExternallyProvisioned() {
    return this.externallyProvisioned;
  }
  
  public A withExternallyProvisioned(Boolean externallyProvisioned) {
    this.externallyProvisioned=externallyProvisioned; return (A) this;
  }
  
  public boolean hasExternallyProvisioned() {
    return this.externallyProvisioned != null;
  }
  
  public FirmwareConfig buildFirmware() {
    return this.firmware!=null ?this.firmware.build():null;
  }
  
  public A withFirmware(FirmwareConfig firmware) {
    _visitables.get("firmware").remove(this.firmware);
    if (firmware!=null){ this.firmware= new FirmwareConfigBuilder(firmware); _visitables.get("firmware").add(this.firmware);} else { this.firmware = null; _visitables.get("firmware").remove(this.firmware); } return (A) this;
  }
  
  public boolean hasFirmware() {
    return this.firmware != null;
  }
  
  public A withNewFirmware(Boolean simultaneousMultithreadingEnabled,Boolean sriovEnabled,Boolean virtualizationEnabled) {
    return (A)withFirmware(new FirmwareConfig(simultaneousMultithreadingEnabled, sriovEnabled, virtualizationEnabled));
  }
  
  public FirmwareNested<A> withNewFirmware() {
    return new FirmwareNested(null);
  }
  
  public FirmwareNested<A> withNewFirmwareLike(FirmwareConfig item) {
    return new FirmwareNested(item);
  }
  
  public FirmwareNested<A> editFirmware() {
    return withNewFirmwareLike(java.util.Optional.ofNullable(buildFirmware()).orElse(null));
  }
  
  public FirmwareNested<A> editOrNewFirmware() {
    return withNewFirmwareLike(java.util.Optional.ofNullable(buildFirmware()).orElse(new FirmwareConfigBuilder().build()));
  }
  
  public FirmwareNested<A> editOrNewFirmwareLike(FirmwareConfig item) {
    return withNewFirmwareLike(java.util.Optional.ofNullable(buildFirmware()).orElse(item));
  }
  
  public String getHardwareProfile() {
    return this.hardwareProfile;
  }
  
  public A withHardwareProfile(String hardwareProfile) {
    this.hardwareProfile=hardwareProfile; return (A) this;
  }
  
  public boolean hasHardwareProfile() {
    return this.hardwareProfile != null;
  }
  
  public Image buildImage() {
    return this.image!=null ?this.image.build():null;
  }
  
  public A withImage(Image image) {
    _visitables.get("image").remove(this.image);
    if (image!=null){ this.image= new ImageBuilder(image); _visitables.get("image").add(this.image);} else { this.image = null; _visitables.get("image").remove(this.image); } return (A) this;
  }
  
  public boolean hasImage() {
    return this.image != null;
  }
  
  public A withNewImage(String checksum,String checksumType,String format,String url) {
    return (A)withImage(new Image(checksum, checksumType, format, url));
  }
  
  public ImageNested<A> withNewImage() {
    return new ImageNested(null);
  }
  
  public ImageNested<A> withNewImageLike(Image item) {
    return new ImageNested(item);
  }
  
  public ImageNested<A> editImage() {
    return withNewImageLike(java.util.Optional.ofNullable(buildImage()).orElse(null));
  }
  
  public ImageNested<A> editOrNewImage() {
    return withNewImageLike(java.util.Optional.ofNullable(buildImage()).orElse(new ImageBuilder().build()));
  }
  
  public ImageNested<A> editOrNewImageLike(Image item) {
    return withNewImageLike(java.util.Optional.ofNullable(buildImage()).orElse(item));
  }
  
  public SecretReference getMetaData() {
    return this.metaData;
  }
  
  public A withMetaData(SecretReference metaData) {
    this.metaData=metaData; return (A) this;
  }
  
  public boolean hasMetaData() {
    return this.metaData != null;
  }
  
  public A withNewMetaData(String name,String namespace) {
    return (A)withMetaData(new SecretReference(name, namespace));
  }
  
  public SecretReference getNetworkData() {
    return this.networkData;
  }
  
  public A withNetworkData(SecretReference networkData) {
    this.networkData=networkData; return (A) this;
  }
  
  public boolean hasNetworkData() {
    return this.networkData != null;
  }
  
  public A withNewNetworkData(String name,String namespace) {
    return (A)withNetworkData(new SecretReference(name, namespace));
  }
  
  public Boolean getOnline() {
    return this.online;
  }
  
  public A withOnline(Boolean online) {
    this.online=online; return (A) this;
  }
  
  public boolean hasOnline() {
    return this.online != null;
  }
  
  public String getPreprovisioningNetworkDataName() {
    return this.preprovisioningNetworkDataName;
  }
  
  public A withPreprovisioningNetworkDataName(String preprovisioningNetworkDataName) {
    this.preprovisioningNetworkDataName=preprovisioningNetworkDataName; return (A) this;
  }
  
  public boolean hasPreprovisioningNetworkDataName() {
    return this.preprovisioningNetworkDataName != null;
  }
  
  public RAIDConfig buildRaid() {
    return this.raid!=null ?this.raid.build():null;
  }
  
  public A withRaid(RAIDConfig raid) {
    _visitables.get("raid").remove(this.raid);
    if (raid!=null){ this.raid= new RAIDConfigBuilder(raid); _visitables.get("raid").add(this.raid);} else { this.raid = null; _visitables.get("raid").remove(this.raid); } return (A) this;
  }
  
  public boolean hasRaid() {
    return this.raid != null;
  }
  
  public RaidNested<A> withNewRaid() {
    return new RaidNested(null);
  }
  
  public RaidNested<A> withNewRaidLike(RAIDConfig item) {
    return new RaidNested(item);
  }
  
  public RaidNested<A> editRaid() {
    return withNewRaidLike(java.util.Optional.ofNullable(buildRaid()).orElse(null));
  }
  
  public RaidNested<A> editOrNewRaid() {
    return withNewRaidLike(java.util.Optional.ofNullable(buildRaid()).orElse(new RAIDConfigBuilder().build()));
  }
  
  public RaidNested<A> editOrNewRaidLike(RAIDConfig item) {
    return withNewRaidLike(java.util.Optional.ofNullable(buildRaid()).orElse(item));
  }
  
  public RootDeviceHints buildRootDeviceHints() {
    return this.rootDeviceHints!=null ?this.rootDeviceHints.build():null;
  }
  
  public A withRootDeviceHints(RootDeviceHints rootDeviceHints) {
    _visitables.get("rootDeviceHints").remove(this.rootDeviceHints);
    if (rootDeviceHints!=null){ this.rootDeviceHints= new RootDeviceHintsBuilder(rootDeviceHints); _visitables.get("rootDeviceHints").add(this.rootDeviceHints);} else { this.rootDeviceHints = null; _visitables.get("rootDeviceHints").remove(this.rootDeviceHints); } return (A) this;
  }
  
  public boolean hasRootDeviceHints() {
    return this.rootDeviceHints != null;
  }
  
  public RootDeviceHintsNested<A> withNewRootDeviceHints() {
    return new RootDeviceHintsNested(null);
  }
  
  public RootDeviceHintsNested<A> withNewRootDeviceHintsLike(RootDeviceHints item) {
    return new RootDeviceHintsNested(item);
  }
  
  public RootDeviceHintsNested<A> editRootDeviceHints() {
    return withNewRootDeviceHintsLike(java.util.Optional.ofNullable(buildRootDeviceHints()).orElse(null));
  }
  
  public RootDeviceHintsNested<A> editOrNewRootDeviceHints() {
    return withNewRootDeviceHintsLike(java.util.Optional.ofNullable(buildRootDeviceHints()).orElse(new RootDeviceHintsBuilder().build()));
  }
  
  public RootDeviceHintsNested<A> editOrNewRootDeviceHintsLike(RootDeviceHints item) {
    return withNewRootDeviceHintsLike(java.util.Optional.ofNullable(buildRootDeviceHints()).orElse(item));
  }
  
  public A addToTaints(int index,Taint item) {
    if (this.taints == null) {this.taints = new ArrayList<Taint>();}
    this.taints.add(index, item);
    return (A)this;
  }
  
  public A setToTaints(int index,Taint item) {
    if (this.taints == null) {this.taints = new ArrayList<Taint>();}
    this.taints.set(index, item); return (A)this;
  }
  
  public A addToTaints(io.fabric8.kubernetes.api.model.Taint... items) {
    if (this.taints == null) {this.taints = new ArrayList<Taint>();}
    for (Taint item : items) {this.taints.add(item);} return (A)this;
  }
  
  public A addAllToTaints(Collection<Taint> items) {
    if (this.taints == null) {this.taints = new ArrayList<Taint>();}
    for (Taint item : items) {this.taints.add(item);} return (A)this;
  }
  
  public A removeFromTaints(io.fabric8.kubernetes.api.model.Taint... items) {
    if (this.taints == null) return (A)this;
    for (Taint item : items) { this.taints.remove(item);} return (A)this;
  }
  
  public A removeAllFromTaints(Collection<Taint> items) {
    if (this.taints == null) return (A)this;
    for (Taint item : items) { this.taints.remove(item);} return (A)this;
  }
  
  public List<Taint> getTaints() {
    return this.taints;
  }
  
  public Taint getTaint(int index) {
    return this.taints.get(index);
  }
  
  public Taint getFirstTaint() {
    return this.taints.get(0);
  }
  
  public Taint getLastTaint() {
    return this.taints.get(taints.size() - 1);
  }
  
  public Taint getMatchingTaint(Predicate<Taint> predicate) {
    for (Taint item: taints) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingTaint(Predicate<Taint> predicate) {
    for (Taint item: taints) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withTaints(List<Taint> taints) {
    if (taints != null) {this.taints = new ArrayList(); for (Taint item : taints){this.addToTaints(item);}} else { this.taints = null;} return (A) this;
  }
  
  public A withTaints(io.fabric8.kubernetes.api.model.Taint... taints) {
    if (this.taints != null) {this.taints.clear(); _visitables.remove("taints"); }
    if (taints != null) {for (Taint item :taints){ this.addToTaints(item);}} return (A) this;
  }
  
  public boolean hasTaints() {
    return taints != null && !taints.isEmpty();
  }
  
  public A addNewTaint(String effect,String key,String timeAdded,String value) {
    return (A)addToTaints(new Taint(effect, key, timeAdded, value));
  }
  
  public SecretReference getUserData() {
    return this.userData;
  }
  
  public A withUserData(SecretReference userData) {
    this.userData=userData; return (A) this;
  }
  
  public boolean hasUserData() {
    return this.userData != null;
  }
  
  public A withNewUserData(String name,String namespace) {
    return (A)withUserData(new SecretReference(name, namespace));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BareMetalHostSpecFluent that = (BareMetalHostSpecFluent) o;
    if (!java.util.Objects.equals(architecture, that.architecture)) return false;
  
    if (!java.util.Objects.equals(automatedCleaningMode, that.automatedCleaningMode)) return false;
  
    if (!java.util.Objects.equals(bmc, that.bmc)) return false;
  
    if (!java.util.Objects.equals(bootMACAddress, that.bootMACAddress)) return false;
  
    if (!java.util.Objects.equals(bootMode, that.bootMode)) return false;
  
    if (!java.util.Objects.equals(consumerRef, that.consumerRef)) return false;
  
    if (!java.util.Objects.equals(customDeploy, that.customDeploy)) return false;
  
    if (!java.util.Objects.equals(description, that.description)) return false;
  
    if (!java.util.Objects.equals(externallyProvisioned, that.externallyProvisioned)) return false;
  
    if (!java.util.Objects.equals(firmware, that.firmware)) return false;
  
    if (!java.util.Objects.equals(hardwareProfile, that.hardwareProfile)) return false;
  
    if (!java.util.Objects.equals(image, that.image)) return false;
  
    if (!java.util.Objects.equals(metaData, that.metaData)) return false;
  
    if (!java.util.Objects.equals(networkData, that.networkData)) return false;
  
    if (!java.util.Objects.equals(online, that.online)) return false;
  
    if (!java.util.Objects.equals(preprovisioningNetworkDataName, that.preprovisioningNetworkDataName)) return false;
  
    if (!java.util.Objects.equals(raid, that.raid)) return false;
  
    if (!java.util.Objects.equals(rootDeviceHints, that.rootDeviceHints)) return false;
  
    if (!java.util.Objects.equals(taints, that.taints)) return false;
  
    if (!java.util.Objects.equals(userData, that.userData)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(architecture,  automatedCleaningMode,  bmc,  bootMACAddress,  bootMode,  consumerRef,  customDeploy,  description,  externallyProvisioned,  firmware,  hardwareProfile,  image,  metaData,  networkData,  online,  preprovisioningNetworkDataName,  raid,  rootDeviceHints,  taints,  userData,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (architecture != null) { sb.append("architecture:"); sb.append(architecture + ","); }
    if (automatedCleaningMode != null) { sb.append("automatedCleaningMode:"); sb.append(automatedCleaningMode + ","); }
    if (bmc != null) { sb.append("bmc:"); sb.append(bmc + ","); }
    if (bootMACAddress != null) { sb.append("bootMACAddress:"); sb.append(bootMACAddress + ","); }
    if (bootMode != null) { sb.append("bootMode:"); sb.append(bootMode + ","); }
    if (consumerRef != null) { sb.append("consumerRef:"); sb.append(consumerRef + ","); }
    if (customDeploy != null) { sb.append("customDeploy:"); sb.append(customDeploy + ","); }
    if (description != null) { sb.append("description:"); sb.append(description + ","); }
    if (externallyProvisioned != null) { sb.append("externallyProvisioned:"); sb.append(externallyProvisioned + ","); }
    if (firmware != null) { sb.append("firmware:"); sb.append(firmware + ","); }
    if (hardwareProfile != null) { sb.append("hardwareProfile:"); sb.append(hardwareProfile + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (metaData != null) { sb.append("metaData:"); sb.append(metaData + ","); }
    if (networkData != null) { sb.append("networkData:"); sb.append(networkData + ","); }
    if (online != null) { sb.append("online:"); sb.append(online + ","); }
    if (preprovisioningNetworkDataName != null) { sb.append("preprovisioningNetworkDataName:"); sb.append(preprovisioningNetworkDataName + ","); }
    if (raid != null) { sb.append("raid:"); sb.append(raid + ","); }
    if (rootDeviceHints != null) { sb.append("rootDeviceHints:"); sb.append(rootDeviceHints + ","); }
    if (taints != null && !taints.isEmpty()) { sb.append("taints:"); sb.append(taints + ","); }
    if (userData != null) { sb.append("userData:"); sb.append(userData + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withExternallyProvisioned() {
    return withExternallyProvisioned(true);
  }
  
  public A withOnline() {
    return withOnline(true);
  }
  public class BmcNested<N> extends BMCDetailsFluent<BmcNested<N>> implements Nested<N>{
    BmcNested(BMCDetails item) {
      this.builder = new BMCDetailsBuilder(this, item);
    }
    BMCDetailsBuilder builder;
    
    public N and() {
      return (N) BareMetalHostSpecFluent.this.withBmc(builder.build());
    }
    
    public N endBmc() {
      return and();
    }
    
  
  }
  public class ConsumerRefNested<N> extends ObjectReferenceFluent<ConsumerRefNested<N>> implements Nested<N>{
    ConsumerRefNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) BareMetalHostSpecFluent.this.withConsumerRef(builder.build());
    }
    
    public N endConsumerRef() {
      return and();
    }
    
  
  }
  public class CustomDeployNested<N> extends CustomDeployFluent<CustomDeployNested<N>> implements Nested<N>{
    CustomDeployNested(CustomDeploy item) {
      this.builder = new CustomDeployBuilder(this, item);
    }
    CustomDeployBuilder builder;
    
    public N and() {
      return (N) BareMetalHostSpecFluent.this.withCustomDeploy(builder.build());
    }
    
    public N endCustomDeploy() {
      return and();
    }
    
  
  }
  public class FirmwareNested<N> extends FirmwareConfigFluent<FirmwareNested<N>> implements Nested<N>{
    FirmwareNested(FirmwareConfig item) {
      this.builder = new FirmwareConfigBuilder(this, item);
    }
    FirmwareConfigBuilder builder;
    
    public N and() {
      return (N) BareMetalHostSpecFluent.this.withFirmware(builder.build());
    }
    
    public N endFirmware() {
      return and();
    }
    
  
  }
  public class ImageNested<N> extends ImageFluent<ImageNested<N>> implements Nested<N>{
    ImageNested(Image item) {
      this.builder = new ImageBuilder(this, item);
    }
    ImageBuilder builder;
    
    public N and() {
      return (N) BareMetalHostSpecFluent.this.withImage(builder.build());
    }
    
    public N endImage() {
      return and();
    }
    
  
  }
  public class RaidNested<N> extends RAIDConfigFluent<RaidNested<N>> implements Nested<N>{
    RaidNested(RAIDConfig item) {
      this.builder = new RAIDConfigBuilder(this, item);
    }
    RAIDConfigBuilder builder;
    
    public N and() {
      return (N) BareMetalHostSpecFluent.this.withRaid(builder.build());
    }
    
    public N endRaid() {
      return and();
    }
    
  
  }
  public class RootDeviceHintsNested<N> extends RootDeviceHintsFluent<RootDeviceHintsNested<N>> implements Nested<N>{
    RootDeviceHintsNested(RootDeviceHints item) {
      this.builder = new RootDeviceHintsBuilder(this, item);
    }
    RootDeviceHintsBuilder builder;
    
    public N and() {
      return (N) BareMetalHostSpecFluent.this.withRootDeviceHints(builder.build());
    }
    
    public N endRootDeviceHints() {
      return and();
    }
    
  
  }

}