package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class BareMetalHostStatusFluent<A extends BareMetalHostStatusFluent<A>> extends BaseFluent<A>{
  public BareMetalHostStatusFluent() {
  }
  
  public BareMetalHostStatusFluent(BareMetalHostStatus instance) {
    this.copyInstance(instance);
  }
  private Integer errorCount;
  private String errorMessage;
  private String errorType;
  private CredentialsStatusBuilder goodCredentials;
  private HardwareDetailsBuilder hardware;
  private String hardwareProfile;
  private String lastUpdated;
  private OperationHistoryBuilder operationHistory;
  private String operationalStatus;
  private Boolean poweredOn;
  private ProvisionStatusBuilder provisioning;
  private CredentialsStatusBuilder triedCredentials;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(BareMetalHostStatus instance) {
    instance = (instance != null ? instance : new BareMetalHostStatus());
  
    if (instance != null) {
        this.withErrorCount(instance.getErrorCount());
        this.withErrorMessage(instance.getErrorMessage());
        this.withErrorType(instance.getErrorType());
        this.withGoodCredentials(instance.getGoodCredentials());
        this.withHardware(instance.getHardware());
        this.withHardwareProfile(instance.getHardwareProfile());
        this.withLastUpdated(instance.getLastUpdated());
        this.withOperationHistory(instance.getOperationHistory());
        this.withOperationalStatus(instance.getOperationalStatus());
        this.withPoweredOn(instance.getPoweredOn());
        this.withProvisioning(instance.getProvisioning());
        this.withTriedCredentials(instance.getTriedCredentials());
        this.withErrorCount(instance.getErrorCount());
        this.withErrorMessage(instance.getErrorMessage());
        this.withErrorType(instance.getErrorType());
        this.withGoodCredentials(instance.getGoodCredentials());
        this.withHardware(instance.getHardware());
        this.withHardwareProfile(instance.getHardwareProfile());
        this.withLastUpdated(instance.getLastUpdated());
        this.withOperationHistory(instance.getOperationHistory());
        this.withOperationalStatus(instance.getOperationalStatus());
        this.withPoweredOn(instance.getPoweredOn());
        this.withProvisioning(instance.getProvisioning());
        this.withTriedCredentials(instance.getTriedCredentials());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public Integer getErrorCount() {
    return this.errorCount;
  }
  
  public A withErrorCount(Integer errorCount) {
    this.errorCount=errorCount; return (A) this;
  }
  
  public boolean hasErrorCount() {
    return this.errorCount != null;
  }
  
  public String getErrorMessage() {
    return this.errorMessage;
  }
  
  public A withErrorMessage(String errorMessage) {
    this.errorMessage=errorMessage; return (A) this;
  }
  
  public boolean hasErrorMessage() {
    return this.errorMessage != null;
  }
  
  public String getErrorType() {
    return this.errorType;
  }
  
  public A withErrorType(String errorType) {
    this.errorType=errorType; return (A) this;
  }
  
  public boolean hasErrorType() {
    return this.errorType != null;
  }
  
  public CredentialsStatus buildGoodCredentials() {
    return this.goodCredentials!=null ?this.goodCredentials.build():null;
  }
  
  public A withGoodCredentials(CredentialsStatus goodCredentials) {
    _visitables.get("goodCredentials").remove(this.goodCredentials);
    if (goodCredentials!=null){ this.goodCredentials= new CredentialsStatusBuilder(goodCredentials); _visitables.get("goodCredentials").add(this.goodCredentials);} else { this.goodCredentials = null; _visitables.get("goodCredentials").remove(this.goodCredentials); } return (A) this;
  }
  
  public boolean hasGoodCredentials() {
    return this.goodCredentials != null;
  }
  
  public GoodCredentialsNested<A> withNewGoodCredentials() {
    return new GoodCredentialsNested(null);
  }
  
  public GoodCredentialsNested<A> withNewGoodCredentialsLike(CredentialsStatus item) {
    return new GoodCredentialsNested(item);
  }
  
  public GoodCredentialsNested<A> editGoodCredentials() {
    return withNewGoodCredentialsLike(java.util.Optional.ofNullable(buildGoodCredentials()).orElse(null));
  }
  
  public GoodCredentialsNested<A> editOrNewGoodCredentials() {
    return withNewGoodCredentialsLike(java.util.Optional.ofNullable(buildGoodCredentials()).orElse(new CredentialsStatusBuilder().build()));
  }
  
  public GoodCredentialsNested<A> editOrNewGoodCredentialsLike(CredentialsStatus item) {
    return withNewGoodCredentialsLike(java.util.Optional.ofNullable(buildGoodCredentials()).orElse(item));
  }
  
  public HardwareDetails buildHardware() {
    return this.hardware!=null ?this.hardware.build():null;
  }
  
  public A withHardware(HardwareDetails hardware) {
    _visitables.get("hardware").remove(this.hardware);
    if (hardware!=null){ this.hardware= new HardwareDetailsBuilder(hardware); _visitables.get("hardware").add(this.hardware);} else { this.hardware = null; _visitables.get("hardware").remove(this.hardware); } return (A) this;
  }
  
  public boolean hasHardware() {
    return this.hardware != null;
  }
  
  public HardwareNested<A> withNewHardware() {
    return new HardwareNested(null);
  }
  
  public HardwareNested<A> withNewHardwareLike(HardwareDetails item) {
    return new HardwareNested(item);
  }
  
  public HardwareNested<A> editHardware() {
    return withNewHardwareLike(java.util.Optional.ofNullable(buildHardware()).orElse(null));
  }
  
  public HardwareNested<A> editOrNewHardware() {
    return withNewHardwareLike(java.util.Optional.ofNullable(buildHardware()).orElse(new HardwareDetailsBuilder().build()));
  }
  
  public HardwareNested<A> editOrNewHardwareLike(HardwareDetails item) {
    return withNewHardwareLike(java.util.Optional.ofNullable(buildHardware()).orElse(item));
  }
  
  public String getHardwareProfile() {
    return this.hardwareProfile;
  }
  
  public A withHardwareProfile(String hardwareProfile) {
    this.hardwareProfile=hardwareProfile; return (A) this;
  }
  
  public boolean hasHardwareProfile() {
    return this.hardwareProfile != null;
  }
  
  public String getLastUpdated() {
    return this.lastUpdated;
  }
  
  public A withLastUpdated(String lastUpdated) {
    this.lastUpdated=lastUpdated; return (A) this;
  }
  
  public boolean hasLastUpdated() {
    return this.lastUpdated != null;
  }
  
  public OperationHistory buildOperationHistory() {
    return this.operationHistory!=null ?this.operationHistory.build():null;
  }
  
  public A withOperationHistory(OperationHistory operationHistory) {
    _visitables.get("operationHistory").remove(this.operationHistory);
    if (operationHistory!=null){ this.operationHistory= new OperationHistoryBuilder(operationHistory); _visitables.get("operationHistory").add(this.operationHistory);} else { this.operationHistory = null; _visitables.get("operationHistory").remove(this.operationHistory); } return (A) this;
  }
  
  public boolean hasOperationHistory() {
    return this.operationHistory != null;
  }
  
  public OperationHistoryNested<A> withNewOperationHistory() {
    return new OperationHistoryNested(null);
  }
  
  public OperationHistoryNested<A> withNewOperationHistoryLike(OperationHistory item) {
    return new OperationHistoryNested(item);
  }
  
  public OperationHistoryNested<A> editOperationHistory() {
    return withNewOperationHistoryLike(java.util.Optional.ofNullable(buildOperationHistory()).orElse(null));
  }
  
  public OperationHistoryNested<A> editOrNewOperationHistory() {
    return withNewOperationHistoryLike(java.util.Optional.ofNullable(buildOperationHistory()).orElse(new OperationHistoryBuilder().build()));
  }
  
  public OperationHistoryNested<A> editOrNewOperationHistoryLike(OperationHistory item) {
    return withNewOperationHistoryLike(java.util.Optional.ofNullable(buildOperationHistory()).orElse(item));
  }
  
  public String getOperationalStatus() {
    return this.operationalStatus;
  }
  
  public A withOperationalStatus(String operationalStatus) {
    this.operationalStatus=operationalStatus; return (A) this;
  }
  
  public boolean hasOperationalStatus() {
    return this.operationalStatus != null;
  }
  
  public Boolean getPoweredOn() {
    return this.poweredOn;
  }
  
  public A withPoweredOn(Boolean poweredOn) {
    this.poweredOn=poweredOn; return (A) this;
  }
  
  public boolean hasPoweredOn() {
    return this.poweredOn != null;
  }
  
  public ProvisionStatus buildProvisioning() {
    return this.provisioning!=null ?this.provisioning.build():null;
  }
  
  public A withProvisioning(ProvisionStatus provisioning) {
    _visitables.get("provisioning").remove(this.provisioning);
    if (provisioning!=null){ this.provisioning= new ProvisionStatusBuilder(provisioning); _visitables.get("provisioning").add(this.provisioning);} else { this.provisioning = null; _visitables.get("provisioning").remove(this.provisioning); } return (A) this;
  }
  
  public boolean hasProvisioning() {
    return this.provisioning != null;
  }
  
  public ProvisioningNested<A> withNewProvisioning() {
    return new ProvisioningNested(null);
  }
  
  public ProvisioningNested<A> withNewProvisioningLike(ProvisionStatus item) {
    return new ProvisioningNested(item);
  }
  
  public ProvisioningNested<A> editProvisioning() {
    return withNewProvisioningLike(java.util.Optional.ofNullable(buildProvisioning()).orElse(null));
  }
  
  public ProvisioningNested<A> editOrNewProvisioning() {
    return withNewProvisioningLike(java.util.Optional.ofNullable(buildProvisioning()).orElse(new ProvisionStatusBuilder().build()));
  }
  
  public ProvisioningNested<A> editOrNewProvisioningLike(ProvisionStatus item) {
    return withNewProvisioningLike(java.util.Optional.ofNullable(buildProvisioning()).orElse(item));
  }
  
  public CredentialsStatus buildTriedCredentials() {
    return this.triedCredentials!=null ?this.triedCredentials.build():null;
  }
  
  public A withTriedCredentials(CredentialsStatus triedCredentials) {
    _visitables.get("triedCredentials").remove(this.triedCredentials);
    if (triedCredentials!=null){ this.triedCredentials= new CredentialsStatusBuilder(triedCredentials); _visitables.get("triedCredentials").add(this.triedCredentials);} else { this.triedCredentials = null; _visitables.get("triedCredentials").remove(this.triedCredentials); } return (A) this;
  }
  
  public boolean hasTriedCredentials() {
    return this.triedCredentials != null;
  }
  
  public TriedCredentialsNested<A> withNewTriedCredentials() {
    return new TriedCredentialsNested(null);
  }
  
  public TriedCredentialsNested<A> withNewTriedCredentialsLike(CredentialsStatus item) {
    return new TriedCredentialsNested(item);
  }
  
  public TriedCredentialsNested<A> editTriedCredentials() {
    return withNewTriedCredentialsLike(java.util.Optional.ofNullable(buildTriedCredentials()).orElse(null));
  }
  
  public TriedCredentialsNested<A> editOrNewTriedCredentials() {
    return withNewTriedCredentialsLike(java.util.Optional.ofNullable(buildTriedCredentials()).orElse(new CredentialsStatusBuilder().build()));
  }
  
  public TriedCredentialsNested<A> editOrNewTriedCredentialsLike(CredentialsStatus item) {
    return withNewTriedCredentialsLike(java.util.Optional.ofNullable(buildTriedCredentials()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BareMetalHostStatusFluent that = (BareMetalHostStatusFluent) o;
    if (!java.util.Objects.equals(errorCount, that.errorCount)) return false;
  
    if (!java.util.Objects.equals(errorMessage, that.errorMessage)) return false;
  
    if (!java.util.Objects.equals(errorType, that.errorType)) return false;
  
    if (!java.util.Objects.equals(goodCredentials, that.goodCredentials)) return false;
  
    if (!java.util.Objects.equals(hardware, that.hardware)) return false;
  
    if (!java.util.Objects.equals(hardwareProfile, that.hardwareProfile)) return false;
  
    if (!java.util.Objects.equals(lastUpdated, that.lastUpdated)) return false;
  
    if (!java.util.Objects.equals(operationHistory, that.operationHistory)) return false;
  
    if (!java.util.Objects.equals(operationalStatus, that.operationalStatus)) return false;
  
    if (!java.util.Objects.equals(poweredOn, that.poweredOn)) return false;
  
    if (!java.util.Objects.equals(provisioning, that.provisioning)) return false;
  
    if (!java.util.Objects.equals(triedCredentials, that.triedCredentials)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(errorCount,  errorMessage,  errorType,  goodCredentials,  hardware,  hardwareProfile,  lastUpdated,  operationHistory,  operationalStatus,  poweredOn,  provisioning,  triedCredentials,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (errorCount != null) { sb.append("errorCount:"); sb.append(errorCount + ","); }
    if (errorMessage != null) { sb.append("errorMessage:"); sb.append(errorMessage + ","); }
    if (errorType != null) { sb.append("errorType:"); sb.append(errorType + ","); }
    if (goodCredentials != null) { sb.append("goodCredentials:"); sb.append(goodCredentials + ","); }
    if (hardware != null) { sb.append("hardware:"); sb.append(hardware + ","); }
    if (hardwareProfile != null) { sb.append("hardwareProfile:"); sb.append(hardwareProfile + ","); }
    if (lastUpdated != null) { sb.append("lastUpdated:"); sb.append(lastUpdated + ","); }
    if (operationHistory != null) { sb.append("operationHistory:"); sb.append(operationHistory + ","); }
    if (operationalStatus != null) { sb.append("operationalStatus:"); sb.append(operationalStatus + ","); }
    if (poweredOn != null) { sb.append("poweredOn:"); sb.append(poweredOn + ","); }
    if (provisioning != null) { sb.append("provisioning:"); sb.append(provisioning + ","); }
    if (triedCredentials != null) { sb.append("triedCredentials:"); sb.append(triedCredentials + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withPoweredOn() {
    return withPoweredOn(true);
  }
  public class GoodCredentialsNested<N> extends CredentialsStatusFluent<GoodCredentialsNested<N>> implements Nested<N>{
    GoodCredentialsNested(CredentialsStatus item) {
      this.builder = new CredentialsStatusBuilder(this, item);
    }
    CredentialsStatusBuilder builder;
    
    public N and() {
      return (N) BareMetalHostStatusFluent.this.withGoodCredentials(builder.build());
    }
    
    public N endGoodCredentials() {
      return and();
    }
    
  
  }
  public class HardwareNested<N> extends HardwareDetailsFluent<HardwareNested<N>> implements Nested<N>{
    HardwareNested(HardwareDetails item) {
      this.builder = new HardwareDetailsBuilder(this, item);
    }
    HardwareDetailsBuilder builder;
    
    public N and() {
      return (N) BareMetalHostStatusFluent.this.withHardware(builder.build());
    }
    
    public N endHardware() {
      return and();
    }
    
  
  }
  public class OperationHistoryNested<N> extends OperationHistoryFluent<OperationHistoryNested<N>> implements Nested<N>{
    OperationHistoryNested(OperationHistory item) {
      this.builder = new OperationHistoryBuilder(this, item);
    }
    OperationHistoryBuilder builder;
    
    public N and() {
      return (N) BareMetalHostStatusFluent.this.withOperationHistory(builder.build());
    }
    
    public N endOperationHistory() {
      return and();
    }
    
  
  }
  public class ProvisioningNested<N> extends ProvisionStatusFluent<ProvisioningNested<N>> implements Nested<N>{
    ProvisioningNested(ProvisionStatus item) {
      this.builder = new ProvisionStatusBuilder(this, item);
    }
    ProvisionStatusBuilder builder;
    
    public N and() {
      return (N) BareMetalHostStatusFluent.this.withProvisioning(builder.build());
    }
    
    public N endProvisioning() {
      return and();
    }
    
  
  }
  public class TriedCredentialsNested<N> extends CredentialsStatusFluent<TriedCredentialsNested<N>> implements Nested<N>{
    TriedCredentialsNested(CredentialsStatus item) {
      this.builder = new CredentialsStatusBuilder(this, item);
    }
    CredentialsStatusBuilder builder;
    
    public N and() {
      return (N) BareMetalHostStatusFluent.this.withTriedCredentials(builder.build());
    }
    
    public N endTriedCredentials() {
      return and();
    }
    
  
  }

}